/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationImpl;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.branch.VcsBranchDao;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BranchExpiryJob
implements Job {
    private static final Logger log = Logger.getLogger(BranchExpiryJob.class);
    private PlanManager planManager;
    private DeletionService deletionService;
    private ErrorUpdateHandler errorUpdateHandler;
    private BranchCommitInformationManager branchCommitInformationManager;
    private CachedPlanManager cachedPlanManager;
    private VcsBranchDao vcsBranchDao;
    private CustomVariableContext customVariableContext;
    private VcsRepositoryManager vcsRepositoryManager;

    private static Predicate<BambooVcsBranch> isVcsBranchWithNameAndChainIdEqual(@NotNull String vcsBranchName, long chainId) {
        return input -> chainId == input.getChainId() && input.isEqualToBranchWith(vcsBranchName);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info((Object)"Branch expiry started.");
        this.cleanUpExpiredVcsBranches();
        this.cleanupExpiredDueToInactivity();
        log.info((Object)"Branch expiry finished.");
    }

    private void cleanupExpiredDueToInactivity() {
        log.info((Object)"Cleaning up inactive branches...");
        this.getPlansWithCleanupEnabledForInactivity().forEach(this::cleanupExpiredDueToInactivity);
        log.info((Object)"Finished cleaning up inactive branches");
    }

    @VisibleForTesting
    protected void cleanupExpiredDueToInactivity(ImmutableChain chain) {
        int timeOfInactivityInDays = chain.getBuildDefinition().getBranchMonitoringConfiguration().getInactiveBranchCleanUpPeriodInDays();
        Date thresholdDate = DateUtils.truncate((Date)new Date(System.currentTimeMillis() - 86400000L * (long)timeOfInactivityInDays), (int)5);
        log.info((Object)("Checking branches of plan " + chain.getName() + ", the threshold date is " + thresholdDate));
        Iterable branchesToBeCleaned = this.cachedPlanManager.getBranchesForChain((PlanIdentifier)chain).stream().filter(input -> {
            BranchSpecificConfiguration branchSpecificConfiguration = input.getBuildDefinition().getBranchSpecificConfiguration();
            return !branchSpecificConfiguration.isBranchCleanupDisabled() && timeOfInactivityInDays > 0;
        }).collect(Collectors.toList());
        ArrayList failedBranchKeys = new ArrayList();
        for (ImmutableChainBranch chainBranch : branchesToBeCleaned) {
            if (thresholdDate.before(chainBranch.getCreationDate())) {
                log.debug((Object)(chainBranch.getPlanKey() + " is created recently and should be considered active (simplified expiry check)"));
                continue;
            }
            if (this.hasRegisteredCommitsAfter(chainBranch, thresholdDate)) {
                log.debug((Object)(chainBranch.getPlanKey() + " is active (simplified expiry check)"));
                continue;
            }
            this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)chainBranch), () -> {
                PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)Iterables.getFirst((Iterable)chainBranch.getPlanRepositoryDefinitions(), null);
                if (repositoryDefinition == null) {
                    log.error((Object)("Default repository of branch " + chainBranch.getName() + " does not exist.  Can not check for for branch expiry"));
                    this.errorUpdateHandler.recordError("Default repository of branch " + chainBranch.getName() + " does not exist.  Can not check for for branch expiry");
                    return;
                }
                VcsRepositoryModuleDescriptor repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                if (repositoryModuleDescriptor == null || !repositoryModuleDescriptor.supportsBranchDetection()) {
                    log.error((Object)("Default repository of branch " + chainBranch.getName() + " is not supported by Chain Branch feature.  Skipping expiry check"));
                    failedBranchKeys.add(chainBranch.getPlanKey());
                    return;
                }
                try {
                    Date lastCommitDate;
                    CommitContext lastCommit = repositoryModuleDescriptor.getBranchDetector().getLastCommit((VcsRepositoryData)repositoryDefinition);
                    Date date = lastCommitDate = lastCommit != null ? lastCommit.getDate() : null;
                    if (lastCommitDate == null) {
                        log.warn((Object)("Unknown last commit date returned by repository " + repositoryDefinition.getName() + " in Chain Branch " + chainBranch.getName()));
                        return;
                    }
                    log.debug((Object)("Last commit date for plan branch " + chainBranch.getName() + " is " + lastCommitDate));
                    if (thresholdDate.after(lastCommitDate)) {
                        log.info((Object)("Deleting Chain Branch " + chainBranch.getName() + " of Plan " + chain.getName() + " since last commit date is " + lastCommitDate));
                        this.deleteMutableRepresentationOfBranch(chainBranch);
                    } else {
                        BranchCommitInformation bci = chainBranch.getCommitInformation();
                        if (bci == null) {
                            bci = new BranchCommitInformationImpl(chainBranch.getId());
                        }
                        if (!Objects.equal((Object)lastCommit.getChangeSetId(), (Object)bci.getLatestCommitChangeSetId())) {
                            this.branchCommitInformationManager.save(this.branchCommitInformationManager.updateLatestCommitInformation(bci, lastCommit));
                        }
                    }
                }
                catch (Exception e) {
                    log.info((Object)("Branch for [" + chainBranch.getName() + "] has been removed from the VCS repo. Expiration will be based on stored data about latest commit (inactivity cleanup)."));
                    this.expireBranchRemovedFromVcs(chainBranch, thresholdDate);
                }
            });
        }
        if (!failedBranchKeys.isEmpty()) {
            this.errorUpdateHandler.recordError((Key)chain.getPlanKey(), "Failed to check the following branches for recent activity. Please check the logs for more details. " + Joiner.on((String)", ").join(failedBranchKeys));
        }
    }

    private void expireBranchRemovedFromVcs(ImmutableChainBranch chainBranch, Date thresholdDate) {
        Date decisionDate;
        BranchCommitInformation bci = chainBranch.getCommitInformation();
        Date date = decisionDate = bci != null ? bci.getLatestCommitDate() : null;
        if (decisionDate == null) {
            log.debug((Object)"No existing commit information: using last build date");
            ImmutableResultsSummary resultsSummary = chainBranch.getLatestResultsSummary();
            Date date2 = decisionDate = resultsSummary != null ? resultsSummary.getBuildDate() : null;
        }
        if (decisionDate == null) {
            log.debug((Object)"No build results: using plan creation date");
            decisionDate = chainBranch.getCreationDate();
        }
        if (decisionDate != null) {
            if (thresholdDate.after(decisionDate)) {
                log.info((Object)("Deleting Plan Branch " + chainBranch.getName() + " of Plan " + chainBranch.getMaster().getName() + " since repository is invalid and last registered use of the branch is " + decisionDate));
                this.deleteMutableRepresentationOfBranch(chainBranch);
            }
        } else {
            log.warn((Object)("Plan Branch " + chainBranch.getPlanKey() + " does not provide any meaningful date to base expiration on"));
        }
    }

    private void deleteMutableRepresentationOfBranch(ImmutableChainBranch chainBranch) {
        Plan mutableBranch = this.planManager.getPlanById(chainBranch.getId());
        if (mutableBranch != null) {
            try {
                this.deletionService.deletePlan(mutableBranch);
            }
            catch (RuntimeException e) {
                log.warn((Object)("Unable to delete chain branch " + chainBranch.getPlanKey()), (Throwable)e);
            }
        }
    }

    protected void cleanUpExpiredVcsBranches() {
        log.info((Object)"Cleaning up VCS branches detected as deleted...");
        Iterable<ImmutableTopLevelPlan> plans = this.getPlansWithCleanupEnabledForBranchDeleted();
        List deletedVcsBranchList = this.vcsBranchDao.findWithDetectedDeletionDate();
        for (ImmutableTopLevelPlan plan : plans) {
            List chainBranchList = this.cachedPlanManager.getBranchesForChain((PlanIdentifier)plan);
            for (ImmutableChainBranch chainBranch : chainBranchList) {
                String vcsBranchName = this.getVsBranchName(chainBranch);
                if (vcsBranchName == null) continue;
                List vcsBranchList = deletedVcsBranchList.stream().filter(BranchExpiryJob.isVcsBranchWithNameAndChainIdEqual(vcsBranchName, plan.getId())).collect(Collectors.toList());
                for (BambooVcsBranch vcsBranch : vcsBranchList) {
                    Date detectedDeletionDate;
                    BranchMonitoringConfiguration branchMonitoringConfiguration = chainBranch.getBuildDefinition().getBranchMonitoringConfiguration();
                    BranchSpecificConfiguration branchConfiguration = chainBranch.getBuildDefinition().getBranchSpecificConfiguration();
                    if (branchConfiguration.isBranchCleanupDisabled()) {
                        log.debug((Object)String.format("Branch [%s] used in plan [%s] was deleted in the VCS but it's not configured to be removed", vcsBranch.getName(), chainBranch.getName()));
                        continue;
                    }
                    int configuredCleanUpPeriodDays = branchMonitoringConfiguration.getRemovedBranchCleanUpPeriodInDays();
                    Date thresholdDate = DateUtils.truncate((Date)new Date(System.currentTimeMillis() - 86400000L * (long)configuredCleanUpPeriodDays), (int)5);
                    if (thresholdDate.after(detectedDeletionDate = vcsBranch.getDetectedDeletionDate()) || DateUtils.isSameDay((Date)thresholdDate, (Date)detectedDeletionDate)) {
                        log.info((Object)String.format("Deleting Plan Branch '%s' of Plan '%s' since the VCS branch was deleted more than %s days ago.", chainBranch.getName(), plan.getName(), configuredCleanUpPeriodDays));
                        this.deleteMutableRepresentationOfBranch(chainBranch);
                        continue;
                    }
                    log.debug((Object)String.format("Branch [%s] used in plan '%s' was detected as deleted on '%s' but it's configured to be deleted after %s days", vcsBranch.getName(), chainBranch.getName(), detectedDeletionDate, configuredCleanUpPeriodDays));
                }
            }
        }
        log.info((Object)"Finished cleaning up deleted branches");
    }

    private Iterable<ImmutableTopLevelPlan> getPlansWithCleanupEnabledForBranchDeleted() {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class, input -> input.getBuildDefinition().getBranchMonitoringConfiguration().isRemovedBranchCleanUpEnabled());
    }

    private List<ImmutableTopLevelPlan> getPlansWithCleanupEnabledForInactivity() {
        return this.cachedPlanManager.getPlans(ImmutableTopLevelPlan.class, input -> input.getBuildDefinition().getBranchMonitoringConfiguration().isInactiveBranchCleanUpEnabled());
    }

    @VisibleForTesting
    String getVsBranchName(ImmutableChainBranch chainBranch) {
        return ChainBranchUtils.getSubstitutedVcsBranchName(this.customVariableContext, (ImmutablePlan)chainBranch);
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setDeletionService(DeletionService deletionService) {
        this.deletionService = deletionService;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    public void setBranchCommitInformationManager(BranchCommitInformationManager branchCommitInformationManager) {
        this.branchCommitInformationManager = branchCommitInformationManager;
    }

    public void setVcsBranchDao(VcsBranchDao vcsBranchDao) {
        this.vcsBranchDao = vcsBranchDao;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public boolean hasRegisteredCommitsAfter(ImmutableChainBranch chainBranch, Date thresholdDate) {
        BranchCommitInformation commitInformation = chainBranch.getCommitInformation();
        if (commitInformation == null) {
            return false;
        }
        Date latestCommitDate = commitInformation.getLatestCommitDate();
        if (latestCommitDate == null) {
            return false;
        }
        return latestCommitDate.after(thresholdDate);
    }
}

