/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.plan.branch.BranchExpiryJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.utils.SystemProperty;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class BranchExpiryScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(BranchExpiryScheduler.class);
    public static final String BRANCH_EXPIRY_JOB = "branchExpiryJob";
    public static final String BRANCH_EXPIRY_GROUP = "branchExpiryGroup";
    private static final String BRANCH_EXPIRY_TRIGGER = "branchExpiryTrigger";
    private static final LocalTime BRANCH_EXPIRY_DEFAULT_TIME = LocalTime.of(3, 0);
    private final Scheduler quartzScheduler;

    public BranchExpiryScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(new TriggerKey(BRANCH_EXPIRY_JOB, BRANCH_EXPIRY_GROUP));
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            JobKey jobKey = new JobKey(BRANCH_EXPIRY_JOB, BRANCH_EXPIRY_GROUP);
            JobDetail jobDetail = JobBuilder.newJob(BranchExpiryJob.class).withIdentity(jobKey).build();
            LocalTime branchExpiryScheduledTime = this.getBranchExpiryScheduledTime();
            trigger = TriggerBuilder.newTrigger().withIdentity(BRANCH_EXPIRY_TRIGGER).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)branchExpiryScheduledTime.getHour(), (int)branchExpiryScheduledTime.getMinute())).build();
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)String.format("Branch expiry running daily at %s", branchExpiryScheduledTime));
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule branchExpiryJob", (Throwable)e);
        }
    }

    private LocalTime getBranchExpiryScheduledTime() {
        SystemProperty property = SystemProperty.BRANCH_EXPIRY_SCHEDULED_TIME;
        String propertyValue = property.getValue();
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            try {
                return LocalTime.parse(propertyValue).truncatedTo(ChronoUnit.MINUTES);
            }
            catch (DateTimeParseException e) {
                log.warn((Object)String.format("Unable to parse system property %s value %s, assuming default schedule", property.getKey(), propertyValue));
            }
        }
        return BRANCH_EXPIRY_DEFAULT_TIME;
    }
}

