/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationStrategy;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchIntegrationConfigurationImpl
implements BranchIntegrationConfiguration {
    private static final Logger log = Logger.getLogger(BranchIntegrationConfigurationImpl.class);
    private static final String INTEGRATION_ENABLED = "enabled";
    private static final String INTEGRATION_STRATEGY = "strategy";
    private static final String INTEGRATION_BRANCH_UPDATER_MERGE_FROM_BRANCH = "branchUpdater.mergeFromBranch";
    @VisibleForTesting
    public static final String INTEGRATION_BRANCH_UPDATER_MERGE_FROM_VCS_BRANCH = "branchUpdater.mergeFromVcsReference";
    private static final String INTEGRATION_GATE_KEEPER_CHECKOUT_BRANCH = "gateKeeper.checkoutBranch";
    private static final String[] INTEGRATION_PUSH_ENABLED = new String[]{"branchUpdater.pushEnabled", "gateKeeper.pushEnabled"};
    public static final String BRANCH_INTEGRATION_PREFIX = "branchIntegration";
    public static final String BRANCHES_PREFIX = "branches";
    private static final String DEFAULT_CONFIGURATION_PREFIX = "branches.defaultBranchIntegration";
    private boolean enabled;
    private BranchIntegrationStrategy strategy;
    private BranchIntegrationPoint branchIntegrationPoint;
    private boolean isValid = false;
    private boolean pushEnabled;
    private boolean isDefaultConfiguration;

    public BranchIntegrationConfigurationImpl() {
        this(false);
    }

    public BranchIntegrationConfigurationImpl(boolean aDefaultConfiguration) {
        this.isDefaultConfiguration = aDefaultConfiguration;
        this.branchIntegrationPoint = new BranchIntegrationPointImpl(null, null);
    }

    public BranchIntegrationConfigurationImpl(BranchIntegrationConfiguration other, boolean isDefaultConfiguration, boolean pushEnabled) {
        this.isDefaultConfiguration = isDefaultConfiguration;
        this.isValid = other.isValid();
        this.enabled = other.isEnabled();
        this.strategy = other.getStrategy();
        this.branchIntegrationPoint = new BranchIntegrationPointImpl(other.getIntegrationPoint());
        this.pushEnabled = pushEnabled;
    }

    public BranchIntegrationConfigurationImpl(BranchIntegrationConfiguration other, boolean isDefaultConfiguration) {
        this(other, isDefaultConfiguration, other.isPushEnabled());
    }

    @Deprecated
    public BranchIntegrationConfigurationImpl(BranchIntegrationStrategy strategy, PlanKey integrationPlanKey, boolean pushEnabled) {
        this(true, strategy, BranchIntegrationPointImpl.forPlanBranch(integrationPlanKey), pushEnabled, false);
    }

    public BranchIntegrationConfigurationImpl(boolean enabled, BranchIntegrationStrategy strategy, BranchIntegrationPoint branchIntegrationPoint, boolean pushEnabled, boolean isDefaultConfiguration) {
        this.enabled = enabled;
        this.strategy = strategy;
        this.branchIntegrationPoint = branchIntegrationPoint;
        this.isValid = true;
        this.pushEnabled = pushEnabled;
        this.isDefaultConfiguration = isDefaultConfiguration;
    }

    public static boolean hasConfiguration(BuildConfiguration buildConfiguration) {
        return !buildConfiguration.configurationsAt("branchIntegration.").isEmpty();
    }

    @Nullable
    public PlanKey getIntegrationPlanBranchKey() {
        return this.getIntegrationPoint().getIntegrationPlanBranchKey();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public BranchIntegrationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled;
    }

    @NotNull
    public PlanKey getMergeResultDestinationBranch(@NotNull PlanKey planBranch) {
        return this.strategy == BranchIntegrationStrategy.BRANCH_UPDATER ? planBranch : this.getIntegrationPoint().getIntegrationPlanBranchKey();
    }

    @Nullable
    public PlanKey getBranchToMergeWith(@NotNull PlanKey featureBranch) {
        return this.strategy == BranchIntegrationStrategy.BRANCH_UPDATER ? this.getIntegrationPoint().getIntegrationPlanBranchKey() : featureBranch;
    }

    @NotNull
    public String findBranchToMergeWith(@NotNull PlanKey featureBranch) {
        if (this.strategy == BranchIntegrationStrategy.BRANCH_UPDATER) {
            if (this.getIntegrationPoint().getIntegrationPlanBranchKey() != null) {
                return this.getIntegrationPoint().getIntegrationPlanBranchKey().getKey();
            }
            if (this.getIntegrationPoint().getIntegrationVcsReference() != null) {
                return this.getIntegrationPoint().getIntegrationVcsReference();
            }
            throw new IllegalStateException("Either configuredPlanBranch nor vcsReference are set when try to get branch merge to for " + featureBranch);
        }
        return featureBranch.getKey();
    }

    @NotNull
    public BranchIntegrationPoint getIntegrationPoint() {
        return this.branchIntegrationPoint;
    }

    public void setBranchIntegrationPoint(@NotNull BranchIntegrationPoint branchIntegrationPoint) {
        this.branchIntegrationPoint = branchIntegrationPoint;
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        String cfgStrategy;
        this.isValid = config.containsKey(this.getPrefixedPropertyName(INTEGRATION_ENABLED));
        this.enabled = config.getBoolean(this.getPrefixedPropertyName(INTEGRATION_ENABLED), false);
        if (this.enabled && (cfgStrategy = config.getString(this.getPrefixedPropertyName(INTEGRATION_STRATEGY))) != null) {
            try {
                this.strategy = BranchIntegrationStrategy.valueOf((String)cfgStrategy);
                String planBranchKey = config.getString(this.getBranchPropertyNameForStrategy(this.strategy), null);
                PlanKey configuredPlanBranch = null;
                if (planBranchKey != null) {
                    try {
                        configuredPlanBranch = PlanKeys.getPlanKey((String)planBranchKey);
                    }
                    catch (IllegalArgumentException e) {
                        configuredPlanBranch = null;
                    }
                }
                String vcsReference = config.getString(this.getPrefixedPropertyName(INTEGRATION_BRANCH_UPDATER_MERGE_FROM_VCS_BRANCH), null);
                this.branchIntegrationPoint = new BranchIntegrationPointImpl(configuredPlanBranch, vcsReference);
                this.pushEnabled = config.getBoolean(this.getPrefixedPropertyName(INTEGRATION_PUSH_ENABLED[this.strategy.ordinal()]));
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)"Problem while populating BranchIntegrationConfiguration object", (Throwable)e);
            }
        }
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        XMLConfiguration config = ConfigUtils.newConfiguration();
        config.setProperty(this.getPrefixedPropertyName(INTEGRATION_ENABLED), (Object)this.enabled);
        if (this.enabled) {
            config.setProperty(this.getPrefixedPropertyName(INTEGRATION_STRATEGY), (Object)this.strategy.name());
            if (this.getIntegrationPoint().getIntegrationPlanBranchKey() != null) {
                config.setProperty(this.getBranchPropertyNameForStrategy(this.strategy), (Object)this.getIntegrationPoint().getIntegrationPlanBranchKey().toString());
            }
            config.setProperty(this.getPrefixedPropertyName(INTEGRATION_BRANCH_UPDATER_MERGE_FROM_VCS_BRANCH), (Object)this.getIntegrationPoint().getIntegrationVcsReference());
            config.setProperty(this.getPrefixedPropertyName(INTEGRATION_PUSH_ENABLED[this.strategy.ordinal()]), (Object)this.pushEnabled);
        }
        return config;
    }

    public void toConfiguration(HierarchicalConfiguration dstConfiguration) {
        dstConfiguration.clearTree(this.getConfigKeyPrefix());
        ConfigUtils.copyNodes((HierarchicalConfiguration)this.toConfiguration(), (HierarchicalConfiguration)dstConfiguration);
    }

    public boolean isValid() {
        return this.isValid;
    }

    private String getBranchPropertyNameForStrategy(BranchIntegrationStrategy strategy) {
        switch (strategy) {
            case BRANCH_UPDATER: {
                return this.getPrefixedPropertyName(INTEGRATION_BRANCH_UPDATER_MERGE_FROM_BRANCH);
            }
            case GATE_KEEPER: {
                return this.getPrefixedPropertyName(INTEGRATION_GATE_KEEPER_CHECKOUT_BRANCH);
            }
        }
        throw new IllegalArgumentException("Unknown integration strategy: " + strategy);
    }

    private String getPrefixedPropertyName(String bareKey) {
        return this.getConfigKeyPrefix() + "." + bareKey;
    }

    private String getConfigKeyPrefix() {
        return this.isDefaultConfiguration ? DEFAULT_CONFIGURATION_PREFIX : BRANCH_INTEGRATION_PREFIX;
    }
}

