/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationHelper;
import com.atlassian.bamboo.plan.branch.MergeResult;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchIntegrationHelper;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.BranchMergingAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.repository.RepositoryV2;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.MergingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchIntegrationHelperImpl
implements BranchIntegrationHelper,
VcsBranchIntegrationHelper {
    private static final Logger log = Logger.getLogger(BranchIntegrationHelperImpl.class);
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public BranchIntegrationHelperImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @NotNull
    public String getAuthorName(@Nullable Repository repository) {
        return this.getRepositorySettings().getAuthorName();
    }

    @NotNull
    public String getCommitterName(@Nullable Repository repository) {
        return this.getAuthorName(repository);
    }

    @NotNull
    public String getAuthorEmail(@Nullable Repository repository) {
        return this.getRepositorySettings().getAuthorEmail();
    }

    @NotNull
    public String getCommitterEmail(@Nullable Repository repository) {
        return this.getAuthorEmail(repository);
    }

    public String getIntegrationCommitMessage(@Nullable Repository repository) {
        return this.getRepositorySettings().getIntegrationCommitMessage();
    }

    @Override
    public String getCommitterName() {
        return this.getRepositorySettings().getAuthorName();
    }

    @Override
    public String getCommitterEmail() {
        return this.getRepositorySettings().getAuthorEmail();
    }

    @NotNull
    public MergeResult merge(@NotNull BuildContext buildContext, @NotNull File mergeDirectory, @Nullable BuildLogger logger) throws RepositoryException {
        VcsBranch mergeRepositoryBranch;
        BranchMergingAwareRepository checkoutRepository;
        String mergeRevision;
        String checkoutRevision;
        BranchIntegrationConfiguration integrationConfiguration = buildContext.getBuildDefinition().getBranchIntegrationConfiguration();
        RepositoryDefinition defaultRepositoryDefinition = (RepositoryDefinition)Preconditions.checkNotNull((Object)BuildContextHelper.getDefaultRepositoryDefinition(buildContext), (Object)"no default repository defined");
        String branchTargetRevision = (String)Preconditions.checkNotNull((Object)buildContext.getBuildChanges().getVcsRevisionKey(defaultRepositoryDefinition.getId()), (Object)"unable to determine branch revision id");
        String integrationTargetRevision = (String)Preconditions.checkNotNull((Object)buildContext.getBuildChanges().getIntegrationBranchVcsRevision(), (Object)"unable to determine integration branch revision id");
        PlanKey vcsBranch = buildContext.getPlanResultKey().getPlanKey();
        PlanKey mergeDestinationBranch = integrationConfiguration.getMergeResultDestinationBranch(vcsBranch);
        String mergeWithBranch = integrationConfiguration.findBranchToMergeWith(vcsBranch);
        if (mergeDestinationBranch.equals((Object)vcsBranch)) {
            checkoutRevision = branchTargetRevision;
            mergeRevision = integrationTargetRevision;
            checkoutRepository = this.getNewMergingAwareFrom(this.getDefaultRepositoryDefinition(buildContext));
            mergeRepositoryBranch = this.getIntegrationRepository(buildContext).getVcsBranch();
        } else {
            checkoutRevision = integrationTargetRevision;
            mergeRevision = branchTargetRevision;
            checkoutRepository = this.getNewMergingAwareFrom(this.getIntegrationRepositoryDefinition(buildContext));
            mergeRepositoryBranch = this.getDefaultRepository(buildContext).getVcsBranch();
        }
        log.info((Object)this.toBuildLogger(logger, "Checking out code from " + mergeDestinationBranch + ", revision " + checkoutRevision));
        String branchRevision = checkoutRepository.retrieveSourceCode(buildContext, checkoutRevision, mergeDirectory, -1);
        log.info((Object)this.toBuildLogger(logger, "Merging code from " + mergeWithBranch + ", revision " + mergeRevision));
        checkoutRepository.setVcsBranch(mergeRepositoryBranch);
        boolean hasChanges = checkoutRepository.mergeWorkspaceWith(buildContext, mergeDirectory, mergeRevision);
        if (hasChanges) {
            log.info((Object)this.toBuildLogger(logger, "Merged new changesets from " + mergeWithBranch));
        } else {
            log.debug((Object)this.toBuildLogger(logger, "No new changes on " + mergeWithBranch + " found to merge."));
        }
        return new MergeResult(!hasChanges, branchRevision, mergeRevision);
    }

    @NotNull
    public BranchMergingAwareRepository getIntegrationRepository(@NotNull BuildContext buildContext) {
        RepositoryDefinition repositoryDefinition = this.getIntegrationRepositoryDefinition(buildContext);
        return (BranchMergingAwareRepository)Preconditions.checkNotNull((Object)AbstractRepository.toMergeCapableRepository((RepositoryV2)repositoryDefinition.getRepository()), (Object)"repository is not merge capable");
    }

    private RepositoryDefinition getIntegrationRepositoryDefinition(@NotNull BuildContext buildContext) {
        long integrationRepositoryId = buildContext.getBuildChanges().getIntegrationRepositoryId();
        RepositoryDefinition repositoryDefinition = (RepositoryDefinition)buildContext.getRepositoryDefinitionMap().get(integrationRepositoryId);
        Preconditions.checkNotNull((Object)repositoryDefinition, (Object)("Integration repository " + integrationRepositoryId + " not found in plan repositories: " + buildContext.getRepositoryDefinitionMap()));
        return repositoryDefinition;
    }

    private RepositoryDefinition getDefaultRepositoryDefinition(@NotNull BuildContext buildContext) {
        return (RepositoryDefinition)Preconditions.checkNotNull((Object)BuildContextHelper.getDefaultRepositoryDefinition(buildContext), (Object)"no default repository defined");
    }

    protected BranchMergingAwareRepository getDefaultRepository(@NotNull BuildContext buildContext) {
        RepositoryDefinition defaultRepositoryDefinition = this.getDefaultRepositoryDefinition(buildContext);
        return (BranchMergingAwareRepository)Preconditions.checkNotNull((Object)AbstractRepository.toMergeCapableRepository((RepositoryV2)defaultRepositoryDefinition.getRepository()), (Object)"repository is not merge capable");
    }

    private BranchMergingAwareRepository getNewMergingAwareFrom(@NotNull RepositoryDefinition repositoryDefinition) {
        return (BranchMergingAwareRepository)Preconditions.checkNotNull((Object)AbstractRepository.toMergeCapableRepository((RepositoryV2)repositoryDefinition.getNewRepositoryInstance()), (Object)"repository is not merge capable");
    }

    @NotNull
    protected String toBuildLogger(@Nullable BuildLogger logger, @NotNull String msg) {
        return logger != null ? logger.addBuildLogEntry(msg) : msg;
    }

    private RepositorySettings getRepositorySettings() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        return administrationConfiguration.getRepositorySettings();
    }

    @Override
    @Nullable
    public PlanRepositoryDefinition getIntegrationVcsRepository(@NotNull BuildContext buildContext) {
        long integrationRepositoryId = buildContext.getBuildChanges().getIntegrationRepositoryId();
        PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)buildContext.getVcsRepositoryMap().get(integrationRepositoryId);
        Preconditions.checkNotNull((Object)repositoryDefinition, (Object)("Integration repository " + integrationRepositoryId + " not found in plan repositories: " + buildContext.getVcsRepositoryMap()));
        return repositoryDefinition;
    }

    @Override
    @Nullable
    public VcsBranch getIntegrationVcsBranch(@NotNull BuildContext buildContext) {
        PlanRepositoryDefinition integrationVcsRepository = this.getIntegrationVcsRepository(buildContext);
        if (integrationVcsRepository != null && integrationVcsRepository.getBranch() != null) {
            return integrationVcsRepository.getBranch().getVcsBranch();
        }
        return null;
    }

    @Override
    @NotNull
    public MergeResult merge(@NotNull BuildContext buildContext, @NotNull VcsRepositoryData defaultRepositoryDefinition, @NotNull VcsRepositoryModuleDescriptor moduleDescriptor, @NotNull VcsBranch integrationBranch, @NotNull File mergeDir, @Nullable BuildLogger logger) throws RepositoryException {
        boolean hasChanges;
        VcsBranch mergeBranch;
        VcsBranch checkoutBranch;
        PlanVcsRevisionData mergeRevision;
        PlanVcsRevisionData checkoutRevision;
        BranchIntegrationConfiguration integrationConfiguration = buildContext.getBuildDefinition().getBranchIntegrationConfiguration();
        PlanVcsRevisionData branchTargetRevision = (PlanVcsRevisionData)Preconditions.checkNotNull((Object)buildContext.getBuildChanges().getVcsRevisionData(defaultRepositoryDefinition.getId()), (Object)"unable to determine branch revision id");
        PlanVcsRevisionData integrationTargetRevision = new PlanVcsRevisionData((String)Preconditions.checkNotNull((Object)buildContext.getBuildChanges().getIntegrationBranchVcsRevision(), (Object)"unable to determine integration branch revision id"), null);
        PlanKey vcsBranch = buildContext.getPlanResultKey().getPlanKey();
        PlanKey mergeDestinationBranch = integrationConfiguration.getMergeResultDestinationBranch(vcsBranch);
        String mergeWithBranch = integrationConfiguration.findBranchToMergeWith(vcsBranch);
        MergingVcsWorkingCopyManager merger = (MergingVcsWorkingCopyManager)Narrow.downTo((Object)moduleDescriptor.getWorkingCopyManager(), MergingVcsWorkingCopyManager.class);
        Preconditions.checkNotNull((Object)merger, (Object)"repository is not merge capable");
        if (mergeDestinationBranch.equals((Object)vcsBranch)) {
            checkoutRevision = branchTargetRevision;
            mergeRevision = integrationTargetRevision;
            checkoutBranch = defaultRepositoryDefinition.getBranch().getVcsBranch();
            mergeBranch = integrationBranch;
        } else {
            checkoutRevision = integrationTargetRevision;
            mergeRevision = branchTargetRevision;
            checkoutBranch = integrationBranch;
            mergeBranch = defaultRepositoryDefinition.getBranch().getVcsBranch();
        }
        log.info((Object)this.toBuildLogger(logger, "Checking out code from " + mergeDestinationBranch + ", revision " + checkoutRevision.getVcsRevisionKey()));
        log.info((Object)this.toBuildLogger(logger, "and merging code from " + mergeWithBranch + ", revision " + mergeRevision.getVcsRevisionKey()));
        VcsWorkingCopy wc = merger.checkoutAndMerge((CommonContext)buildContext, defaultRepositoryDefinition, checkoutBranch, checkoutRevision, mergeBranch, mergeRevision, mergeDir);
        boolean bl = hasChanges = wc.hasNotCommittedChanges() || !wc.getCurrentRevisionKey().equals(checkoutRevision.getVcsRevisionKey());
        if (hasChanges) {
            log.info((Object)this.toBuildLogger(logger, "Merged new changesets from " + mergeWithBranch));
        } else {
            log.debug((Object)this.toBuildLogger(logger, "No new changes on " + mergeWithBranch + " found to merge."));
        }
        return new MergeResult(!hasChanges, checkoutRevision.getVcsRevisionKey(), mergeRevision.getVcsRevisionKey(), wc);
    }
}

