/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.util.Narrow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchIntegrationPointImpl
implements BranchIntegrationPoint {
    private PlanKey planKey;
    private String vcsReference;

    BranchIntegrationPointImpl(@Nullable PlanKey planKey, @Nullable String vcsReference) {
        this.planKey = planKey;
        this.vcsReference = vcsReference;
    }

    BranchIntegrationPointImpl(BranchIntegrationPoint integrationPoint) {
        this(integrationPoint.getIntegrationPlanBranchKey(), integrationPoint.getIntegrationVcsReference());
    }

    @NotNull
    public static BranchIntegrationPointImpl forPlanBranch(@NotNull PlanKey branchKey) {
        return new BranchIntegrationPointImpl(branchKey, null);
    }

    @NotNull
    public static BranchIntegrationPointImpl forVcsReference(@NotNull String vcsReference) {
        return new BranchIntegrationPointImpl(null, vcsReference);
    }

    @Nullable
    public PlanKey getIntegrationPlanBranchKey() {
        return this.planKey;
    }

    @Nullable
    public String getIntegrationVcsReference() {
        return this.vcsReference;
    }

    @Nullable
    public static BranchIntegrationPoint changeDetectionIntegrationPointForChain(@NotNull ImmutableChain chain) {
        ImmutableChainBranch immutableChainBranch = (ImmutableChainBranch)Narrow.downTo((Object)chain, ImmutableChainBranch.class);
        if (immutableChainBranch == null) {
            return null;
        }
        if (immutableChainBranch.getBuildDefinition().getBranchIntegrationConfiguration().isEnabled()) {
            return immutableChainBranch.getBuildDefinition().getBranchIntegrationConfiguration().getIntegrationPoint();
        }
        return BranchIntegrationPointImpl.forPlanBranch(immutableChainBranch.getMaster().getPlanKey());
    }
}

