/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPoint;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.util.BambooMaps;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class BranchIntegrationServiceImpl
implements BranchIntegrationService {
    private final CachedPlanManager cachedPlanManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;

    @Inject
    public BranchIntegrationServiceImpl(CachedPlanManager cachedPlanManager, RepositoryDefinitionManager repositoryDefinitionManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    @Deprecated
    @NotNull
    public ImmutableChain getIntegrationPlan(@NotNull BranchIntegrationConfiguration integrationConfiguration) {
        PlanKey integrationPlanBranchKey = integrationConfiguration.getIntegrationPlanBranchKey();
        Preconditions.checkNotNull((Object)integrationPlanBranchKey);
        return (ImmutableChain)Preconditions.checkNotNull((Object)this.cachedPlanManager.getPlanByKey(integrationPlanBranchKey, ImmutableChain.class), (Object)("integration plan " + integrationPlanBranchKey + " not found"));
    }

    @NotNull
    public PlanRepositoryDefinition getIntegrationRepository(@NotNull ImmutablePlan plan) {
        ImmutableChain chain = plan.getPlanType() == PlanType.JOB ? ((ImmutableJob)Preconditions.checkNotNull((Object)Narrow.downTo((Object)plan, ImmutableJob.class), (Object)"Can't cast to job")).getParent() : (ImmutableChain)Preconditions.checkNotNull((Object)Narrow.downTo((Object)plan, ImmutableChain.class), (Object)"can't cast to Chain");
        BranchIntegrationConfiguration integrationConfiguration = chain.getBuildDefinition().getBranchIntegrationConfiguration();
        PlanRepositoryDefinition defaultRepository = (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain), (Object)"default plan repository is null");
        if (!integrationConfiguration.isEnabled()) {
            return defaultRepository;
        }
        PlanBranchWorkflow planBranchWorkflow = chain.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow();
        PlanKey integrationPlanBranchKey = integrationConfiguration.getIntegrationPoint().getIntegrationPlanBranchKey();
        if (integrationPlanBranchKey == null) {
            Preconditions.checkState((planBranchWorkflow == PlanBranchWorkflow.PULL_REQUEST_WORKFLOW ? 1 : 0) != 0, (Object)"integration plan branch key is null but shouldn't. Check your integration strategy configuration");
            String branchName = integrationConfiguration.getIntegrationPoint().getIntegrationVcsReference();
            Preconditions.checkState((branchName != null ? 1 : 0) != 0, (Object)"Integration branch is null");
            PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder();
            VcsBranchImpl vcsBranch = new VcsBranchImpl(branchName);
            PartialVcsRepositoryData repositoryData = builder.pluginKey(defaultRepository.getPluginKey()).inheritedData((VcsRepositoryData)defaultRepository).name(branchName).vcsBranch(vcsBranch).branchConfiguration(Collections.emptyMap()).build();
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)chain, defaultRepository.getId());
            return new PlanRepositoryDefinitionImpl(planRepositoryLink, repositoryData);
        }
        ImmutableChain integrationPlan = (ImmutableChain)Preconditions.checkNotNull((Object)this.cachedPlanManager.getPlanByKey(integrationPlanBranchKey, ImmutableChain.class), (Object)("integration plan " + integrationPlanBranchKey + " not found"));
        return (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)integrationPlan));
    }

    @NotNull
    public PlanRepositoryDefinition getIntegrationRepository(@NotNull ImmutablePlan plan, @NotNull BranchIntegrationPoint branchIntegrationPoint) {
        ImmutableChain chain = plan.getPlanType() == PlanType.JOB ? ((ImmutableJob)Preconditions.checkNotNull((Object)Narrow.downTo((Object)plan, ImmutableJob.class), (Object)"Can't cast to job")).getParent() : (ImmutableChain)Preconditions.checkNotNull((Object)Narrow.downTo((Object)plan, ImmutableChain.class), (Object)"can't cast to Chain");
        PlanRepositoryDefinition defaultRepository = (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain), (Object)"default plan repository is null");
        PlanKey integrationPlanBranchKey = branchIntegrationPoint.getIntegrationPlanBranchKey();
        if (integrationPlanBranchKey == null) {
            String branchName = branchIntegrationPoint.getIntegrationVcsReference();
            Preconditions.checkState((branchName != null ? 1 : 0) != 0, (Object)"Integration branch is null");
            PartialVcsRepositoryDataBuilder builder = PartialVcsRepositoryDataBuilder.newBuilder();
            VcsBranchImpl vcsBranch = new VcsBranchImpl(branchName);
            PartialVcsRepositoryData repositoryData = builder.pluginKey(defaultRepository.getPluginKey()).inheritedData((VcsRepositoryData)defaultRepository).name(branchName).vcsBranch(vcsBranch).branchConfiguration(Collections.emptyMap()).build();
            PlanRepositoryLink planRepositoryLink = this.repositoryDefinitionManager.getPlanRepositoryLink((ImmutablePlan)chain, defaultRepository.getId());
            return new PlanRepositoryDefinitionImpl(planRepositoryLink, repositoryData);
        }
        ImmutableChain integrationPlan = (ImmutableChain)Preconditions.checkNotNull((Object)this.cachedPlanManager.getPlanByKey(integrationPlanBranchKey, ImmutableChain.class), (Object)("integration plan " + integrationPlanBranchKey + " not found"));
        return (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)integrationPlan));
    }

    @NotNull
    public Map<Long, PlanRepositoryDefinition> getPlanRepositoryDefinitionMap(@NotNull ImmutablePlan plan) {
        LinkedHashMap<Long, PlanRepositoryDefinition> repositoryDefinitionMap = PlanHelper.getPlanRepositoryDefinitionMap(plan);
        BranchIntegrationConfiguration integrationConfiguration = plan.getBuildDefinition().getBranchIntegrationConfiguration();
        PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition(plan);
        if (integrationConfiguration.isEnabled()) {
            if (repositoryDefinition == null) {
                throw new IllegalStateException("Integration is enabled, but no default repository has been found");
            }
            PlanRepositoryDefinition integrationRepositoryDefinition = (PlanRepositoryDefinition)Preconditions.checkNotNull((Object)this.getIntegrationRepository(plan), (Object)"no default repository defined");
            BambooMaps.populateMap(repositoryDefinitionMap, integrationRepositoryDefinition, BambooIdProvider::getId);
        }
        return repositoryDefinitionMap;
    }
}

