/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.branches.BranchNotificationStrategy;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchMonitoringConfiguration;
import com.atlassian.bamboo.plan.branch.BranchTriggeringOption;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.trigger.TriggerConfigurationUtils;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerDefinitionImpl;
import com.atlassian.bamboo.utils.BambooInterners;
import com.atlassian.bamboo.utils.ConfigUtils;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchMonitoringConfigurationImpl
implements BranchMonitoringConfiguration {
    private PlanBranchWorkflow planBranchWorkflow = PlanBranchWorkflow.defaultValue();
    private static String DEFAULT_TRIGGER_CONFIG_KEY = "branches.default.trigger";
    private static String TRIGGER_PREFIX = DEFAULT_TRIGGER_CONFIG_KEY + ".";
    private boolean isBranchCreationEnabled;
    private boolean isRemovedBranchCleanUpEnabled;
    private boolean isInactiveBranchCleanUpEnabled;
    private String planBranchCreationPattern = ".*";
    private int cleanUpPeriodInDays = 7;
    private int inactivityCleanUpPeriodInDays = 30;
    private boolean isValid;
    private boolean remoteJiraBranchLinkingEnabled = true;
    private BranchNotificationStrategy defaultBranchNotificationStrategy = BranchNotificationStrategy.NOTIFY_COMMITTERS;
    private HierarchicalConfiguration customConfiguration;
    private BranchIntegrationConfiguration defaultBranchIntegrationConfiguration = new BranchIntegrationConfigurationImpl(true);
    private BranchTriggeringOption branchTriggeringOption = BranchTriggeringOption.INHERITED;
    @Nullable
    private TriggerDefinition defaultTrigger;

    @NotNull
    public PlanBranchWorkflow getPlanBranchWorkflow() {
        return this.planBranchWorkflow;
    }

    public void setPlanBranchWorkflow(@NotNull PlanBranchWorkflow planBranchWorkflow) {
        this.planBranchWorkflow = planBranchWorkflow;
    }

    public boolean isPlanBranchCreationEnabled() {
        return this.isBranchCreationEnabled;
    }

    public boolean isRemovedBranchCleanUpEnabled() {
        return this.isRemovedBranchCleanUpEnabled;
    }

    public void setPlanBranchCreationEnabled(boolean isBranchCreationEnabled) {
        this.isBranchCreationEnabled = isBranchCreationEnabled;
    }

    public void setRemovedBranchCleanUpEnabled(boolean isAutomaticPlanBranchCleanUpEnabled) {
        this.isRemovedBranchCleanUpEnabled = isAutomaticPlanBranchCleanUpEnabled;
    }

    public boolean isInactiveBranchCleanUpEnabled() {
        return this.isInactiveBranchCleanUpEnabled;
    }

    public void setInactiveBranchCleanUpEnabled(boolean enabled) {
        this.isInactiveBranchCleanUpEnabled = enabled;
    }

    public String getMatchingPattern() {
        return this.planBranchCreationPattern;
    }

    public void setMatchingPattern(@NotNull String regularExpression) {
        this.planBranchCreationPattern = BambooInterners.intern((String)regularExpression);
    }

    public int getInactiveBranchCleanUpPeriodInDays() {
        return this.inactivityCleanUpPeriodInDays;
    }

    public void setInactiveBranchCleanUpPeriodInDays(int inactiveBranchCleanUpPeriodInDays) {
        this.inactivityCleanUpPeriodInDays = inactiveBranchCleanUpPeriodInDays;
    }

    public int getRemovedBranchCleanUpPeriodInDays() {
        return this.cleanUpPeriodInDays;
    }

    public void setRemovedBranchCleanUpPeriodInDays(int cleanUpPeriodInDays) {
        this.cleanUpPeriodInDays = cleanUpPeriodInDays;
    }

    @NotNull
    public HierarchicalConfiguration getCustomConfiguration() {
        if (this.customConfiguration == null) {
            this.customConfiguration = ConfigUtils.newConfiguration();
        }
        return this.customConfiguration;
    }

    public void setCustomConfiguration(HierarchicalConfiguration customConfiguration) {
        this.customConfiguration = customConfiguration;
    }

    public BranchNotificationStrategy getDefaultBranchNotificationStrategy() {
        return this.defaultBranchNotificationStrategy;
    }

    public void setDefaultBranchNotificationStrategy(BranchNotificationStrategy defaultBranchNotificationStrategy) {
        this.defaultBranchNotificationStrategy = defaultBranchNotificationStrategy;
    }

    public BranchIntegrationConfiguration getDefaultBranchIntegrationConfiguration() {
        return this.defaultBranchIntegrationConfiguration;
    }

    public void setDefaultBranchIntegrationConfiguration(BranchIntegrationConfiguration defaultBranchIntegrationConfiguration) {
        this.defaultBranchIntegrationConfiguration = defaultBranchIntegrationConfiguration;
    }

    public boolean isRemoteJiraBranchLinkingEnabled() {
        return this.remoteJiraBranchLinkingEnabled;
    }

    public void setRemoteJiraBranchLinkingEnabled(boolean jiraBranchLinkingEnabled) {
        this.remoteJiraBranchLinkingEnabled = jiraBranchLinkingEnabled;
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey("branches.branchRemovalCleanUpEnabled") && config.containsKey("branches.inactiveBranchCleanupEnabled");
        this.setPlanBranchWorkflow(PlanBranchWorkflow.fromKey((String)config.getString("branches.workflow", PlanBranchWorkflow.defaultValue().getKey())));
        this.setRemovedBranchCleanUpEnabled(config.getBoolean("branches.branchRemovalCleanUpEnabled", false));
        this.setInactiveBranchCleanUpEnabled(config.getBoolean("branches.inactiveBranchCleanupEnabled", false));
        this.setMatchingPattern(config.getString("branches.matchingPattern", ""));
        this.setRemovedBranchCleanUpPeriodInDays(config.getInt("branches.removalCleanupPeriodInDays", 7));
        this.setInactiveBranchCleanUpPeriodInDays(config.getInt("branches.inactivityInDays", 30));
        this.setDefaultBranchNotificationStrategy(BranchNotificationStrategy.fromKey((String)config.getString("branches.defaultNotificationStrategy", BranchNotificationStrategy.NOTIFY_COMMITTERS.getKey())));
        this.setCustomConfiguration((HierarchicalConfiguration)config.subset("branches.custom"));
        this.setRemoteJiraBranchLinkingEnabled(config.getBoolean("branches.issueLinking", true));
        this.setBranchTriggeringOption(BranchTriggeringOption.fromKey((String)config.getString("branches.branchTriggering", BranchTriggeringOption.INHERITED.getKey())));
        this.setDefaultTriggerFromConfiguration(config);
        this.defaultBranchIntegrationConfiguration.populateFromConfig(config);
    }

    private void setDefaultTriggerFromConfiguration(@NotNull HierarchicalConfiguration config) {
        if (!config.configurationsAt(DEFAULT_TRIGGER_CONFIG_KEY).isEmpty()) {
            SubnodeConfiguration trigger = config.configurationAt(DEFAULT_TRIGGER_CONFIG_KEY);
            String pluginKey = trigger.getString("pluginKey");
            Map taskConfigMap = ConfigUtils.getMapFromConfiguration((String)"config", (String)"item", (HierarchicalConfiguration)trigger);
            Set<Long> triggeringRepositories = null;
            if (trigger.containsKey("triggeringRepositories")) {
                triggeringRepositories = TriggerConfigurationUtils.extractTriggeringRepositoriesFromCfgString(trigger.getString("triggeringRepositories"));
            }
            Map triggerConditionsConfigMap = ConfigUtils.getMapFromConfiguration((String)"conditions", (String)"item", (HierarchicalConfiguration)trigger);
            this.setDefaultTrigger(new TriggerDefinitionImpl.Builder().id(1L).name("Branch trigger").pluginKey(pluginKey).triggeringRepositories(triggeringRepositories).configuration(BambooInterners.intern((Map)taskConfigMap)).triggerConditionsConfiguration(BambooInterners.intern((Map)triggerConditionsConfigMap)).enabled(true).build());
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        XMLConfiguration config = ConfigUtils.newConfiguration();
        config.setProperty("branches.workflow", (Object)this.planBranchWorkflow.getKey());
        config.setProperty("branches.branchRemovalCleanUpEnabled", (Object)this.isRemovedBranchCleanUpEnabled);
        config.setProperty("branches.inactiveBranchCleanupEnabled", (Object)this.isInactiveBranchCleanUpEnabled);
        config.setProperty("branches.matchingPattern", (Object)this.getMatchingPattern());
        config.setProperty("branches.removalCleanupPeriodInDays", (Object)this.getRemovedBranchCleanUpPeriodInDays());
        config.setProperty("branches.inactivityInDays", (Object)this.getInactiveBranchCleanUpPeriodInDays());
        config.setProperty("branches.defaultNotificationStrategy", (Object)this.getDefaultBranchNotificationStrategy().getKey());
        config.setProperty("branches.issueLinking", (Object)this.isRemoteJiraBranchLinkingEnabled());
        config.setProperty("branches.branchTriggering", (Object)this.branchTriggeringOption.getKey());
        if (this.customConfiguration != null) {
            ConfigUtils.copyNodes((HierarchicalConfiguration)this.customConfiguration, (HierarchicalConfiguration)config, (String)"branches.custom");
        }
        ConfigUtils.copyNodes((HierarchicalConfiguration)this.defaultBranchIntegrationConfiguration.toConfiguration(), (HierarchicalConfiguration)config);
        TriggerDefinition triggerDefinition = this.getDefaultTrigger();
        if (triggerDefinition != null) {
            config.addProperty(TRIGGER_PREFIX + "pluginKey", (Object)triggerDefinition.getPluginKey());
            if (triggerDefinition.getTriggeringRepositories() != null) {
                config.addProperty(TRIGGER_PREFIX + "triggeringRepositories", (Object)TriggerConfigurationUtils.triggeringRepositoriesToString(triggerDefinition.getTriggeringRepositories()));
            }
            ConfigUtils.addMapToConfiguration((String)(TRIGGER_PREFIX + "config"), (String)"item", (Map)triggerDefinition.getConfiguration(), (HierarchicalConfiguration)config);
            ConfigUtils.addMapToConfiguration((String)(TRIGGER_PREFIX + "conditions"), (String)"item", (Map)triggerDefinition.getTriggerConditionsConfiguration(), (HierarchicalConfiguration)config);
        }
        return config;
    }

    @NotNull
    public BranchTriggeringOption getBranchTriggeringOption() {
        return this.branchTriggeringOption;
    }

    public void setBranchTriggeringOption(@NotNull BranchTriggeringOption branchTriggeringOption) {
        this.branchTriggeringOption = branchTriggeringOption;
    }

    @Nullable
    public TriggerDefinition getDefaultTrigger() {
        return this.defaultTrigger;
    }

    public void setDefaultTrigger(@Nullable TriggerDefinition defaultTrigger) {
        this.defaultTrigger = defaultTrigger;
    }
}

