/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="BUILD")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class ChainBranchImpl
extends AbstractChain
implements ChainBranch {
    private static final Logger log = Logger.getLogger(ChainBranchImpl.class);
    private BranchCommitInformation commitInformation;
    private String linkedJiraIssue;
    private boolean remoteJiraLinkRequired;

    @Override
    @NotNull
    public Chain getMaster() {
        return super.getMaster();
    }

    @NotNull
    public PlanType getPlanType() {
        return PlanType.CHAIN_BRANCH;
    }

    public void setCommitInformation(@Nullable BranchCommitInformation commitInformation) {
        this.commitInformation = commitInformation;
    }

    public BranchCommitInformation getCommitInformation() {
        return this.commitInformation;
    }

    public String getLinkedJiraIssue() {
        return this.linkedJiraIssue;
    }

    public void setLinkedJiraIssue(String linkedJiraIssue) {
        this.linkedJiraIssue = linkedJiraIssue;
    }

    public boolean isRemoteJiraLinkRequired() {
        return this.remoteJiraLinkRequired;
    }

    public void setRemoteJiraLinkRequired(boolean remoteJiraIssueLinkRequired) {
        this.remoteJiraLinkRequired = remoteJiraIssueLinkRequired;
    }

    @Override
    @NotNull
    public List<RepositoryDefinition> getEffectiveRepositoryDefinitions() {
        return this.getPlanRepositoryDefinitions().stream().map(RepositoryDefinitionImpl::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoryDefinitions() {
        List<PlanRepositoryDefinition> branchRepositories = super.getPlanRepositoryDefinitions();
        List masterRepositories = this.getMaster().getPlanRepositoryDefinitions();
        return ChainBranchImpl.createEffectivePlanRepositoryDefinitions(branchRepositories, masterRepositories);
    }

    public static List<PlanRepositoryDefinition> createEffectivePlanRepositoryDefinitions(List<PlanRepositoryDefinition> branchRepositories, List<PlanRepositoryDefinition> masterRepositories) {
        if (branchRepositories.isEmpty()) {
            return masterRepositories;
        }
        LinkedHashMap<Long, PlanRepositoryDefinition> result = new LinkedHashMap<Long, PlanRepositoryDefinition>();
        masterRepositories.forEach(r -> result.put(r.getId(), (PlanRepositoryDefinition)r));
        for (PlanRepositoryDefinition branchRepository : branchRepositories) {
            PlanRepositoryDefinition parentRepository = (PlanRepositoryDefinition)result.get(branchRepository.getParentId());
            if (parentRepository == null) continue;
            result.put(branchRepository.getParentId(), PlanRepositoryDefinitionImpl.createForPosition((VcsRepositoryData)branchRepository, parentRepository.getPosition()));
        }
        return new ArrayList<PlanRepositoryDefinition>(result.values());
    }

    @Override
    public NotificationSet getNotificationSet() {
        switch (this.getBuildDefinition().getBranchSpecificConfiguration().getNotificationStrategy()) {
            case INHERIT: {
                return this.getMaster().getNotificationSet();
            }
            case NOTIFY_COMMITTERS: {
                return super.getNotificationSet();
            }
        }
        return new NotificationSetImpl();
    }

    public void setMaster(@NotNull Plan master) {
        Preconditions.checkNotNull((Object)master, (Object)("Cannot remove master from branch " + this.getPlanKey()));
        Chain chain = (Chain)Narrow.to((Object)master, Chain.class);
        if (chain == null) {
            throw new IllegalArgumentException("Chain Branch can not have a master of type " + master.getClass());
        }
        this.master = chain;
    }
}

