/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchIdentifier;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ChainBranchManagerImpl
implements ChainBranchManager {
    private static final Logger log = Logger.getLogger(ChainBranchManagerImpl.class);
    private static final String BAMBOO_CHAIN_BRANCH_NEXT_KEY = "bamboo.chain.branch.next.key";
    private final PlanDao planDao;
    private final BandanaManager bandanaManager;
    private final VcsBranchManager vcsBranchManager;
    private final PlanManager planManager;
    private final EventPublisher eventPublisher;
    private final CustomVariableContext customVariableContext;

    public ChainBranchManagerImpl(PlanDao planDao, BandanaManager bandanaManager, VcsBranchManager vcsBranchManager, PlanManager planManager, EventPublisher eventPublisher, CustomVariableContext customVariableContext) {
        this.planDao = planDao;
        this.bandanaManager = bandanaManager;
        this.vcsBranchManager = vcsBranchManager;
        this.planManager = planManager;
        this.eventPublisher = eventPublisher;
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public List<ChainBranch> getBranchesForChain(@NotNull ImmutableChain chain) {
        return this.planDao.getBranchesForChain(chain);
    }

    public Collection<Job> getBranchesForJob(Job job) {
        return this.planDao.getBranchesForJob(job);
    }

    @NotNull
    public List<ChainBranchIdentifier> getBranchIdentifiersForChain(@NotNull PlanIdentifier chain) {
        return this.planDao.getBranchIdentifiersForChain(chain);
    }

    public boolean hasBranches(@NotNull Plan plan) {
        return this.planDao.getBranchCount((ImmutablePlan)plan) > 0;
    }

    public int getBranchCount(@NotNull ImmutablePlan plan) {
        return this.planDao.getBranchCount(plan);
    }

    @NotNull
    public Set<Long> getPlansWithBranches() {
        return this.planDao.getBranchesCount().stream().map(pair -> ((Number)pair.first).longValue()).collect(Collectors.toSet());
    }

    public boolean isPlanBranchNameConflicting(ImmutableChain masterPlan, long planIdToIgnore, String branchName) {
        List<ChainBranchIdentifier> branchIdentifiersForChain = this.getBranchIdentifiersForChain((PlanIdentifier)masterPlan);
        for (ChainBranchIdentifier chainBranchIdentifier : branchIdentifiersForChain) {
            if (!chainBranchIdentifier.getBuildName().equals(branchName) || chainBranchIdentifier.getId() == planIdToIgnore) continue;
            return true;
        }
        return branchName.equals(masterPlan.getBuildName());
    }

    public ChainBranchIdentifier getBranchWithName(ImmutableChain masterPlan, String branchName) {
        List<ChainBranchIdentifier> branchIdentifiersForChain = this.getBranchIdentifiersForChain((PlanIdentifier)masterPlan);
        for (ChainBranchIdentifier chainBranchIdentifier : branchIdentifiersForChain) {
            if (!chainBranchIdentifier.getBuildName().equals(branchName)) continue;
            return chainBranchIdentifier;
        }
        return null;
    }

    public void handleVcsBranchDeletedOfPlanBranch(ImmutableChain chainBranch) {
        if (!chainBranch.hasMaster()) {
            return;
        }
        PlanRepositoryDefinition defaultPlanRepositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chainBranch);
        if (defaultPlanRepositoryDefinition != null) {
            this.handleVcsBranchDeletedOfPlanBranchInternal(chainBranch, defaultPlanRepositoryDefinition);
        } else {
            log.error((Object)("Can't mark VCS branch of chain branch " + chainBranch.getKey() + " for deletion because it doesn't have default repository."));
        }
        this.disableChainBranch(chainBranch);
    }

    public void handleVcsBranchDeletedOfPlanBranch(@NotNull ImmutableChain chainBranch, @NotNull PlanRepositoryDefinition planRepositoryDefinition) {
        if (!chainBranch.hasMaster()) {
            return;
        }
        if (PlanHelper.isDefault(planRepositoryDefinition)) {
            this.handleVcsBranchDeletedOfPlanBranchInternal(chainBranch, planRepositoryDefinition);
        }
        this.disableChainBranch(chainBranch);
    }

    public long getNextBranchKeyNumber(ImmutablePlan chain) {
        PlanAwareBandanaContext bandanaContext = PlanAwareBandanaContext.forPlan(chain);
        Object bandanaNextValue = this.bandanaManager.getValue((BandanaContext)bandanaContext, BAMBOO_CHAIN_BRANCH_NEXT_KEY, false);
        return bandanaNextValue != null ? Long.parseLong(bandanaNextValue.toString()) : 0L;
    }

    public void updateNextBranchKeyNumber(ImmutablePlan chain, long number) {
        PlanAwareBandanaContext bandanaContext = PlanAwareBandanaContext.forPlan(chain);
        this.bandanaManager.setValue((BandanaContext)bandanaContext, BAMBOO_CHAIN_BRANCH_NEXT_KEY, (Object)number);
    }

    private void handleVcsBranchDeletedOfPlanBranchInternal(@NotNull ImmutableChain chainBranch, @NotNull PlanRepositoryDefinition defaultPlanRepositoryDefinition) {
        if (defaultPlanRepositoryDefinition.getBranch() == null) {
            log.warn((Object)("Can't mark VCS branch of chain branch " + chainBranch.getKey() + " for deletion because branch definition is null."));
            return;
        }
        VariableSubstitutor planVariableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)chainBranch);
        String substitutedDefaultBranchName = (String)this.customVariableContext.withVariableSubstitutor(planVariableSubstitutor, () -> {
            VcsBranch repositoryBranch = defaultPlanRepositoryDefinition.getBranch().getVcsBranch();
            return this.customVariableContext.substituteString(repositoryBranch.getName());
        });
        if (substitutedDefaultBranchName == null) {
            log.warn((Object)("Can't mark VCS branch of chain branch " + chainBranch.getKey() + " for deletion because its substituted branch name is null."));
            return;
        }
        log.debug((Object)("Marking VCS branch " + substitutedDefaultBranchName + "as deleted for chain " + chainBranch.getMaster().getKey()));
        List vcsBranchList = this.vcsBranchManager.findNotDeletedByChain(chainBranch.getMaster());
        vcsBranchList.stream().filter(vcsBranch -> vcsBranch.isEqualToBranchWith(substitutedDefaultBranchName) && vcsBranch.getDetectedDeletionDate() == null).forEach(vcsBranch -> this.markBranchDeleted((BambooVcsBranch)vcsBranch, chainBranch, defaultPlanRepositoryDefinition));
    }

    private void disableChainBranch(@NotNull ImmutableChain chainBranch) {
        if (chainBranch.isSuspendedFromBuilding() || chainBranch.isMarkedForDeletion()) {
            log.debug((Object)("Chain branch will not be disabled " + chainBranch.getKey()));
        } else {
            this.planManager.setPlanSuspendedState(chainBranch.getPlanKey(), true);
            this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, chainBranch.getPlanKey()));
            log.info((Object)String.format("Chain branch %s was disabled because its VCS branch was deleted", chainBranch.getKey()));
        }
    }

    private void markBranchDeleted(@NotNull BambooVcsBranch vcsBranch, @NotNull ImmutableChain chainBranch, @NotNull PlanRepositoryDefinition chainBranchRepository) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Marking VCS branch %s of chain branch %s as removed because its name matches %s", vcsBranch.getName(), chainBranch.getPlanKey().getKey(), chainBranchRepository.getBranch().getVcsBranch().getName()));
        }
        vcsBranch.setDetectedDeletionDate(new Date());
        DefaultChain chain = new DefaultChain();
        chain.setId(vcsBranch.getChainId());
        vcsBranch.setChain((Chain)chain);
        this.vcsBranchManager.save(vcsBranch);
    }
}

