/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainBranchUtils {
    private static final Logger log = Logger.getLogger(ChainBranchUtils.class);
    private static final int MAX_NAME_PREFIX_LENGTH = 250;

    private ChainBranchUtils() {
    }

    @Nullable
    public static Job getBranchedJob(@NotNull Job masterJob, @NotNull Chain chain) {
        if (chain.hasMaster()) {
            return chain.getAllJobs().stream().filter(job -> masterJob.equals(job.getMaster())).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    public static ImmutableJob findJobByMasterId(@NotNull ImmutableChain chain, long masterJobId) {
        return chain.getAllJobs().stream().filter(j -> {
            if (j.getDatabaseId().isPresent()) {
                return masterJobId == (Long)j.getDatabaseId().get();
            }
            if (j.getMasterIdIfExists().isPresent()) {
                return masterJobId == (Long)j.getMasterIdIfExists().get();
            }
            return false;
        }).findFirst().orElse(null);
    }

    @Nullable
    public static String getSubstitutedVcsBranchDisplayName(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        return (String)customVariableContext.withVariableSubstitutor(customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(plan), () -> ChainBranchUtils.getSubstitutedVcsBranchDisplayNameWithoutContextChange(customVariableContext, plan));
    }

    public static String getSubstitutedVcsBranchDisplayNameWithoutContextChange(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        return ChainBranchUtils.getANameFromBranch(customVariableContext, plan, VcsBranch::getDisplayName);
    }

    @Nullable
    public static String getSubstitutedVcsBranchName(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        return (String)customVariableContext.withVariableSubstitutor(customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(plan), () -> ChainBranchUtils.getANameFromBranch(customVariableContext, plan, VcsBranch::getName));
    }

    @Nullable
    private static String getANameFromBranch(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan, Function<VcsBranch, String> nameGetter) {
        PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition(plan);
        if (repositoryDefinition != null) {
            try {
                VcsBranchDefinition vcsBranchDefinition = repositoryDefinition.getBranch();
                if (vcsBranchDefinition != null) {
                    VcsBranch repositoryBranch = vcsBranchDefinition.getVcsBranch();
                    return customVariableContext.substituteString(nameGetter.apply(repositoryBranch));
                }
            }
            catch (Exception e) {
                log.error((Object)"error:", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static String getChainBranchName(@NotNull CachedPlanManager cachedPlanManager, @NotNull CustomVariableContext customVariableContext, @NotNull PlanKey planKey) {
        ImmutablePlan plan = cachedPlanManager.getPlanByKey(planKey);
        if (plan != null) {
            return ChainBranchUtils.getChainBranchNameInTemporaryContext(customVariableContext, plan);
        }
        return null;
    }

    @NotNull
    public static String getChainBranchName(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        return ChainBranchUtils.getChainBranchNameInTemporaryContext(customVariableContext, plan);
    }

    private static String getChainBranchNameInTemporaryContext(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        return (String)customVariableContext.withVariableSubstitutor(customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(plan), () -> ChainBranchUtils.getChainBranchNameWithoutContextChange(customVariableContext, plan));
    }

    @NotNull
    public static String getChainBranchNameWithoutContextChange(@NotNull CustomVariableContext customVariableContext, @NotNull ImmutablePlan plan) {
        if (plan.hasMaster()) {
            return plan.getBuildName();
        }
        String vcsMasterBranchName = ChainBranchUtils.getSubstitutedVcsBranchDisplayNameWithoutContextChange(customVariableContext, plan);
        if (vcsMasterBranchName != null) {
            return vcsMasterBranchName;
        }
        return "master";
    }

    @NotNull
    public static String getValidChainBranchName(@NotNull VcsBranch newBranch) {
        return ChainBranchUtils.getValidChainBranchName(newBranch.getDisplayName());
    }

    @NotNull
    public static String getValidChainBranchName(@NotNull String vcsBranchName) {
        String branchNameWithValidChars = StringUtils.replaceChars((String)vcsBranchName.trim(), (String)"[]{}<>:@/&%\\!|#$*;~", (String)StringUtils.repeat((String)"-", (int)"[]{}<>:@/&%\\!|#$*;~".length()));
        return StringUtils.substring((String)branchNameWithValidChars, (int)0, (int)250).trim();
    }
}

