/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainPropagatingFacade {
    private final List<Chain> chainAndBranches;
    private final Chain master;

    public ChainPropagatingFacade(@NotNull ChainBranchManager chainBranchManager, @NotNull Chain masterChain) {
        this.master = masterChain;
        this.chainAndBranches = Lists.newArrayList((Object[])new Chain[]{masterChain});
        List branches = chainBranchManager.getBranchesForChain((ImmutableChain)masterChain);
        this.chainAndBranches.addAll(branches);
    }

    public ChainStage addAndSaveNewStage(@NotNull PlanManager planManager, @NotNull EventPublisher eventPublisher, @NotNull String stageName, @Nullable String stageDescription, boolean stageManual, boolean finalStage) {
        ChainStageImpl chainStage = new ChainStageImpl(this.master, stageName, stageDescription, stageManual, finalStage);
        this.master.addStage((ChainStage)chainStage);
        planManager.savePlan((Plan)this.master);
        for (Chain chainOrBranch : this.chainAndBranches) {
            eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, chainOrBranch.getPlanKey()));
        }
        return chainStage;
    }

    @Deprecated
    @NotNull
    public ChainStage addNewStage(@NotNull String stageName, @Nullable String stageDescription, boolean stageManual, boolean finalStage) {
        ChainStageImpl chainStage = new ChainStageImpl(this.master, stageName, stageDescription, stageManual, finalStage);
        this.master.addStage((ChainStage)chainStage);
        return chainStage;
    }

    @Deprecated
    public void savePlan(@NotNull PlanManager planManager) {
        for (Chain chainOrBranch : this.chainAndBranches) {
            planManager.savePlan((Plan)chainOrBranch);
        }
    }

    public List<PlanKey> createJob(JobCreationService jobCreationService, BuildConfiguration buildConfiguration, Map<String, ?> actionParametersMap, PlanCreationService.EnablePlan isPlanEnabled) throws PlanCreationDeniedException {
        ArrayList<PlanKey> createdJobs = new ArrayList<PlanKey>();
        SimpleActionParametersMap clonedActionParametersMap = new SimpleActionParametersMap(actionParametersMap);
        JobParamMapHelper.setChain(clonedActionParametersMap, this.master);
        String key = jobCreationService.createSingleJob(buildConfiguration, (ActionParametersMap)clonedActionParametersMap, isPlanEnabled);
        PlanKey jobKey = PlanKeys.getPlanKey((String)key);
        for (Chain chainOrBranch : this.chainAndBranches) {
            PlanKey planKey = PlanKeys.getJobKey((PlanKey)chainOrBranch.getPlanKey(), (String)jobKey.getPartialKey());
            createdJobs.add(planKey);
        }
        return createdJobs;
    }
}

