/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.event.api.EventPublisher;
import io.atlassian.util.concurrent.Lazy;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ImmutableChainPropagatingFacade {
    private final CachedPlanManager cachedPlanManager;
    private final ImmutableChain chain;
    private final Supplier<Iterable<ImmutableChain>> chainAndBranches = Lazy.supplier((Supplier)new Supplier<Iterable<ImmutableChain>>(){

        @Override
        public Iterable<ImmutableChain> get() {
            return BambooIterables.concat((Iterable)ImmutableChainPropagatingFacade.this.cachedPlanManager.getBranchesForChain((PlanIdentifier)ImmutableChainPropagatingFacade.this.chain), (Object)ImmutableChainPropagatingFacade.this.chain);
        }
    });

    public ImmutableChainPropagatingFacade(@NotNull CachedPlanManager cachedPlanManager, @NotNull ImmutableChain chain) {
        this.cachedPlanManager = cachedPlanManager;
        this.chain = chain;
    }

    public void createSchedulingJobs(PlanScheduler planScheduler) {
        BambooIterables.stream(this.chainAndBranches.get()).filter(chain -> !chain.isSuspendedFromBuilding()).forEach(arg_0 -> ((PlanScheduler)planScheduler).scheduleTasksForPlan(arg_0));
    }

    public void removeSchedulingJobs(PlanScheduler planScheduler) {
        for (ImmutableChain chainOrBranch : this.chainAndBranches.get()) {
            planScheduler.removeTasksScheduledForPlan((ImmutablePlan)chainOrBranch);
        }
    }

    public void publishBuildConfigurationUpdatedEvent(@NotNull EventPublisher eventPublisher, Object source, boolean cascadeToJobs) {
        for (ImmutableChain chainOrBranch : this.chainAndBranches.get()) {
            eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent(source, chainOrBranch.getPlanKey()));
            if (!cascadeToJobs) continue;
            for (ImmutableJob job : chainOrBranch.getAllJobs()) {
                eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent(source, job.getPlanKey()));
            }
        }
    }
}

