/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobPropagatingFacade {
    private final Buildable masterJob;
    private final Collection<PlanKey> jobAndBranchesKeys;

    public JobPropagatingFacade(@NotNull ChainBranchManager chainBranchManager, @NotNull Job masterJob) {
        this.masterJob = masterJob;
        Chain masterChain = masterJob.getParent();
        List branches = chainBranchManager.getBranchesForChain((ImmutableChain)masterChain);
        this.jobAndBranchesKeys = Lists.newArrayList((Object[])new PlanKey[]{masterJob.getPlanKey()});
        for (ChainBranch branch : branches) {
            this.jobAndBranchesKeys.add(PlanKeys.getJobKey((PlanKey)branch.getPlanKey(), (String)masterJob.getPlanKey().getPartialKey()));
        }
    }

    @NotNull
    public String getName() {
        return this.masterJob.getName();
    }

    @Nullable
    public String getDescription() {
        return this.masterJob.getDescription();
    }

    public void setBuildName(String buildName) {
        this.masterJob.setBuildName(buildName);
    }

    public void setDescription(String buildDescription) {
        this.masterJob.setDescription(buildDescription);
    }

    public void setSuspendedFromBuilding(boolean suspendedFromBuilding) {
        this.masterJob.setSuspendedFromBuilding(suspendedFromBuilding);
    }

    public void setPlanSuspendedState(@NotNull PlanManager planManager, boolean suspendedFromBuilding) {
        this.masterJob.setSuspendedFromBuilding(suspendedFromBuilding);
        planManager.setPlanSuspendedState(this.masterJob.getPlanKey(), suspendedFromBuilding);
    }

    public void savePlan(@NotNull PlanManager planManager) {
        planManager.savePlan((Plan)this.masterJob);
    }

    public void publishBuildConfigurationUpdatedEvent(@NotNull EventPublisher eventPublisher, Object source) {
        for (PlanKey jobKey : this.jobAndBranchesKeys) {
            eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent(source, jobKey));
        }
    }
}

