/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class VcsBranchImpl
implements Serializable,
VcsBranch {
    private String name;
    private String displayName;

    protected VcsBranchImpl() {
    }

    public VcsBranchImpl(@NotNull String name) {
        this.name = name;
    }

    public VcsBranchImpl(@NotNull String name, @NotNull String displayName) {
        this.name = name;
        this.displayName = displayName;
    }

    public VcsBranchImpl(@NotNull VcsBranch other) {
        this.name = other.getName();
        this.displayName = other.getDisplayName();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayName() {
        return StringUtils.isNotBlank((CharSequence)this.displayName) ? this.displayName : this.getName();
    }

    public boolean isEqualToBranchWith(@NotNull String otherName) {
        return this.name.equals(otherName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsBranchImpl vcsBranch = (VcsBranchImpl)o;
        return this.name.equals(vcsBranch.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "VCS Branch [" + this.name + ']';
    }
}

