/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.branch.BambooVcsBranch;
import com.atlassian.bamboo.plan.branch.BambooVcsBranchImpl;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchDao;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.util.BambooIterables;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsBranchManagerImpl
implements VcsBranchManager {
    private final VcsBranchDao vcsBranchDao;

    public VcsBranchManagerImpl(@NotNull VcsBranchDao vcsBranchDao) {
        this.vcsBranchDao = vcsBranchDao;
    }

    public List<BambooVcsBranch> findByChain(@NotNull ImmutableChain chain) {
        return this.vcsBranchDao.findByChain(chain);
    }

    @Nullable
    public BambooVcsBranch findByChainAndName(long chainId, @NotNull String branchName) {
        return this.vcsBranchDao.findByChainAndName(chainId, branchName);
    }

    public List<BambooVcsBranch> findNotDeletedByChain(@NotNull ImmutableChain chain) {
        return this.vcsBranchDao.findNotDeletedByChain(chain);
    }

    public List<BambooVcsBranch> findByChainId(long chainId) {
        return this.vcsBranchDao.findByChainId(chainId);
    }

    public void save(@NotNull BambooVcsBranch branch) {
        this.vcsBranchDao.save((BambooObject)branch);
    }

    public void deleteAll(@NotNull ImmutableChain chain) {
        this.vcsBranchDao.deleteAll(chain);
    }

    public void deleteAll(@NotNull Collection<BambooVcsBranch> vcsBranches) {
        this.vcsBranchDao.deleteAll(vcsBranches);
    }

    public void saveAll(@NotNull Iterable<BambooVcsBranch> vcsBranches) {
        this.createAll(vcsBranches);
    }

    public void createAll(@NotNull Iterable<BambooVcsBranch> vcsBranches) {
        List<BambooVcsBranch> entitiesToSave = BambooIterables.stream(vcsBranches).map(this::intern).collect(Collectors.toList());
        entitiesToSave.forEach(vcsBranch -> vcsBranch.setDetectedDeletionDate(null));
        this.vcsBranchDao.saveAll(entitiesToSave);
    }

    public void saveAll(@NotNull ImmutableChain chain, @NotNull Iterable<VcsBranch> vcsBranches) {
        this.createAll(chain, vcsBranches);
    }

    public void createAll(@NotNull ImmutableChain chain, @NotNull Iterable<VcsBranch> vcsBranches) {
        Chain mutableChain = chain instanceof Chain ? (Chain)chain : new DefaultChain();
        mutableChain.setId(chain.getId());
        List<BambooVcsBranch> entitiesToSave = BambooIterables.stream(vcsBranches).map(vcsBranch -> new BambooVcsBranchImpl(mutableChain, (VcsBranch)vcsBranch)).map(this::intern).collect(Collectors.toList());
        entitiesToSave.forEach(vcsBranch -> vcsBranch.setDetectedDeletionDate(null));
        this.vcsBranchDao.saveAll(entitiesToSave);
    }

    private BambooVcsBranch intern(@NotNull BambooVcsBranch vcsBranch) {
        if (vcsBranch.getId() > 0L) {
            return vcsBranch;
        }
        long chainId = vcsBranch.getChain() != null ? vcsBranch.getChain().getId() : vcsBranch.getChainId();
        BambooVcsBranch existing = this.vcsBranchDao.findByChainAndName(chainId, StringUtils.defaultString((String)vcsBranch.getName()));
        return existing != null ? existing : vcsBranch;
    }
}

