/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStorageTag;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.VcsBambooSpecsSource;
import com.atlassian.bamboo.plan.VcsBambooSpecsSourceImpl;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsState;
import com.atlassian.bamboo.plan.VcsLocationBambooSpecsStateImpl;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.cache.AbstractImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutablePlanManager;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.repository.RepositoryDefinitionImpl;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.NameProviderFunctions;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinitionImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImmutableChain
extends AbstractImmutablePlan
implements ImmutableChain {
    private static final Logger log = Logger.getLogger(AbstractImmutableChain.class);
    private final ImmutableList<ImmutableJob> allJobs;
    private final ImmutableList<ImmutableChainStage> stages;
    private final ImmutableList<ImmutableChainStage> allStages;
    private final PlanRepositoryDefinitionsLazyReference planRepositoryDefinitionsRef;
    private final VcsBambooSpecsSource vcsBambooSpecsSource;
    private final NotificationSet notificationSet;
    private final ImmutableChain master;
    private final ChainStorageTag storageTag;
    @NotNull
    private final ImmutablePlanCacheService immutablePlanCacheService;
    private final ResettableLazyReference<ImmutableResultsSummary> latestResultsSummary = new ResettableLazyReference<ImmutableResultsSummary>(){

        protected ImmutableResultsSummary create() throws Exception {
            return AbstractImmutableChain.this.immutablePlanManager.getLatestResultForPlan(AbstractImmutableChain.this.getPlanKey());
        }
    };
    @NotNull
    private final ImmutablePlanManager immutablePlanManager;
    private final Date creationDate;

    public AbstractImmutableChain(@NotNull Chain chain, BuildLoggerManager buildLoggerManager, ImmutablePlanCacheService immutablePlanCacheService, ImmutablePlanManager immutablePlanManager, LabelManager labelManager, ResultsSummaryManager resultsSummaryManager, RepositoryDefinitionManager repositoryDefinitionManager, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, VariableDefinitionManager variableDefinitionManager, @NotNull BuildDefinition buildDefinition) {
        super(chain.getId(), (ImmutablePlan)chain, buildLoggerManager, labelManager, variableDefinitionManager, buildDefinition, resultsSummaryManager);
        this.immutablePlanCacheService = immutablePlanCacheService;
        this.creationDate = chain.getCreationDate();
        this.immutablePlanManager = immutablePlanManager;
        ImmutableList.Builder stagesBuilder = ImmutableList.builder();
        ChainBranch chainBranch = (ChainBranch)Narrow.to((Object)chain, ChainBranch.class);
        if (chainBranch != null) {
            Chain masterChain = Objects.requireNonNull(chainBranch.getMaster(), "Chain branch without a linked master chain");
            ImmutableChain immutableMasterChain = immutablePlanCacheService.getImmutablePlanByKey(masterChain.getPlanKey());
            this.master = Objects.requireNonNull(immutableMasterChain, "Master chain not found in plan cache");
            for (ChainStage stage : masterChain.getStages()) {
                stagesBuilder.add((Object)immutablePlanManager.createImmutableStage((ImmutableChain)this, stage));
            }
        } else {
            this.master = null;
            for (ChainStage stage : chain.getStages()) {
                stagesBuilder.add((Object)immutablePlanManager.createImmutableStage((ImmutableChain)this, stage));
            }
        }
        this.planRepositoryDefinitionsRef = new PlanRepositoryDefinitionsLazyReference(repositoryDefinitionManager, cachedRepositoryDefinitionManager);
        VcsBambooSpecsSource mutableState = chain.getVcsBambooSpecsSource();
        if (mutableState != null) {
            VcsLocationBambooSpecsState vcsLocation = mutableState.getVcsLocationBambooSpecsState();
            VcsLocationBambooSpecsStateImpl vcsLocationBambooSpecsState = new VcsLocationBambooSpecsStateImpl(vcsLocation.getVcsLocationId(), vcsLocation.getBranch(), vcsLocation.getRevision());
            this.vcsBambooSpecsSource = mutableState.getSourceLocation().map(sourceLocation -> VcsBambooSpecsSourceImpl.yamlSpecsSource(vcsLocationBambooSpecsState, sourceLocation)).orElseGet(() -> VcsBambooSpecsSourceImpl.javaSpecsSource(vcsLocationBambooSpecsState));
        } else {
            this.vcsBambooSpecsSource = null;
        }
        this.allStages = stagesBuilder.build();
        this.stages = this.allStages;
        log.trace((Object)"CACHE_TRACE adding jobs");
        ImmutableList.Builder jobsBuilder = ImmutableList.builder();
        for (ChainStage stage : this.stages) {
            jobsBuilder.addAll((Iterable)Comparators.getNameProviderCaseInsensitiveOrdering().immutableSortedCopy((Iterable)stage.getJobs()));
        }
        log.trace((Object)"CACHE_TRACE /adding jobs");
        this.allJobs = jobsBuilder.build();
        this.notificationSet = chain.getNotificationSet();
        this.storageTag = chain.getStorageTag();
        log.trace((Object)"CACHE_TRACE AbstractImmutableChain created");
    }

    public boolean isActive() {
        return ((ChainExecutionManager)ComponentAccessor.CHAIN_EXECUTION_MANAGER.get()).isActive(this.getPlanKey());
    }

    public boolean isExecuting() {
        return ((ChainExecutionManager)ComponentAccessor.CHAIN_EXECUTION_MANAGER.get()).isExecuting(this.getPlanKey());
    }

    @Nullable
    public PlanResultKey getLastResultKey() {
        List chainExecutions = ((ChainExecutionManager)ComponentAccessor.CHAIN_EXECUTION_MANAGER.get()).getExecutingChains(this.getPlanKey());
        if (!chainExecutions.isEmpty()) {
            PlanResultKey resultKey = ((ChainExecution)Iterables.getFirst((Iterable)chainExecutions, null)).getPlanResultKey();
            for (ChainExecution chainExecution : Iterables.skip((Iterable)chainExecutions, (int)1)) {
                if (chainExecution.getPlanResultKey().getBuildNumber() <= resultKey.getBuildNumber()) continue;
                resultKey = chainExecution.getPlanResultKey();
            }
            return resultKey;
        }
        ImmutableResultsSummary latestResultsSummary = this.getLatestResultsSummary();
        return latestResultsSummary == null ? null : latestResultsSummary.getPlanResultKey();
    }

    public ImmutableResultsSummary getLatestResultsSummary() {
        return (ImmutableResultsSummary)this.latestResultsSummary.get();
    }

    @Override
    @Internal
    public void resetLatestResultsSummary(int latestKnownBuildNumber) {
        AbstractImmutablePlan.resetLatestResultsSummary(this.latestResultsSummary, latestKnownBuildNumber);
    }

    public boolean isBusy() {
        return ((PlanExecutionManager)ComponentAccessor.PLAN_EXECUTION_MANAGER.get()).isBusy(this.getPlanKey());
    }

    @NotNull
    public ImmutableList<ImmutableChainStage> getStages() {
        return ImmutableList.copyOf((Collection)this.immutablePlanCacheService.filterOutDeletedIfNeeded(this.stages));
    }

    @NotNull
    public ImmutableList<ImmutableChainStage> getAllStages() {
        return this.allStages;
    }

    public int getJobCount() {
        return this.getAllJobs().size();
    }

    @NotNull
    public ImmutableList<ImmutableJob> getAllJobs() {
        return this.allJobs;
    }

    public boolean containsStage(@Nullable String stageName) {
        if (stageName != null) {
            return this.getStages().stream().anyMatch(NameProviderFunctions.isNameEqual((String)stageName));
        }
        return false;
    }

    @NotNull
    public ImmutableList<RepositoryDefinition> getEffectiveRepositoryDefinitions() {
        return (ImmutableList)this.getPlanRepositoryDefinitions().stream().map(RepositoryDefinitionImpl::new).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public List<PlanRepositoryDefinition> getPlanRepositoryDefinitions() {
        return ((PlanRepositoryDefinitionsSupplier)this.planRepositoryDefinitionsRef.get()).get();
    }

    public NotificationSet getNotificationSet() {
        return this.notificationSet;
    }

    public ImmutableChain getMaster() {
        return this.master;
    }

    public boolean isSuspended() {
        return this.isSuspendedFromBuilding();
    }

    @NotNull
    public List<TriggerDefinition> getTriggerDefinitions() {
        return this.getBuildDefinition().getTriggerDefinitions();
    }

    public ChainStorageTag getStorageTag() {
        return this.storageTag;
    }

    @Nullable
    public VcsBambooSpecsSource getVcsBambooSpecsSource() {
        return this.vcsBambooSpecsSource;
    }

    @NotNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    private class PlanRepositoryDefinitionsLazyReference
    extends LazyReference<PlanRepositoryDefinitionsSupplier> {
        private final RepositoryDefinitionManager repositoryDefinitionManager;
        private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;

        public PlanRepositoryDefinitionsLazyReference(RepositoryDefinitionManager repositoryDefinitionManager, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager) {
            this.repositoryDefinitionManager = repositoryDefinitionManager;
            this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        }

        @NotNull
        protected PlanRepositoryDefinitionsSupplier create() throws Exception {
            if (AbstractImmutableChain.this.hasMaster()) {
                return new PlanRepositoryDefinitionsSupplier(this.cachedRepositoryDefinitionManager, ChainBranchImpl.createEffectivePlanRepositoryDefinitions(this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)AbstractImmutableChain.this), AbstractImmutableChain.this.master.getPlanRepositoryDefinitions()));
            }
            return new PlanRepositoryDefinitionsSupplier(this.cachedRepositoryDefinitionManager, this.repositoryDefinitionManager.getPlanRepositoryDefinitions((PlanIdentifier)AbstractImmutableChain.this));
        }
    }

    private class PlanRepositoryDefinitionsSupplier
    implements Supplier<ImmutableList<PlanRepositoryDefinition>> {
        private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
        private final List<Pair<Long, Integer>> repositoryIdsAndPositions;

        public PlanRepositoryDefinitionsSupplier(CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, List<PlanRepositoryDefinition> repositoryDefinitions) {
            this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
            this.repositoryIdsAndPositions = repositoryDefinitions.stream().map(prd -> Pair.make((Object)prd.getId(), (Object)prd.getPosition())).collect(Collectors.toList());
        }

        @Override
        public ImmutableList<PlanRepositoryDefinition> get() {
            return ImmutableList.copyOf((Collection)this.repositoryIdsAndPositions.stream().map(idAndPos -> {
                VcsRepositoryData repositoryData = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(((Long)idAndPos.getFirst()).longValue());
                if (repositoryData == null) {
                    log.warn((Object)("Plan references a repository which does not exist: " + idAndPos.getFirst()));
                }
                return repositoryData != null ? PlanRepositoryDefinitionImpl.createForPosition(repositoryData, (Integer)idAndPos.getSecond()) : null;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }
}

