/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.helpers.EffectivePlanPropertiesHelper;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImmutablePlan
implements ImmutablePlan {
    private static final Logger log = Logger.getLogger(AbstractImmutablePlan.class);
    private final Long id;
    private final PlanKey planKey;
    private final String description;
    private final String name;
    private final String buildName;
    private final boolean suspendedFromBuilding;
    private final BambooEntityOid oid;
    private boolean markedForDeletion;
    private final PlanType planType;
    private final BuildDefinition buildDefinition;
    private final Project project;
    private final ImmutableList<String> labelNames;
    private final LazyReference<ImmutableList<VariableDefinition>> variableDefinitionsRef;
    private final LazyReference<ImmutableList<VariableDefinition>> effectiveVariableDefinitionsRef;
    private final BuildLoggerManager buildLoggerManager;
    protected final ResultsSummaryManager resultsSummaryManager;
    protected LazyReference<Long> averageBuildDuration = new LazyReference<Long>(){

        protected Long create() throws Exception {
            return AbstractImmutablePlan.this.resultsSummaryManager.getAveragePlanExecutionDuration((ImmutablePlan)AbstractImmutablePlan.this, 10);
        }
    };

    public AbstractImmutablePlan(@Nullable Long databaseId, @NotNull ImmutablePlan plan, BuildLoggerManager buildLoggerManager, @NotNull LabelManager labelManager, VariableDefinitionManager variableDefinitionManager, @NotNull BuildDefinition buildDefinition, ResultsSummaryManager resultsSummaryManager) {
        this(databaseId, plan, plan.getPlanKey(), plan.getName(), buildLoggerManager, labelManager, variableDefinitionManager, buildDefinition, resultsSummaryManager);
    }

    protected AbstractImmutablePlan(@Nullable Long databaseId, @NotNull ImmutablePlan plan, @NotNull PlanKey planKey, @NotNull String name, BuildLoggerManager buildLoggerManager, @NotNull LabelManager labelManager, VariableDefinitionManager variableDefinitionManager, @NotNull BuildDefinition buildDefinition, ResultsSummaryManager resultsSummaryManager) {
        this.buildLoggerManager = buildLoggerManager;
        this.resultsSummaryManager = resultsSummaryManager;
        ImmutablePlan masterPlan = (ImmutablePlan)MoreObjects.firstNonNull((Object)plan.getMaster(), (Object)plan);
        if (masterPlan == null) {
            throw new IllegalArgumentException("Cannot evaluate master plan");
        }
        this.id = databaseId;
        this.planKey = planKey;
        this.description = plan.getDescription();
        this.name = name;
        this.buildName = plan.getBuildName();
        this.suspendedFromBuilding = plan.isSuspendedFromBuilding();
        this.oid = plan.getOid();
        this.planType = plan.getPlanType();
        this.markedForDeletion = plan.isMarkedForDeletion();
        this.project = plan.getProject();
        this.buildDefinition = buildDefinition;
        this.variableDefinitionsRef = new VariableListLazyReference(variableDefinitionManager);
        this.effectiveVariableDefinitionsRef = new EffectiveVariableListLazyReference();
        this.labelNames = (ImmutableList)labelManager.getPlanLabels(plan).stream().map(Label::getName).collect(CollectorsUtil.toImmutableList());
    }

    public long getId() {
        if (this.id == null) {
            throw new IllegalStateException("Plan " + this.planKey + " is not a DB object");
        }
        return this.id;
    }

    @NotNull
    public Optional<Long> getDatabaseId() {
        return Optional.ofNullable(this.id);
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public String getKey() {
        return this.planKey.getKey();
    }

    @NotNull
    public String getBuildKey() {
        return (String)Preconditions.checkNotNull((Object)PlanKeys.getPlanKeyPart((PlanKey)this.getPlanKey()), (Object)("Cannot extract plan portion of key from " + this.getPlanKey()));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getBuildName() {
        return this.buildName;
    }

    @NotNull
    public PlanType getPlanType() {
        return this.planType;
    }

    @NotNull
    public String getType() {
        return this.getPlanType().name();
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public boolean hasMaster() {
        return this.getMaster() != null;
    }

    @NotNull
    public List<VariableDefinition> getVariables() {
        return (List)this.variableDefinitionsRef.get();
    }

    @NotNull
    public List<VariableDefinition> getEffectiveVariables() {
        return (List)this.effectiveVariableDefinitionsRef.get();
    }

    public boolean isSuspendedFromBuilding() {
        return this.suspendedFromBuilding;
    }

    private Range<Integer> getBuildNumberRange() {
        return ((ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get()).getBuildNumbersRange(this.planKey);
    }

    public int getFirstBuildNumber() {
        return (Integer)this.getBuildNumberRange().getMinimum();
    }

    public int getLastBuildNumber() {
        return (Integer)this.getBuildNumberRange().getMaximum();
    }

    @NotNull
    public BuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    public long getAverageBuildDuration() {
        return (Long)this.averageBuildDuration.get();
    }

    public long getMasterId() {
        ImmutablePlan master = this.getMaster();
        return master != null ? master.getId() : -1L;
    }

    @NotNull
    public Optional<Long> getMasterIdIfExists() {
        ImmutablePlan master = this.getMaster();
        return master != null ? Optional.of(master.getId()) : Optional.empty();
    }

    @NotNull
    public List<Labelling> getLabellings() {
        throw new UnsupportedOperationException("This is deprecated");
    }

    @NotNull
    public List<Labelling> getRelatedLabellings() {
        throw new UnsupportedOperationException("To be done");
    }

    @NotNull
    public List<String> getLabelNames() {
        return this.labelNames;
    }

    @NotNull
    public String getCurrentStatus() {
        return PlanHelper.getCurrentStatus(this);
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    @Internal
    public abstract void resetLatestResultsSummary(int var1);

    protected void exceptionOnModification() {
        throw new UnsupportedOperationException("Setters cannot be called for Immutable object");
    }

    @NotNull
    public BuildLogger getBuildLogger() {
        return this.buildLoggerManager.getLogger((Key)this.getPlanKey());
    }

    public int hashCode() {
        return this.planKey.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImmutablePlan)) {
            return false;
        }
        ImmutablePlan rhs = (ImmutablePlan)o;
        return new EqualsBuilder().append((Object)this.getPlanKey(), (Object)rhs.getPlanKey()).isEquals();
    }

    public int compareTo(ImmutablePlan plan) {
        return new CompareToBuilder().append((Object)this.getPlanKey(), (Object)plan.getPlanKey()).toComparison();
    }

    static void resetLatestResultsSummary(ResettableLazyReference<? extends ImmutableResultsSummary> latestResultsSummary, int latestKnownBuildNumber) {
        ImmutableResultsSummary rs;
        if (latestResultsSummary.isInitialized() && ((rs = (ImmutableResultsSummary)latestResultsSummary.get()) == null || rs.getPlanResultKey().getBuildNumber() <= latestKnownBuildNumber)) {
            latestResultsSummary.reset();
        }
    }

    private class EffectiveVariableListLazyReference
    extends LazyReference<ImmutableList<VariableDefinition>> {
        private EffectiveVariableListLazyReference() {
        }

        @NotNull
        protected ImmutableList<VariableDefinition> create() throws Exception {
            return ImmutableList.copyOf(EffectivePlanPropertiesHelper.createEffectiveVariableDefinitions(AbstractImmutablePlan.this, AbstractImmutablePlan.this.getVariables()));
        }
    }

    private class VariableListLazyReference
    extends LazyReference<ImmutableList<VariableDefinition>> {
        private final VariableDefinitionManager variableDefinitionManager;

        public VariableListLazyReference(VariableDefinitionManager variableDefinitionManager) {
            this.variableDefinitionManager = variableDefinitionManager;
        }

        @NotNull
        protected ImmutableList<VariableDefinition> create() throws Exception {
            return ImmutableList.copyOf((Collection)this.variableDefinitionManager.getPlanVariables((PlanIdentifier)AbstractImmutablePlan.this));
        }
    }
}

