/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.chains.DefaultChain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.branch.ChainBranchImpl;
import com.atlassian.bamboo.plan.branch.cache.ImmutableChainBranchImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChainImpl;
import com.atlassian.bamboo.plan.cache.ImmutableJobImpl;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooImmutables {
    private static final Map<Class<?>, Class<?>> IMMUTABLE_TO_MUTABLE = new HashMap();
    private static final Set<Class<?>> MUTABLES = new HashSet();

    private static <I extends ImmutablePlan, M extends Plan> void addPlanMapping(Class<I> immutable, Class<M> mutable) {
        IMMUTABLE_TO_MUTABLE.put(immutable, mutable);
        MUTABLES.add(mutable);
    }

    private BambooImmutables() {
    }

    @Nullable
    public static <T> Class<? extends T> getMutableClass(@NotNull Class<T> immutableClass) {
        if (MUTABLES.contains(immutableClass)) {
            return immutableClass;
        }
        return IMMUTABLE_TO_MUTABLE.get(immutableClass);
    }

    static {
        BambooImmutables.addPlanMapping(ImmutableChainImpl.class, DefaultChain.class);
        BambooImmutables.addPlanMapping(ImmutableChainBranchImpl.class, ChainBranchImpl.class);
        BambooImmutables.addPlanMapping(ImmutableJobImpl.class, DefaultJob.class);
    }
}

