/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.utils.BambooCallables;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.transaction.support.TransactionTemplate;

public class CacheLoadContextSupport {
    private static final Logger log = Logger.getLogger(CacheLoadContextSupport.class);
    private static final ThreadLocal<AtomicInteger> cacheLoadNestingLevel = ThreadLocal.withInitial(AtomicInteger::new);
    private static final ThreadLocal<HibernateTemplate> hibernateTemplate = ThreadLocal.withInitial(() -> {
        throw new IllegalStateException("No session bound to thread");
    });

    private CacheLoadContextSupport() {
    }

    public static boolean isInCacheLoadContext() {
        return cacheLoadNestingLevel.get().get() > 0;
    }

    private static boolean leaveCacheLoadContext() {
        Preconditions.checkState((cacheLoadNestingLevel.get().get() > 0 ? 1 : 0) != 0);
        int i = cacheLoadNestingLevel.get().decrementAndGet();
        Preconditions.checkState((i >= 0 ? 1 : 0) != 0);
        if (i == 0) {
            cacheLoadNestingLevel.remove();
            return true;
        }
        return false;
    }

    private static void enterCacheLoadContext() {
        cacheLoadNestingLevel.get().incrementAndGet();
    }

    public static HibernateTemplate getHibernateTemplate() {
        return hibernateTemplate.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V load(@NotNull TransactionTemplate transactionTemplate, @NotNull SessionFactory sessionFactory, @NotNull Callable<V> callable) {
        log.trace((Object)"CACHE_TRACE load()");
        long start = System.currentTimeMillis();
        boolean alreadyInCacheLoadContext = CacheLoadContextSupport.isInCacheLoadContext();
        CacheLoadContextSupport.enterCacheLoadContext();
        try {
            if (alreadyInCacheLoadContext) {
                Object object = BambooCallables.callUnchecked(callable);
                return (V)object;
            }
            Object object = BambooSpringUtils.readOnly(BambooSpringUtils.requiresNew(transactionTemplate)).execute(transactionStatus -> {
                hibernateTemplate.set(CacheLoadContextSupport.newFixedSessionHibernateTemplate(sessionFactory));
                return BambooCallables.callUnchecked((Callable)callable);
            });
            return (V)object;
        }
        finally {
            if (CacheLoadContextSupport.leaveCacheLoadContext()) {
                CacheLoadContextSupport.onFinishCacheLoad();
            }
            long elapsed = System.currentTimeMillis() - start;
            log.trace((Object)("CACHE_TRACE /load(), time spent in cache load context: " + elapsed + "ms"));
        }
    }

    private static void onFinishCacheLoad() {
        hibernateTemplate.remove();
    }

    private static HibernateTemplate newFixedSessionHibernateTemplate(final SessionFactory sessionFactory) {
        final Session fixedSession = sessionFactory.getCurrentSession();
        return new HibernateTemplate(){

            public SessionFactory getSessionFactory() {
                return sessionFactory;
            }

            protected <T> T doExecute(HibernateCallback<T> action, boolean enforceNativeSession) throws DataAccessException {
                try {
                    return (T)action.doInHibernate(fixedSession);
                }
                catch (HibernateException e) {
                    throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)e);
                }
            }
        };
    }
}

