/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.plan.FilteringPlanManager;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.atlassian.bamboo.plan.cache.index.PlanBranchCacheIndex;
import com.atlassian.bamboo.plan.cache.index.PlanRepositoryIndex;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacadeImpl;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.Comparators;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

public class CachedPlanManagerImpl
implements CachedPlanManager,
FilteringPlanManager {
    private static final Logger log = Logger.getLogger(CachedPlanManagerImpl.class);
    @Lazy
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;
    @Lazy
    @Inject
    private ApplicationContext applicationContext;

    @Nullable
    public ImmutablePlan getPlanByKey(@NotNull PlanKey planKey) {
        if (PlanKeys.isJobKey((PlanKey)planKey)) {
            ImmutableChain chain = this.immutablePlanCacheService.getImmutablePlanByKey(PlanKeys.getChainKeyFromJobKey((PlanKey)planKey));
            if (chain == null) {
                return null;
            }
            return chain.getAllJobs().stream().filter(PlanPredicates.hasEqualPlanKey(planKey)).findFirst().orElse(null);
        }
        return this.immutablePlanCacheService.getImmutablePlanByKey(planKey);
    }

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKey(@NotNull PlanKey planKey, Class<T> planType) throws IncorrectPlanTypeException {
        ImmutablePlan plan = this.getPlanByKey(planKey);
        if (plan == null) {
            return null;
        }
        T narrowedPlan = this.safePlanNarrow(plan, planType);
        if (narrowedPlan == null) {
            throw new IncorrectPlanTypeException("Plan cannot be found by key '" + planKey.getKey() + "' with type '" + planType + "'");
        }
        return narrowedPlan;
    }

    @Nullable
    public <T extends ImmutablePlan> T getPlanByKeyIfOfType(@NotNull PlanKey planKey, @NotNull Class<T> planType) {
        return this.safePlanNarrow(this.getPlanByKey(planKey), planType);
    }

    @NotNull
    public List<ImmutableTopLevelPlan> getPlans() {
        return CachedPlanManagerImpl.sortedCopy(this.immutablePlanCacheService.getPlans(ImmutableTopLevelPlan.class, input -> true));
    }

    @NotNull
    public List<ImmutableTopLevelPlan> getPlansUnrestricted() {
        return CachedPlanManagerImpl.sortedCopy(this.immutablePlanCacheService.getPlans(ImmutableTopLevelPlan.class, input -> true));
    }

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> planType) {
        return CachedPlanManagerImpl.sortedCopy(this.immutablePlanCacheService.getPlans(planType, input -> true));
    }

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> planType, @NotNull com.google.common.base.Predicate<? super T> filter) {
        return CachedPlanManagerImpl.sortedCopy(this.immutablePlanCacheService.getPlans(planType, filter));
    }

    @NotNull
    public List<ImmutableTopLevelPlan> getPlansByProject(Project project) {
        return this.getPlansByProject(project, ImmutableTopLevelPlan.class);
    }

    @NotNull
    public Iterable<ImmutableTopLevelPlan> getEditablePlansByProject(Project project) {
        return this.getPlansByProject(project, ImmutableTopLevelPlan.class);
    }

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlansByProject(Project project, Class<T> planType) {
        return this.getPlans(planType, PlanPredicates.withEqualProjectKey(project)::test);
    }

    public <T extends ImmutablePlan> List<T> getPlansByProject(@NotNull Project project, @NotNull Class<T> planType, @NotNull com.google.common.base.Predicate<? super T> filter) {
        return this.getPlans(planType, Predicates.and(PlanPredicates.withEqualProjectKey(project)::test, filter));
    }

    @NotNull
    public List<ImmutableChainBranch> getBranchesForChain(@NotNull PlanIdentifier chain) {
        return CachedPlanManagerImpl.sortedCopy(this.getBranchesOfChain(chain.getPlanKey()).collect(Collectors.toList()).stream());
    }

    @NotNull
    public Stream<ImmutableChainBranch> getBranchesOfChain(@NotNull PlanKey chainKey) {
        Set<PlanKey> branchKeys = this.getBranchKeysOfChain(chainKey);
        return this.toChains(branchKeys).filter(BambooPredicates.testFirstApplyToAll(this.hasReadPermission())).map(ImmutableChainBranch.class::cast);
    }

    @NotNull
    public Set<PlanKey> getBranchKeysOfChain(@NotNull PlanKey chainKey) {
        return this.getPlanBranchCacheIndex().getBranchKeys(chainKey);
    }

    @NotNull
    public Set<PlanBranchGist> getBranchGistsOfChain(@NotNull PlanKey chainKey) {
        return this.getPlanBranchCacheIndex().getBranchGists(chainKey);
    }

    @Nullable
    public ImmutableChain getMasterPlan(@NotNull PlanKey branchKey) {
        ImmutableChain branch = this.immutablePlanCacheService.getImmutablePlanByKey(branchKey);
        if (branch == null) {
            return null;
        }
        return branch.hasMaster() ? branch.getMaster() : branch;
    }

    public boolean isBranchOf(@NotNull PlanKey chainKey, @NotNull PlanKey branchKey) {
        ImmutableChain master = this.getMasterPlan(branchKey);
        return master != null && chainKey.equals((Object)master.getPlanKey());
    }

    public boolean assertPlanPermission(@NotNull PlanIdentifier plan) {
        return true;
    }

    @NotNull
    public List<ImmutableChain> getPlansForClone() {
        return this.getPlans(ImmutableChain.class, PlanPredicates::planIsMaster);
    }

    @NotNull
    public <T extends ImmutablePlan> List<T> getRunnablePlans(@NotNull Project project, @NotNull Class<T> planType) {
        return this.getPlansByProject(project, planType);
    }

    @Nullable
    public ImmutableJob getMasterOfJob(@NotNull PlanKey masterChainKey, @NotNull PlanKey jobKey) {
        PlanKey chainKey = PlanKeys.getChainKeyIfJobKey((PlanKey)jobKey);
        if (chainKey == null) {
            throw new IllegalArgumentException("Not a Job key: " + jobKey);
        }
        ImmutableChain masterChain = this.getPlanByKey(masterChainKey, ImmutableChain.class);
        if (masterChain != null) {
            for (ImmutableJob candidateJob : masterChain.getAllJobs()) {
                if (!PlanKeys.getPartialJobKey((PlanKey)jobKey).equals(PlanKeys.getPartialJobKey((PlanKey)candidateJob.getPlanKey()))) continue;
                return candidateJob;
            }
        }
        return null;
    }

    public Iterable<ImmutableChain> getPlansWithRepository(@NotNull PlanRepositoryIndex.Query query) {
        return this.toChains(this.getPlanRepositoryIndex().getPlans(query)).collect(Collectors.toList());
    }

    public Stream<ImmutableChain> getFilteredPlansWithRepository(@NotNull PlanRepositoryIndex.Query query) {
        return this.toChains(this.getPlanRepositoryIndex().getPlans(query)).filter(this.hasReadPermission());
    }

    public Optional<ImmutableChain> getAnyPlan(Predicate<? super ImmutableChain> predicate) {
        return this.immutablePlanCacheService.getAnyPlan(this.hasReadPermission().and(predicate));
    }

    public Optional<ImmutableChain> getAnyPlanUnrestricted(Predicate<? super ImmutableChain> predicate) {
        return this.immutablePlanCacheService.getAnyPlan(predicate);
    }

    @NotNull
    private Predicate<ImmutableChain> hasReadPermission() {
        BambooCachingPermissionManagerFacade permissionManager = (BambooCachingPermissionManagerFacade)this.applicationContext.getBean(BambooCachingPermissionManagerFacadeImpl.class);
        return chain -> permissionManager.hasPermission((Permission)BambooPermission.READ, chain);
    }

    @Nullable
    public <T extends ImmutablePlan> T getPlanById(long id, Class<T> planType) {
        ImmutablePlan parent;
        ImmutableChain chain;
        PlanKey planKey = this.immutablePlanCacheService.getIndices().getPlanIdIndexer().getChain(id);
        if (planKey != null) {
            ImmutablePlan planByKey = this.getPlanByKey(planKey);
            if (planByKey == null) {
                return null;
            }
            T narrowedPlan = this.safePlanNarrow(planByKey, planType);
            if (narrowedPlan == null) {
                throw new IncorrectPlanTypeException("Plan with id " + id + " / plan key [" + planKey + "] has type " + planByKey.getClass() + " instead of requested " + planType);
            }
            return narrowedPlan;
        }
        PlanKey parentKey = this.immutablePlanCacheService.getIndices().getPlanIdIndexer().getChainOfJob(id);
        if (parentKey != null && (chain = (ImmutableChain)Narrow.downTo((Object)(parent = this.getPlanByKey(parentKey)), ImmutableChain.class)) != null) {
            ImmutableJob onlyElement = chain.getAllJobs().stream().filter(arg_0 -> BambooPredicates.hasBambooObjectEqualId(id).apply(arg_0)).findFirst().orElseThrow(NoSuchElementException::new);
            T narrowedPlan = this.safePlanNarrow((ImmutablePlan)onlyElement, planType);
            if (narrowedPlan == null) {
                throw new IncorrectPlanTypeException("Plan cannot be found by id '" + id + "' with type '" + planType + "'");
            }
            return narrowedPlan;
        }
        return null;
    }

    @Nullable
    public <T extends ImmutablePlan> T getPlanByIdNotThrowing(long id, Class<T> planType) {
        try {
            return this.getPlanById(id, planType);
        }
        catch (IncorrectPlanTypeException | NoSuchElementException e) {
            log.debug((Object)"Plan not found: ", e);
            return null;
        }
    }

    public Set<Project> getAllProjectsWithPlan() {
        return this.immutablePlanCacheService.getPlans(ImmutableTopLevelPlan.class, t -> true).filter(p -> !p.isMarkedForDeletion()).map(p -> p.getProject()).filter(prj -> !prj.isMarkedForDeletion()).collect(Collectors.toSet());
    }

    private PlanBranchCacheIndex getPlanBranchCacheIndex() {
        return this.immutablePlanCacheService.getIndices().getPlanBranchCacheIndex();
    }

    private PlanRepositoryIndex getPlanRepositoryIndex() {
        return this.immutablePlanCacheService.getIndices().getPlanRepositoryIndex();
    }

    private static <T extends ImmutablePlan> List<T> sortedCopy(Stream<T> plans) {
        return plans.sorted((Comparator<ImmutablePlan>)Comparators.getPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toCollection(ArrayList::new));
    }

    private Stream<ImmutableChain> toChains(Collection<PlanKey> planKeys) {
        HashSet plansRetrievedFromCache = new HashSet();
        Stream<ImmutableChain> chainsAlreadyInCache = planKeys.stream().map(planKey -> this.immutablePlanCacheService.getImmutableChainByKeyIfInCache(planKey)).filter(Objects::nonNull).peek(chain -> plansRetrievedFromCache.add(chain.getPlanKey()));
        Stream<ImmutableChain> chainsToBeLoaded = planKeys.stream().filter(planKey -> !plansRetrievedFromCache.contains(planKey)).map(planKey -> this.immutablePlanCacheService.getImmutablePlanByKey(planKey)).filter(Objects::nonNull);
        return Stream.concat(chainsAlreadyInCache, chainsToBeLoaded);
    }

    private <T extends ImmutablePlan> T safePlanNarrow(ImmutablePlan plan, @NotNull Class<T> clazz) {
        if (BuildUtils.isDevMode()) {
            Preconditions.checkArgument((!Plan.class.isAssignableFrom(clazz) ? 1 : 0) != 0, (Object)"Using immutable manager to get mutable class");
        }
        return (T)((ImmutablePlan)Narrow.downTo((Object)plan, clazz));
    }
}

