/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.JobStatusHelper;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactDefinitionListLazyReference;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscription;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactSubscriptionListLazyReference;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.cache.AbstractImmutablePlan;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.collect.ImmutableList;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ImmutableJobImpl
extends AbstractImmutablePlan
implements ImmutableJob {
    private static final Logger log = Logger.getLogger(ImmutableJobImpl.class);
    private final ImmutableChain parent;
    private final ImmutableChainStage stage;
    private final ImmutableJob master;
    private final ImmutableArtifactDefinitionListLazyReference artifactDefinitionsRef;
    private final ImmutableArtifactSubscriptionListLazyReference artifactSubscriptionsRef;
    private final RequirementSet requirementSet;
    private final RequirementSet effectiveRequirementSet;
    private final BuildDefinitionLazyReference buildDefinitionRef;
    @Deprecated
    private final JobStatusHelper jobStatusHelper;
    private final ResettableLazyReference<ResultsSummary> latestResultsSummary = new ResettableLazyReference<ResultsSummary>(){

        protected ResultsSummary create() throws Exception {
            return ImmutableJobImpl.this.resultsSummaryManager.getLastResultsSummary(ImmutableJobImpl.this.getKey(), BuildResultsSummary.class);
        }
    };

    public ImmutableJobImpl(ImmutableChain parent, ImmutableChainStage stage, Job job, BuildLoggerManager buildLoggerManager, LabelManager labelManager, VariableDefinitionManager variableDefinitionManager, TaskManager taskManager, ResultsSummaryManager resultsSummaryManager, BuildDefinition buildDefinition, CachedPlanManager cachedPlanManager, ImmutableArtifactManager immutableArtifactManager) {
        super(ImmutableJobImpl.getDatabaseIdIfPresent(parent, job), (ImmutablePlan)job, PlanKeys.getJobKey((PlanKey)parent.getPlanKey(), (String)PlanKeys.getPartialJobKey((PlanKey)job.getPlanKey())), parent.getName() + " - " + job.getBuildName(), buildLoggerManager, labelManager, variableDefinitionManager, buildDefinition, resultsSummaryManager);
        this.parent = parent;
        this.stage = stage;
        ImmutableChain masterOfParent = parent.getMaster();
        this.master = masterOfParent != null ? cachedPlanManager.getMasterOfJob(masterOfParent.getPlanKey(), job.getPlanKey()) : null;
        this.artifactDefinitionsRef = new ImmutableArtifactDefinitionListLazyReference(immutableArtifactManager, this);
        this.artifactSubscriptionsRef = new ImmutableArtifactSubscriptionListLazyReference(immutableArtifactManager, this);
        this.buildDefinitionRef = new BuildDefinitionLazyReference(taskManager);
        this.requirementSet = job.getRequirementSet();
        this.effectiveRequirementSet = this.master != null ? this.master.getRequirementSet() : this.requirementSet;
        this.jobStatusHelper = new JobStatusHelper(this, (BuildExecutionManager)ComponentAccessor.BUILD_EXECUTION_MANAGER.get());
    }

    private static Long getDatabaseIdIfPresent(ImmutableChain chain, Job job) {
        if (!chain.hasMaster()) {
            return job.getId();
        }
        ImmutableChainBranch chainBranch = (ImmutableChainBranch)Narrow.downTo((Object)job.getParent(), ChainBranch.class);
        if (chainBranch != null) {
            return job.getId();
        }
        return null;
    }

    @NotNull
    public ImmutableChain getParent() {
        return this.parent;
    }

    @NotNull
    public ImmutableChainStage getStage() {
        return this.stage;
    }

    @NotNull
    public RequirementSet getRequirementSet() {
        return this.requirementSet;
    }

    @NotNull
    public RequirementSet getEffectiveRequirementSet() {
        return this.effectiveRequirementSet;
    }

    @Override
    @NotNull
    public List<VariableDefinition> getVariables() {
        if (this.hasMaster()) {
            return this.master.getVariables();
        }
        return super.getVariables();
    }

    @Override
    @NotNull
    public List<VariableDefinition> getEffectiveVariables() {
        if (this.hasMaster()) {
            return this.master.getEffectiveVariables();
        }
        return super.getEffectiveVariables();
    }

    public ImmutableJob getMaster() {
        return this.master;
    }

    public boolean isBusy() {
        return ((PlanExecutionManager)ComponentAccessor.PLAN_EXECUTION_MANAGER.get()).isBusy(this.getPlanKey());
    }

    public boolean isActive() {
        return this.jobStatusHelper.isActive();
    }

    @Override
    @NotNull
    public String getCurrentStatus() {
        return this.jobStatusHelper.getCurrentStatus();
    }

    public boolean isExecuting() {
        return this.jobStatusHelper.isExecuting();
    }

    public ResultsSummary getLatestResultsSummary() {
        return (ResultsSummary)this.latestResultsSummary.get();
    }

    @Override
    public void resetLatestResultsSummary(int latestKnownBuildNumber) {
        AbstractImmutablePlan.resetLatestResultsSummary(this.latestResultsSummary, latestKnownBuildNumber);
    }

    @NotNull
    public ImmutableList<ImmutableArtifactDefinition> getArtifactDefinitions() {
        return (ImmutableList)this.artifactDefinitionsRef.get();
    }

    @NotNull
    public ImmutableList<ImmutableArtifactSubscription> getArtifactSubscriptions() {
        return (ImmutableList)this.artifactSubscriptionsRef.get();
    }

    @Override
    @NotNull
    public BuildDefinition getBuildDefinition() {
        return (BuildDefinition)this.buildDefinitionRef.get();
    }

    @NotNull
    public List<TaskDefinition> getTaskDefinitions() {
        return this.getBuildDefinition().getTaskDefinitions();
    }

    private class BuildDefinitionLazyReference
    extends LazyReference<BuildDefinition> {
        private final TaskManager taskManager;

        private BuildDefinitionLazyReference(TaskManager taskManager) {
            this.taskManager = taskManager;
        }

        protected BuildDefinition create() throws Exception {
            if (ImmutableJobImpl.this.hasMaster()) {
                ImmutableChain masterChain = ImmutableJobImpl.this.parent.getMaster();
                List branchRepositories = ImmutableJobImpl.this.parent.getPlanRepositoryDefinitions();
                Map<Long, Long> repositoryIdChanges = branchRepositories.stream().filter(br -> br.getParentId() != null).collect(Collectors.toMap(VcsRepositoryData::getParentId, BambooIdProvider::getId));
                if (!repositoryIdChanges.isEmpty()) {
                    for (TaskDefinition taskDefinition : ImmutableJobImpl.super.getBuildDefinition().getTaskDefinitions()) {
                        this.taskManager.updateRepositoryIdsInTask(taskDefinition, repositoryIdChanges);
                    }
                    this.taskManager.updateWorkingDirSelectors((ImmutableBuildable)ImmutableJobImpl.this, ImmutableJobImpl.super.getBuildDefinition(), repositoryIdChanges);
                }
            }
            return ImmutableJobImpl.super.getBuildDefinition();
        }
    }
}

