/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.executor.RetryingTaskExecutor;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.AbstractImmutablePlan;
import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.plan.cache.CacheLoadContextSupport;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutablePlanManager;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndicesImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.utils.collections.AlwaysInvalidatingCacheDecorator;
import com.atlassian.bamboo.utils.concurrent.BambooLocks;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.config.db.HibernateConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate5.HibernateSystemException;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionTemplate;

public class ImmutablePlanCacheServiceImpl
implements ImmutablePlanCacheService {
    private static final Logger log = Logger.getLogger(ImmutablePlanCacheServiceImpl.class);
    private static final Predicate<Exception> EXPECTED_RETRYABLE_EXCEPTIONS = e -> {
        boolean stageDeletedDuringLoad = e instanceof HibernateSystemException && ExceptionUtils.getRootCause((Throwable)e) instanceof IllegalStateException;
        boolean buildDefinitionDeleted = e instanceof BuildDefinitionManager.BuildDefinitionNotFoundException;
        boolean somethingDeleted = e instanceof HibernateObjectRetrievalFailureException;
        if (stageDeletedDuringLoad || buildDefinitionDeleted || somethingDeleted) {
            return true;
        }
        boolean rootCauseBuildDefinitionDeleted = ExceptionUtils.getRootCause((Throwable)e) instanceof BuildDefinitionManager.BuildDefinitionNotFoundException;
        boolean rootCauseTransactionException = ExceptionUtils.getRootCause((Throwable)e) instanceof TransactionException;
        return e instanceof UncheckedExecutionException && (rootCauseTransactionException || rootCauseBuildDefinitionDeleted);
    };
    static final int CACHE_UPDATE_CONCURRENCY_LEVEL = 8;
    private static final String CONCURRENCY_SYS_PROP = "atlassian.bamboo.plan.cache.loading.threads";
    private final Set<ImmutableChain> needsIndexing = ConcurrentHashMap.newKeySet();
    private final Set<PlanKey> plansScheduledForDeletion = ConcurrentHashMap.newKeySet();
    private final Set<Long> stagesScheduledForDeletion = ConcurrentHashMap.newKeySet();
    private static final ThreadLocal<Object> iSeeDeadPeople = new ThreadLocal();
    private final CacheLoader<PlanKey, ImmutableChain> loader = new CacheLoader<PlanKey, ImmutableChain>(){

        @NotNull
        public ImmutableChain load(PlanKey planKey) {
            if (!ImmutablePlanCacheServiceImpl.this.cacheEnabled) {
                String msg = String.format("Attempt to load plan %s while cache is disabled", planKey);
                log.warn((Object)msg);
                throw new PlanCacheDisabledException();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fetching " + planKey + " from db"));
            }
            Callable<ImmutableChain> getPlanByKey = () -> {
                try {
                    log.trace((Object)"CACHE_TRACE immutablePlanManager.getPlanByKey");
                    ImmutableChain immutableChain = ImmutablePlanCacheServiceImpl.this.immutablePlanManager.getPlanByKey(planKey);
                    return immutableChain;
                }
                finally {
                    log.trace((Object)"CACHE_TRACE /immutablePlanManager.getPlanByKey");
                }
            };
            Callable<ImmutableChain> getPlanByKeyInCacheLoadContext = () -> (ImmutableChain)CacheLoadContextSupport.load(ImmutablePlanCacheServiceImpl.this.transactionTemplate, ImmutablePlanCacheServiceImpl.this.sessionFactory, getPlanByKey);
            long loadStart = System.currentTimeMillis();
            ImmutableChain chain = RetryingTaskExecutor.retry("Retrieving " + planKey, 3, Duration.ofMillis(100L), getPlanByKeyInCacheLoadContext, EXPECTED_RETRYABLE_EXCEPTIONS);
            long elapsed = System.currentTimeMillis() - loadStart;
            log.debug((Object)("Plan " + planKey + " loaded in " + elapsed + "ms"));
            if (chain == null) {
                throw new PlanNotFoundForKeyException(planKey);
            }
            ImmutablePlanCacheServiceImpl.this.needsIndexing.add(chain);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Loading element %s to plan cache (%s), stats: %s", planKey, "OK", ImmutablePlanCacheServiceImpl.this.getCacheStats()));
            }
            return chain;
        }
    };
    private final RemovalListener<PlanKey, ImmutableChain> removalListener = notification -> {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Removing element %s from plan cache (%s), stats: %s", notification.getKey(), notification.getCause(), this.getCacheStats()));
        }
    };
    private final CacheLoader<PlanKey, Range<Integer>> buildNumberRangeLoader = new CacheLoader<PlanKey, Range<Integer>>(){

        @NotNull
        public Range<Integer> load(PlanKey planKey) {
            if (!ImmutablePlanCacheServiceImpl.this.cacheEnabled) {
                String msg = String.format("Attempt to load plan %s while cache is disabled", planKey);
                log.warn((Object)msg);
                throw new PlanCacheDisabledException();
            }
            Callable<Range> getBuildNumberRangeByKey = () -> {
                try {
                    log.trace((Object)"CACHE_TRACE immutablePlanManager.getBuildNumberRangeByKey");
                    Range range = ImmutablePlanCacheServiceImpl.this.buildResultsSummaryDao.findBuildResultsNumberRange(planKey);
                    return range;
                }
                finally {
                    log.trace((Object)"CACHE_TRACE /immutablePlanManager.getBuildNumberRangeByKey");
                }
            };
            Range buildNumberRange = CacheLoadContextSupport.load(ImmutablePlanCacheServiceImpl.this.transactionTemplate, ImmutablePlanCacheServiceImpl.this.sessionFactory, getBuildNumberRangeByKey);
            if (buildNumberRange == null) {
                throw new PlanNotFoundForKeyException(planKey);
            }
            return buildNumberRange;
        }
    };
    private final CacheBuilder<PlanKey, ImmutableChain> cacheBuilder = this.createCacheBuilder();
    private final LoadingCache<PlanKey, ImmutableChain> planKeyChainMap = AlwaysInvalidatingCacheDecorator.wrap((LoadingCache)this.cacheBuilder.build(this.loader));
    private final LoadingCache<Object, ReentrantReadWriteLock> hiddenPlans = BambooLocks.weakReentrantReadWriteLockFactory();
    private final LoadingCache<PlanKey, Range<Integer>> buildNumberRangeMap = AlwaysInvalidatingCacheDecorator.wrap((LoadingCache)CacheBuilder.newBuilder().concurrencyLevel(8).build(this.buildNumberRangeLoader));
    private volatile boolean cacheEnabled = false;
    private final ImmutablePlanManager immutablePlanManager;
    private final PlanDao planDao;
    @Inject
    private TransactionTemplate transactionTemplate;
    @Inject
    private SessionFactory sessionFactory;
    private final HibernateConfig hibernateConfig;
    private final CustomVariableContext customVariableContext;
    private final BuildResultsSummaryDao buildResultsSummaryDao;
    private final PlanCacheIndicesImpl indices;

    public ImmutablePlanCacheServiceImpl(@NotNull ImmutablePlanManager immutablePlanManager, @NotNull PlanDao planDao, @NotNull HibernateConfig hibernateConfig, @NotNull CustomVariableContext customVariableContext, @NotNull BuildResultsSummaryDao buildResultsSummaryDao, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        this.immutablePlanManager = immutablePlanManager;
        this.planDao = planDao;
        this.hibernateConfig = hibernateConfig;
        this.customVariableContext = customVariableContext;
        this.buildResultsSummaryDao = buildResultsSummaryDao;
        this.indices = new PlanCacheIndicesImpl(vcsRepositoryManager, this);
    }

    @PostConstruct
    private void postConstruct() {
        this.transactionTemplate = BambooSpringUtils.readOnly(BambooSpringUtils.requiresNew(this.transactionTemplate));
    }

    @Nullable
    public ImmutableChain getImmutablePlanByKey(@NotNull PlanKey planKey) {
        return this.internalGetPlanByKey(planKey, false);
    }

    @Nullable
    public ImmutableChain getImmutableChainByKeyIfInCache(@NotNull PlanKey planKey) {
        return this.internalGetPlanByKey(planKey, true);
    }

    public void invalidate(@NotNull PlanKey planKey) {
        if (this.plansScheduledForDeletion.contains(planKey)) {
            log.info((Object)("Skipping invalidation, plan is being deleted: " + planKey));
            return;
        }
        ImmutableChain maybeChain = (ImmutableChain)this.planKeyChainMap.getIfPresent((Object)planKey);
        if (maybeChain == null) {
            log.info((Object)("Invalidating, plan is not in cache or is being loaded: " + planKey));
            this.planKeyChainMap.invalidate((Object)planKey);
            return;
        }
        if (maybeChain.isMarkedForDeletion()) {
            log.info((Object)("Skipping invalidation, plan is marked for deletion: " + planKey));
            return;
        }
        log.info((Object)("Invalidating " + planKey));
        this.planKeyChainMap.invalidate((Object)planKey);
    }

    public void cascadeInvalidate(@NotNull PlanKey planKey) {
        this.indices.getPlanBranchCacheIndex().getBranchKeys(planKey).forEach(this::invalidate);
        this.invalidate(planKey);
    }

    public void getChainsToInvalidateAndReindex(ImmutablePlanCacheService.CacheInvalidator invalidator, Set<PlanKey> chainsToInvalidate, Set<PlanKey> chainsToReindex) {
        invalidator.getChainsToInvalidateAndReindex((ImmutablePlanCacheService)this, this.planKeyChainMap, chainsToInvalidate, chainsToReindex);
    }

    public void remove(@NotNull PlanKey planKey) {
        this.indices.deindex(planKey);
        this.planKeyChainMap.invalidate((Object)planKey);
        this.buildNumberRangeMap.invalidate((Object)planKey);
        this.plansScheduledForDeletion.remove(planKey);
        if (PlanKeys.isChainKey((PlanKey)planKey)) {
            this.plansScheduledForDeletion.removeIf(k -> PlanKeys.isJobKey((PlanKey)k) && planKey.equals((Object)PlanKeys.getChainKeyFromJobKey((PlanKey)k)));
        }
    }

    public void onStageDeleted(long stageId) {
        this.stagesScheduledForDeletion.remove(stageId);
    }

    void resetAll() {
        this.indices.deindexAll();
        this.planKeyChainMap.invalidateAll();
        this.buildNumberRangeMap.invalidateAll();
    }

    public void initialiseCache() {
        try {
            this.enterDeletionCodeSection();
            this.initialiseCacheInternal();
        }
        finally {
            this.leaveDeletionCodeSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseCacheInternal() {
        Stopwatch watch = Stopwatch.createStarted();
        log.info((Object)"Plan cache initialising...");
        if (!this.cacheEnabled) {
            this.enableCache();
        }
        this.resetAll();
        int concurrentThreads = this.loaderPoolSize();
        ListeningExecutorService executorService = SystemSecurityContextExecutors.newFixedThreadPool(concurrentThreads, "ImmutablePlanCacheServiceImpl.initialiseCache");
        try {
            AtomicInteger numberOfPlansInitialised = new AtomicInteger(0);
            List planKeys = this.planDao.getAllPlanKeys(AbstractChain.class);
            for (PlanKey planKey : planKeys) {
                executorService.submit(() -> {
                    int initCount;
                    ImmutableChain planByKey = this.getImmutablePlanByKey(planKey);
                    if (planByKey != null && planByKey.isMarkedForDeletion()) {
                        this.hideDeletedPlan(planByKey.getPlanKey());
                    }
                    if ((initCount = numberOfPlansInitialised.incrementAndGet()) % 100 == 0 || initCount == planKeys.size()) {
                        log.info((Object)(initCount + " of " + planKeys.size() + " plans initialised"));
                    }
                });
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Plan cache initialisation interrupted", (Throwable)e);
        }
        finally {
            executorService.shutdownNow();
        }
        log.info((Object)("Plan cache initialised in " + watch));
    }

    private int loaderPoolSize() {
        Integer fromSysProp = Integer.getInteger(CONCURRENCY_SYS_PROP);
        int poolSize = fromSysProp != null && fromSysProp > 0 ? fromSysProp : BambooHibernateUtils.getConcurrentPoolSize(this.hibernateConfig);
        log.info((Object)("Initialising plan cache with " + poolSize + " threads."));
        return poolSize;
    }

    public void disableCache() {
        this.cacheEnabled = false;
        this.resetAll();
        log.info((Object)"Plan cache is being disabled, all plans keys have been reset");
    }

    public void enableCache() {
        this.cacheEnabled = true;
        log.info((Object)"Plan cache is being enabled");
    }

    public BambooCacheStats getCacheStats() {
        return new BambooCacheStats(this.planKeyChainMap);
    }

    @NotNull
    public PlanCacheIndices getIndices() {
        return this.indices;
    }

    @NotNull
    public <T extends ImmutablePlan> Stream<T> getPlans(Class<T> planType, @NotNull com.google.common.base.Predicate<? super T> filter) {
        this.assertIsInCache(planType);
        return Narrow.streamDownTo(this.internalGetAllPlansStream(false), planType).filter(arg_0 -> filter.apply(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withHiddenPlans(Collection<PlanKey> planKeys, Supplier<T> supplier) {
        List<ReentrantReadWriteLock> orderedLocks = planKeys.stream().sorted().map(arg_0 -> this.hiddenPlans.getUnchecked(arg_0)).collect(Collectors.toList());
        orderedLocks.forEach(lock -> lock.writeLock().lock());
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            orderedLocks.forEach(lock -> lock.writeLock().unlock());
        }
    }

    @NotNull
    public Range<Integer> getBuildNumbersRange(PlanKey planKey) {
        return (Range)this.buildNumberRangeMap.getUnchecked((Object)planKey);
    }

    public void invalidateBuildNumbersRange(PlanKey planKey, int buildNumber, boolean trueForSaveFalseForDelete) {
        boolean rangeBoundaryWasDeleted;
        boolean newerBuildNumberWasSaved;
        Range existing = (Range)this.buildNumberRangeMap.getIfPresent((Object)planKey);
        if (existing == null) {
            return;
        }
        boolean bl = newerBuildNumberWasSaved = trueForSaveFalseForDelete && buildNumber > (Integer)existing.getMaximum();
        if (newerBuildNumberWasSaved) {
            this.buildNumberRangeMap.invalidate((Object)planKey);
            return;
        }
        boolean bl2 = rangeBoundaryWasDeleted = !trueForSaveFalseForDelete && (buildNumber == (Integer)existing.getMaximum() || buildNumber == (Integer)existing.getMinimum());
        if (rangeBoundaryWasDeleted) {
            this.buildNumberRangeMap.invalidate((Object)planKey);
        }
    }

    public Stream<ImmutablePlan> getPlans(Predicate<ImmutablePlan> predicate) {
        return this.internalGetAllPlansStream(false).filter(predicate);
    }

    public Optional<ImmutableChain> getAnyPlan(Predicate<? super ImmutableChain> predicate) {
        Optional<ImmutableChain> anyLoaded = this.internalGetAllChainsStream(true).filter(predicate).findAny();
        if (anyLoaded.isPresent()) {
            return anyLoaded;
        }
        return this.internalGetAllChainsStream(false).filter(predicate).findAny();
    }

    public void invalidateLatestResultSummary(PlanResultKey planResultKey) {
        PlanKey chainKey = ImmutablePlanCacheServiceImpl.getChainKey(planResultKey.getPlanKey());
        ImmutableChain chain = (ImmutableChain)this.planKeyChainMap.getIfPresent((Object)chainKey);
        if (chain == null) {
            return;
        }
        if (chain.getPlanKey().equals((Object)planResultKey.getPlanKey())) {
            ((AbstractImmutablePlan)chain).resetLatestResultsSummary(planResultKey.getBuildNumber());
        } else {
            chain.getAllJobs().stream().filter(job -> job.getPlanKey().equals((Object)planResultKey.getPlanKey())).findAny().ifPresent(job -> ((AbstractImmutablePlan)job).resetLatestResultsSummary(planResultKey.getBuildNumber()));
        }
    }

    public void invalidateAllLatestResultSummaries() {
        this.internalGetAllPlansStream(true).forEach(plan -> ((AbstractImmutablePlan)plan).resetLatestResultsSummary(Integer.MAX_VALUE));
    }

    @NotNull
    private static PlanKey getChainKey(@NotNull PlanKey planKey) {
        return (PlanKey)MoreObjects.firstNonNull((Object)PlanKeys.getChainKeyIfJobKey((PlanKey)planKey), (Object)planKey);
    }

    @Nullable
    private ImmutableChain internalGetPlanByKey(@NotNull PlanKey planKey, boolean onlyLoaded) {
        boolean threadIsAllowedToSeeDeletedPlans;
        boolean bl = threadIsAllowedToSeeDeletedPlans = iSeeDeadPeople.get() != null;
        if (!threadIsAllowedToSeeDeletedPlans && this.plansScheduledForDeletion.contains(planKey)) {
            log.debug((Object)("Plan " + planKey + " scheduled for deletion, hiding"));
            return null;
        }
        ReentrantReadWriteLock lock = (ReentrantReadWriteLock)this.hiddenPlans.getUnchecked((Object)planKey);
        if (lock.isWriteLockedByCurrentThread() || !lock.readLock().tryLock()) {
            log.info((Object)String.format("Attempt to load plan %s while it is locked, returning null", planKey));
            return null;
        }
        try {
            ImmutableChain planByKey;
            ImmutableChain immutableChain = planByKey = onlyLoaded ? (ImmutableChain)this.planKeyChainMap.getIfPresent((Object)planKey) : (ImmutableChain)this.planKeyChainMap.getUnchecked((Object)planKey);
            if (planByKey == null) {
                ImmutableChain immutableChain2 = null;
                return immutableChain2;
            }
            if (this.needsIndexing.remove(planByKey)) {
                this.indexPlan(planByKey);
            }
            if (!threadIsAllowedToSeeDeletedPlans && planByKey.isMarkedForDeletion()) {
                log.warn((Object)("Plan " + planKey + " scheduled for deletion but not hidden"));
                ImmutableChain immutableChain3 = null;
                return immutableChain3;
            }
            ImmutableChain immutableChain4 = planByKey;
            return immutableChain4;
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PlanNotFoundForKeyException) {
                log.debug((Object)"", cause);
                ImmutableChain immutableChain = null;
                return immutableChain;
            }
            if (cause instanceof PlanCacheDisabledException) {
                log.error((Object)"", cause);
                ImmutableChain immutableChain = null;
                return immutableChain;
            }
            throw (RuntimeException)cause;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public void indexPlan(@NotNull ImmutableChain plan) {
        if (this.plansScheduledForDeletion.contains(plan.getPlanKey())) {
            log.debug((Object)("Skipping indexing of plan " + plan.getPlanKey() + ", it is scheduled for deletion"));
            return;
        }
        this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)plan), () -> this.indices.index(plan));
    }

    public void hideDeletedPlan(PlanKey planKey) {
        this.plansScheduledForDeletion.add(planKey);
    }

    public void hideDeletedStage(Long stageId) {
        this.stagesScheduledForDeletion.add(stageId);
    }

    public boolean isPlanBeingDeleted(PlanKey planKey) {
        return this.plansScheduledForDeletion.contains(planKey);
    }

    public void enterDeletionCodeSection() {
        log.debug((Object)("Marking thread as deletion thread " + Thread.currentThread()));
        iSeeDeadPeople.set(true);
    }

    public void leaveDeletionCodeSection() {
        log.debug((Object)("Thread is no longer marked as a deletion thread " + Thread.currentThread()));
        iSeeDeadPeople.remove();
    }

    @NotNull
    public <T extends PlanIdentifier> Set<T> filterOutDeletedIfNeeded(@NotNull Set<T> jobs) {
        if (iSeeDeadPeople.get() != null) {
            return jobs;
        }
        return jobs.stream().filter(job -> !this.plansScheduledForDeletion.contains(job.getPlanKey())).collect(Collectors.toSet());
    }

    @NotNull
    public <T extends ImmutableChainStage> List<T> filterOutDeletedIfNeeded(@NotNull List<T> stages) {
        if (iSeeDeadPeople.get() != null) {
            return stages;
        }
        return stages.stream().filter(s -> !(s.getDatabaseId().isPresent() && this.stagesScheduledForDeletion.contains(s.getId()) || s.hasMaster() && this.stagesScheduledForDeletion.contains(s.getMaster().getId()))).collect(Collectors.toList());
    }

    private Stream<ImmutablePlan> internalGetAllPlansStream(boolean onlyLoaded) {
        return this.internalGetAllChainsStream(onlyLoaded).flatMap(chain -> Stream.concat(Stream.of(chain), chain.getAllJobs().stream()));
    }

    private Stream<ImmutableChain> internalGetAllChainsStream(boolean onlyLoaded) {
        return this.indices.getPlanIdIndexer().getAllChainKeys().stream().map(planKey -> this.internalGetPlanByKey((PlanKey)planKey, onlyLoaded)).filter(Objects::nonNull);
    }

    private <T extends ImmutablePlan> void assertIsInCache(Class<T> planType) {
        if (Plan.class.isAssignableFrom(planType)) {
            throw new IllegalArgumentException("You can't retrieve plans of type " + planType.getSimpleName() + " from the cache. You have to use the Immutable version");
        }
    }

    @VisibleForTesting
    CacheBuilder<PlanKey, ImmutableChain> createCacheBuilder() {
        int concurrencyLevel = Integer.getInteger(CONCURRENCY_SYS_PROP, 8);
        return CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).removalListener(this.removalListener);
    }

    private static final class PlanCacheDisabledException
    extends IllegalStateException {
        private PlanCacheDisabledException() {
            super("Plan cache is disabled");
        }
    }

    private static final class PlanNotFoundForKeyException
    extends IllegalArgumentException {
        private PlanNotFoundForKeyException(PlanKey planKey) {
            super(planKey.toString());
        }
    }
}

