/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainFilteredTestResults;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStageImpl;
import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.plan.AbstractPlan;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.artifact.ImmutableArtifactManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.cache.ImmutableChainBranchImpl;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ChainResultDetails;
import com.atlassian.bamboo.plan.cache.ChainResultDetailsImpl;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainImpl;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutableJobImpl;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutablePlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableResultsSummaryImpl;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class ImmutablePlanManagerImpl
implements ImmutablePlanManager {
    private static final Logger log = Logger.getLogger(ImmutablePlanManagerImpl.class);
    private final UnrestrictedPlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;
    private final BuildLoggerManager buildLoggerManager;
    private final BuildDefinitionManager buildDefinitionManager;
    private final LabelManager labelManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final TaskManager taskManager;
    private final TriggerManager triggerManager;
    private final VariableDefinitionManager variableDefinitionManager;
    private final Supplier<ImmutableArtifactManager> immutableArtifactManager = ComponentAccessor.IMMUTABLE_ARTIFACT_MANAGER;
    private final Supplier<ImmutablePlanManager> immutablePlanManager = ComponentAccessor.IMMUTABLE_PLAN_MANAGER;
    private final Supplier<CachedPlanManager> cachedPlanManager = ComponentAccessor.CACHED_PLAN_MANAGER;
    private final Supplier<ImmutablePlanCacheService> immutablePlanCacheServiceSupplier = ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE;
    @Lazy
    @Inject
    private TestsManager testsManager;
    @Lazy
    @Inject
    private TestQuarantineManager testQuarantineManager;
    @Lazy
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;

    public ImmutablePlanManagerImpl(PlanManager planManager, ResultsSummaryManager resultsSummaryManager, BuildDefinitionManager buildDefinitionManager, BuildLoggerManager buildLoggerManager, LabelManager labelManager, RepositoryDefinitionManager repositoryDefinitionManager, TaskManager taskManager, TriggerManager triggerManager, VariableDefinitionManager variableDefinitionManager) {
        this.buildDefinitionManager = buildDefinitionManager;
        this.planManager = new UnrestrictedPlanManager(planManager);
        this.resultsSummaryManager = resultsSummaryManager;
        this.buildLoggerManager = buildLoggerManager;
        this.labelManager = labelManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.taskManager = taskManager;
        this.triggerManager = triggerManager;
        this.variableDefinitionManager = variableDefinitionManager;
    }

    @Nullable
    public ImmutableChain getPlanByKey(@NotNull PlanKey planKey) {
        AbstractPlan abstractImmutablePlan;
        log.trace((Object)"CACHE_TRACE getPlanByKey");
        Chain chain = this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
        if (chain == null) {
            return null;
        }
        if (chain.isMarkedForDeletion()) {
            log.warn((Object)("Loading plan marked for deletion into cache: " + chain.getPlanKey()));
        }
        if ((abstractImmutablePlan = (AbstractPlan)Narrow.reinterpret((Object)chain, AbstractPlan.class)) != null) {
            abstractImmutablePlan.setBuildDefinitionManager(this.buildDefinitionManager);
        }
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((Plan)chain);
        log.trace((Object)("CACHE_TRACE createImmutableChain " + chain.getPlanKey()));
        ImmutableChain immutableChain = this.createImmutableChain(chain, buildDefinition);
        log.trace((Object)"CACHE_TRACE /createImmutableChain");
        log.trace((Object)"CACHE_TRACE /getPlanByKey");
        return immutableChain;
    }

    @Nullable
    public ImmutableResultsSummary getLatestResultForPlan(PlanKey planKey) {
        ChainResultsSummary lastResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getLastResultsSummary(planKey.getKey(), ChainResultsSummary.class);
        if (lastResultsSummary == null) {
            return null;
        }
        return this.createImmutableResultSummary(lastResultsSummary);
    }

    public ChainResultDetails getChainResultDetails(PlanResultKey planResultKey) {
        String profilingMessage = "Fetching details for " + planResultKey;
        try (Ticker ticker = Timers.start((String)profilingMessage);){
            ChainResultsSummary summary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(planResultKey, ChainResultsSummary.class);
            ChainFilteredTestResults chainFilteredTestResults = ChainFilteredTestResults.newInstance(this.testsManager, this.testQuarantineManager, summary, 0, 0);
            ChainResultDetailsImpl chainResultDetailsImpl = new ChainResultDetailsImpl(summary, chainFilteredTestResults);
            return chainResultDetailsImpl;
        }
    }

    @NotNull
    public ImmutableChain createImmutableChain(@NotNull Chain chain) {
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((Plan)chain);
        return this.createImmutableChain(chain, buildDefinition);
    }

    @NotNull
    public ImmutableJob createImmutableJob(@NotNull ImmutableChain parent, @NotNull ImmutableChainStage stage, @NotNull Job job) {
        log.trace((Object)"CACHE_TRACE createImmutableJob");
        BuildDefinition buildDefinition = this.buildDefinitionManager.getBuildDefinition((Plan)job);
        log.trace((Object)"CACHE_TRACE createImmutableJob got builddef");
        return this.createImmutableJob(parent, stage, job, buildDefinition);
    }

    @NotNull
    private ImmutableChain createImmutableChain(@NotNull Chain chain, @NotNull BuildDefinition buildDefinition) {
        ChainBranch chainBranch = (ChainBranch)Narrow.downTo((Object)chain, ChainBranch.class);
        if (chainBranch != null) {
            Objects.requireNonNull(chainBranch.getMaster(), "Chain branch " + chain.getPlanKey() + " has no master.");
            return new ImmutableChainBranchImpl(chainBranch, this.buildLoggerManager, (ImmutablePlanCacheService)this.immutablePlanCacheServiceSupplier.get(), (ImmutablePlanManager)this.immutablePlanManager.get(), this.labelManager, this.resultsSummaryManager, this.repositoryDefinitionManager, this.cachedRepositoryDefinitionManager, this.variableDefinitionManager, buildDefinition);
        }
        return new ImmutableChainImpl(chain, this.buildLoggerManager, (ImmutablePlanCacheService)this.immutablePlanCacheServiceSupplier.get(), (ImmutablePlanManager)this.immutablePlanManager.get(), this.labelManager, this.resultsSummaryManager, this.repositoryDefinitionManager, this.cachedRepositoryDefinitionManager, this.variableDefinitionManager, buildDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ImmutableJob createImmutableJob(@NotNull ImmutableChain parent, @NotNull ImmutableChainStage stage, @NotNull Job job, @NotNull BuildDefinition buildDefinition) {
        try {
            log.trace((Object)"CACHE_TRACE priv createImmutableJob");
            ImmutableJobImpl immutableJobImpl = new ImmutableJobImpl(parent, stage, job, this.buildLoggerManager, this.labelManager, this.variableDefinitionManager, this.taskManager, this.resultsSummaryManager, buildDefinition, (CachedPlanManager)this.cachedPlanManager.get(), (ImmutableArtifactManager)this.immutableArtifactManager.get());
            return immutableJobImpl;
        }
        finally {
            log.trace((Object)"CACHE_TRACE priv /createImmutableJob");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableChainStage createImmutableStage(@NotNull ImmutableChain parent, @NotNull ChainStage stage) {
        log.trace((Object)"CACHE_TRACE creating immutable stage");
        try {
            ImmutableChainStageImpl immutableChainStageImpl = new ImmutableChainStageImpl(parent, stage, (ImmutablePlanManager)this.immutablePlanManager.get(), (ImmutablePlanCacheService)this.immutablePlanCacheServiceSupplier.get());
            return immutableChainStageImpl;
        }
        finally {
            log.trace((Object)"CACHE_TRACE /creating immutable stage");
        }
    }

    private ImmutableResultsSummary createImmutableResultSummary(ChainResultsSummary summary) {
        return new ImmutableResultsSummaryImpl(summary, this.triggerManager, (ImmutablePlanManager)this.immutablePlanManager.get(), (CachedPlanManager)this.cachedPlanManager.get());
    }

    private static class UnrestrictedPlanManager {
        private final PlanManager planManager;

        public UnrestrictedPlanManager(PlanManager planManager) {
            this.planManager = planManager;
        }

        public List<TopLevelPlan> getAllPlans() {
            return this.planManager.getAllPlansUnrestricted();
        }

        @Nullable
        public <T extends Plan> T getPlanByKey(PlanKey planKey, Class<T> planType) {
            return (T)this.planManager.getPlanByKey(planKey, planType);
        }

        @Nullable
        public <T extends Plan> T getPlanByKeyIfOfType(@NotNull PlanKey planKey, @NotNull Class<T> planType) {
            return (T)this.planManager.getPlanByKeyIfOfType(planKey, planType);
        }
    }
}

