/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.chains.branches.MergeResultSummaryImpl;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ChainResultDetails;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanManager;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.BaseResultSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultDescriptor;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableContextSnapshot;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImmutableResultsSummaryImpl
extends BaseResultSummary
implements ImmutableChainResultsSummary {
    private static final Logger log = Logger.getLogger(ImmutableResultsSummaryImpl.class);
    private final String reasonSummary;
    private final String changesListSummary;
    private final TestResultsSummary testResultsSummary;
    private final long duration;
    private final long processingDuration;
    private final PlanKey planKey;
    private final String planName;
    private final int buildNumber;
    private final Date queueTime;
    private final Date buildDate;
    private final Date buildCancelledDate;
    private final Date buildCompletedDate;
    private final DeltaState deltaState;
    private final Set<LinkedJiraIssue> jiraIssues;
    private final Map<String, String> customBuildData;
    private final List<Labelling> labellings;
    private final List<ArtifactLink> artifactLinks;
    private final Long timeToFix;
    private final Long buildAgentId;
    private final List<RepositoryChangeset> repositoryChangesets;
    private final List<ConsumedSubscription> subscriptions;
    private final List<VariableSubstitution> substitutedVariables;
    private final List<VariableContextSnapshot> variableContextLogs;
    private final TriggerReason triggerReason;
    private final BuildState buildState;
    private final LifeCycleState lifeCycleState;
    private final int restartCount;
    private final boolean notRunYet;
    private final boolean continuable;
    private final boolean restartable;
    private final boolean onceOff;
    private final boolean customBuild;
    private final boolean rebuild;
    private final Long logSize;
    private final MergeResultSummary mergeResultSummary;
    private final Integer fixedInResult;
    private final TriggerManager triggerManager;
    private final ImmutablePlanManager immutablePlanManager;
    private final CachedPlanManager cachedPlanManager;
    private ImmutableList<VariableBaselineItem> variableContext;
    private final LazyReference<ChainResultDetails> chainResultDetailsReference = new LazyReference<ChainResultDetails>(){

        protected ChainResultDetails create() throws Exception {
            return ImmutableResultsSummaryImpl.this.immutablePlanManager.getChainResultDetails(ImmutableResultsSummaryImpl.this.getPlanResultKey());
        }
    };
    private final LazyReference<Optional<ImmutableChain>> planRef = new LazyReference<Optional<ImmutableChain>>(){

        protected Optional<ImmutableChain> create() throws Exception {
            ImmutableChain chain = (ImmutableChain)ImmutableResultsSummaryImpl.this.cachedPlanManager.getPlanByKey(ImmutableResultsSummaryImpl.this.getPlanKey(), ImmutableChain.class);
            return Optional.ofNullable(chain);
        }
    };

    public ImmutableResultsSummaryImpl(ChainResultsSummary summary, TriggerManager triggerManager, ImmutablePlanManager immutablePlanManager, CachedPlanManager cachedPlanManager) {
        this.triggerManager = triggerManager;
        this.immutablePlanManager = immutablePlanManager;
        this.cachedPlanManager = cachedPlanManager;
        this.reasonSummary = summary.getReasonSummary();
        this.changesListSummary = summary.getChangesListSummary();
        this.testResultsSummary = summary.getTestResultsSummary();
        this.duration = summary.getDuration();
        this.processingDuration = summary.getProcessingDuration();
        this.planKey = summary.getPlanKey();
        this.planName = summary.getPlanName();
        this.buildNumber = summary.getBuildNumber();
        this.queueTime = summary.getQueueTime();
        this.buildDate = summary.getBuildDate();
        this.buildCancelledDate = summary.getBuildCancelledDate();
        this.buildCompletedDate = summary.getBuildCompletedDate();
        this.deltaState = summary.getDeltaState();
        this.timeToFix = summary.getTimeToFix();
        this.buildAgentId = summary.getBuildAgentId();
        this.triggerReason = summary.getTriggerReason();
        this.buildState = summary.getBuildState();
        this.lifeCycleState = summary.getLifeCycleState();
        this.restartCount = summary.getRestartCount();
        this.notRunYet = summary.isNotRunYet();
        this.jiraIssues = ImmutableSet.copyOf((Collection)summary.getJiraIssues());
        this.customBuildData = ImmutableMap.copyOf((Map)summary.getCustomBuildData());
        this.labellings = ImmutableList.copyOf((Collection)summary.getLabellings());
        this.artifactLinks = ImmutableList.copyOf((Collection)summary.getArtifactLinks());
        this.repositoryChangesets = ImmutableList.copyOf((Collection)summary.getRepositoryChangesets());
        this.subscriptions = ImmutableList.copyOf((Collection)summary.getSubscriptions());
        this.substitutedVariables = ImmutableList.copyOf((Collection)summary.getSubstitutedVariables());
        this.variableContextLogs = ImmutableList.copyOf((Collection)summary.getVariableContextLogs());
        this.continuable = summary.isContinuable();
        this.restartable = summary.isRestartable();
        this.onceOff = summary.isOnceOff();
        this.customBuild = summary.isCustomBuild();
        this.rebuild = summary.isRebuild();
        this.logSize = summary.getLogSize();
        this.mergeResultSummary = summary.getMergeResult() == null ? null : new MergeResultSummaryImpl(summary.getMergeResult());
        this.variableContext = summary.getVariableContext();
        this.fixedInResult = summary.getFixedInResult();
    }

    @NotNull
    public List<ChainStageResult> getStageResults() {
        return ((ChainResultDetails)this.chainResultDetailsReference.get()).getStageResults();
    }

    public FilteredTestResults<TestClassResultDescriptor> getTestResults() {
        return ((ChainResultDetails)this.chainResultDetailsReference.get()).getTestResults();
    }

    @NotNull
    public List<BuildResultsSummary> getFailedJobResults() {
        return ((ChainResultDetails)this.chainResultDetailsReference.get()).getFailedJobResults();
    }

    public int getTotalJobCount() {
        return ((ChainResultDetails)this.chainResultDetailsReference.get()).getTotalJobCount();
    }

    @NotNull
    public List<ResultsSummary> getOrderedJobResultSummaries() {
        return ((ChainResultDetails)this.chainResultDetailsReference.get()).getOrderedJobResultSummaries();
    }

    public boolean isContinuable() {
        return this.continuable;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isOnceOff() {
        return this.onceOff;
    }

    public boolean isCustomBuild() {
        return this.customBuild;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    @Nullable
    public Long getLogSize() {
        return this.logSize;
    }

    @NotNull
    public ImmutableChain getImmutablePlan() {
        return (ImmutableChain)((Optional)this.planRef.get()).orElseThrow(() -> new IllegalStateException("Unable to find Plan for " + this.getPlanResultKey()));
    }

    @NotNull
    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)((Optional)this.planRef.get()).orElseThrow(() -> new IllegalStateException("Unable to find chain for " + this.getPlanResultKey()));
    }

    @NotNull
    public Optional<ImmutableChain> getPlanIfExists() {
        return (Optional)this.planRef.get();
    }

    public boolean isNotRunYet() {
        return this.notRunYet;
    }

    public boolean isMarkedForDeletion() {
        return false;
    }

    @NotNull
    public List<ArtifactLink> getArtifactLinks() {
        return this.artifactLinks;
    }

    public Date getBuildCancelledDate() {
        return this.buildCancelledDate;
    }

    public Date getBuildCompletedDate() {
        return this.buildCompletedDate;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    @NotNull
    public String getChangesListSummary() {
        return this.changesListSummary;
    }

    @NotNull
    public Map<String, String> getCustomBuildData() {
        return this.customBuildData;
    }

    public DeltaState getDeltaState() {
        return this.deltaState;
    }

    public long getDuration() {
        return this.duration;
    }

    @NotNull
    public Set<LinkedJiraIssue> getJiraIssues() {
        return this.jiraIssues;
    }

    public List<Labelling> getLabellings() {
        return this.labellings;
    }

    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public String getFullPlanName() {
        return this.getPlanName();
    }

    @NotNull
    public String getPlanName() {
        return this.planName;
    }

    public long getProcessingDuration() {
        return this.processingDuration;
    }

    public Date getQueueTime() {
        return this.queueTime;
    }

    public String getReasonSummary() {
        return this.reasonSummary;
    }

    @NotNull
    public List<RepositoryChangeset> getRepositoryChangesets() {
        return this.repositoryChangesets;
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    @NotNull
    public List<ConsumedSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    @NotNull
    public List<VariableSubstitution> getSubstitutedVariables() {
        return this.substitutedVariables;
    }

    @NotNull
    public TestResultsSummary getTestResultsSummary() {
        return this.testResultsSummary;
    }

    public Long getTimeToFix() {
        return this.timeToFix;
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        return this.triggerReason;
    }

    @NotNull
    public List<VariableContextSnapshot> getVariableContextLogs() {
        return this.variableContextLogs;
    }

    @NotNull
    public ImmutableList<VariableBaselineItem> getVariableContext() {
        return this.variableContext;
    }

    @Override
    protected TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    public MergeResultSummary getMergeResult() {
        return this.mergeResultSummary;
    }

    @Nullable
    public Integer getFixedInResult() {
        return this.fixedInResult;
    }

    public Long getBuildAgentId() {
        return this.buildAgentId;
    }
}

