/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@Immutable
@ThreadSafe
public class PlansState {
    private final ImmutableMap<PlanKey, ImmutableChain> chainCache;

    public PlansState() {
        this.chainCache = ImmutableMap.of();
    }

    public PlansState(Iterable<? extends ImmutableChain> chainCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ImmutableChain immutableChain : chainCache) {
            if (immutableChain == null) continue;
            builder.put((Object)immutableChain.getPlanKey(), (Object)immutableChain);
        }
        this.chainCache = builder.build();
    }

    private PlansState(ImmutableMap<PlanKey, ImmutableChain> chainCache) {
        this.chainCache = chainCache;
    }

    private PlansState(Map<PlanKey, ImmutableChain> map) {
        this.chainCache = ImmutableMap.copyOf(map);
    }

    public ImmutableChain getPlan(@NotNull PlanKey planKey) {
        return (ImmutableChain)this.chainCache.get((Object)planKey);
    }

    @NotNull
    public List<ImmutableTopLevelPlan> getAllTopLevelPlans() {
        return Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering().sortedCopy(Narrow.iterableTo((Iterable)this.chainCache.values(), ImmutableTopLevelPlan.class));
    }

    public ImmutableCollection<ImmutableChain> getUnsortedPlans() {
        return this.chainCache.values();
    }

    public List<ImmutableChain> getAllChains() {
        return Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)this.chainCache.values());
    }

    public PlansState updateState(@NotNull ImmutableChain plan) {
        return this.updateState((Map<PlanKey, ? extends ImmutableChain>)ImmutableMap.of((Object)plan.getPlanKey(), (Object)plan));
    }

    public PlansState updateState(@NotNull Map<PlanKey, ? extends ImmutableChain> plansMap) {
        HashMap<PlanKey, ImmutableChain> builder = new HashMap<PlanKey, ImmutableChain>();
        builder.putAll((Map<PlanKey, ImmutableChain>)this.chainCache);
        builder.putAll(plansMap);
        return new PlansState(builder);
    }

    public PlansState removePlanFromState(@NotNull PlanKey planKey) {
        return new PlansState(Maps.filterKeys(this.chainCache, input -> !planKey.equals(input)));
    }

    public PlansState removePlansFromState(@NotNull Iterable<PlanKey> planKeys) {
        HashSet setOfKeys = Sets.newHashSet(planKeys);
        return new PlansState(Maps.filterKeys(this.chainCache, input -> !setOfKeys.contains(input)));
    }
}

