/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache.index;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.PlanBranchGist;
import com.atlassian.bamboo.plan.cache.index.PlanBranchCacheIndex;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndexer;
import com.atlassian.collectors.CollectorsUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.jetbrains.annotations.NotNull;

public class PlanBranchCacheIndexer
implements PlanCacheIndexer,
PlanBranchCacheIndex {
    private final Multimap<PlanKey, PlanBranchGist> masterToBranchMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final ImmutablePlanCacheService immutablePlanCacheService;

    public PlanBranchCacheIndexer(ImmutablePlanCacheService immutablePlanCacheService) {
        this.immutablePlanCacheService = immutablePlanCacheService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(@NotNull ImmutableChain chain) {
        ImmutableChain master = chain.getMaster();
        if (master != null) {
            Multimap<PlanKey, PlanBranchGist> multimap = this.masterToBranchMapping;
            synchronized (multimap) {
                this.masterToBranchMapping.values().removeIf(g -> g.getKey().equals((Object)chain.getPlanKey()));
                this.masterToBranchMapping.put((Object)master.getPlanKey(), (Object)new PlanBranchGist(chain.getPlanKey(), chain.getBuildName(), chain.isSuspendedFromBuilding(), chain.getBuildDefinition().getBranchSpecificConfiguration().getPlanBranchWorkflow()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deindex(@NotNull PlanKey planKey) {
        Multimap<PlanKey, PlanBranchGist> multimap = this.masterToBranchMapping;
        synchronized (multimap) {
            this.masterToBranchMapping.values().removeIf(g -> g.getKey().equals((Object)planKey));
        }
        this.masterToBranchMapping.removeAll((Object)planKey);
    }

    public void deindexAll() {
        this.masterToBranchMapping.clear();
    }

    @NotNull
    public ImmutableSet<PlanKey> getBranchKeys(@NotNull PlanKey planKey) {
        return (ImmutableSet)this.getBranchGists(planKey).stream().map(PlanBranchGist::getKey).collect(CollectorsUtil.toImmutableSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableSet<PlanBranchGist> getBranchGists(PlanKey planKey) {
        Multimap<PlanKey, PlanBranchGist> multimap = this.masterToBranchMapping;
        synchronized (multimap) {
            return (ImmutableSet)this.masterToBranchMapping.get((Object)planKey).stream().filter(g -> !this.immutablePlanCacheService.isPlanBeingDeleted(g.getKey())).collect(CollectorsUtil.toImmutableSet());
        }
    }
}

