/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache.index;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.index.PlanBranchCacheIndexer;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndexer;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.plan.cache.index.PlanIdCacheIndexer;
import com.atlassian.bamboo.plan.cache.index.PlanRepositoryIndexer;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlanCacheIndicesImpl
implements PlanCacheIndexer,
PlanCacheIndices {
    private final PlanIdCacheIndexer planIdIndexer = new PlanIdCacheIndexer();
    private final PlanBranchCacheIndexer planBranchCacheIndexer;
    private final PlanRepositoryIndexer planRepositoryIndexer;
    private final List<PlanCacheIndexer> planIndexers;

    public PlanCacheIndicesImpl(VcsRepositoryManager vcsRepositoryManager, ImmutablePlanCacheService immutablePlanCacheService) {
        this.planRepositoryIndexer = new PlanRepositoryIndexer(vcsRepositoryManager);
        this.planBranchCacheIndexer = new PlanBranchCacheIndexer(immutablePlanCacheService);
        this.planIndexers = Arrays.asList(this.planIdIndexer, this.planBranchCacheIndexer, this.planRepositoryIndexer);
    }

    public void index(@NotNull ImmutableChain plan) {
        this.planIndexers.forEach(indexer -> indexer.index(plan));
    }

    public void deindex(@NotNull PlanKey planKey) {
        this.planIndexers.forEach(indexer -> indexer.deindex(planKey));
    }

    public void deindexAll() {
        this.planIndexers.forEach(PlanCacheIndexer::deindexAll);
    }

    @NotNull
    public PlanBranchCacheIndexer getPlanBranchCacheIndex() {
        return this.planBranchCacheIndexer;
    }

    @NotNull
    public PlanIdCacheIndexer getPlanIdIndexer() {
        return this.planIdIndexer;
    }

    @NotNull
    public PlanRepositoryIndexer getPlanRepositoryIndex() {
        return this.planRepositoryIndexer;
    }
}

