/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache.index;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndexer;
import com.atlassian.bamboo.plan.cache.index.PlanIdCacheIndex;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class PlanIdCacheIndexer
implements PlanCacheIndexer,
PlanIdCacheIndex {
    private final Map<Long, PlanKey> chainIdToPlanKeyMapping = new ConcurrentHashMap<Long, PlanKey>();
    private final Map<PlanKey, Long> planKeyToIdMapping = new ConcurrentHashMap<PlanKey, Long>();
    private final Map<Long, PlanKey> jobIdToChainKey = new ConcurrentHashMap<Long, PlanKey>();

    public void index(@NotNull ImmutableChain chain) {
        PlanKey chainKey = chain.getPlanKey();
        this.chainIdToPlanKeyMapping.put(chain.getId(), chainKey);
        this.planKeyToIdMapping.put(chainKey, chain.getId());
        for (ImmutableJob job : chain.getAllJobs()) {
            if (!job.getDatabaseId().isPresent()) continue;
            this.jobIdToChainKey.put(job.getId(), chainKey);
        }
    }

    public void deindex(@NotNull PlanKey planKey) {
        Long chainId = this.planKeyToIdMapping.remove(planKey);
        if (chainId != null) {
            this.chainIdToPlanKeyMapping.remove(chainId);
        }
        this.jobIdToChainKey.values().removeAll(Collections.singletonList(planKey));
    }

    public void deindexAll() {
        this.chainIdToPlanKeyMapping.clear();
        this.planKeyToIdMapping.clear();
        this.jobIdToChainKey.clear();
    }

    public Set<PlanKey> getAllChainKeys() {
        return this.planKeyToIdMapping.keySet();
    }

    public PlanKey getChain(long chainId) {
        return this.chainIdToPlanKeyMapping.get(chainId);
    }

    public PlanKey getChainOfJob(long jobId) {
        return this.jobIdToChainKey.get(jobId);
    }
}

