/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache.index;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndexer;
import com.atlassian.bamboo.plan.cache.index.PlanRepositoryIndex;
import com.atlassian.bamboo.repository.ReflectionRepositoryAccessor;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanRepositoryIndexer
implements PlanCacheIndexer,
PlanRepositoryIndex {
    private final Multimap<String, PlanKey> urlToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<String, PlanKey> branchToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<String, PlanKey> repositoryBranchToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<String, PlanKey> applicationLinkIdToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<String, PlanKey> repositoryNamespaceToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<String, PlanKey> repositorySlugToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<Long, PlanKey> repositoryIdToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<Long, PlanKey> rootRepoIdToChainMapping = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final List<Multimap<?, PlanKey>> caches = Arrays.asList(this.urlToChainMapping, this.branchToChainMapping, this.repositoryBranchToChainMapping, this.applicationLinkIdToChainMapping, this.repositoryNamespaceToChainMapping, this.repositorySlugToChainMapping, this.repositoryIdToChainMapping, this.rootRepoIdToChainMapping);
    private final VcsRepositoryManager vcsRepositoryManager;

    public PlanRepositoryIndexer(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void index(@NotNull ImmutableChain chain) {
        PlanKey chainKey = chain.getPlanKey();
        this.deindex(chainKey);
        chain.getPlanRepositoryDefinitions().forEach(repositoryData -> this.index(chainKey, (VcsRepositoryData)repositoryData));
    }

    private void index(PlanKey chainKey, VcsRepositoryData repositoryData) {
        String repositorySlug;
        String applicationLinkId;
        this.repositoryIdToChainMapping.put((Object)repositoryData.getId(), (Object)chainKey);
        this.rootRepoIdToChainMapping.put((Object)repositoryData.getRootVcsRepositoryId(), (Object)chainKey);
        String url = this.getRepositoryUrl(repositoryData);
        this.urlToChainMapping.put((Object)url, (Object)chainKey);
        VcsBranchDefinition branchDefinition = repositoryData.getBranch();
        if (branchDefinition != null) {
            this.branchToChainMapping.put((Object)branchDefinition.getVcsBranch().getName(), (Object)chainKey);
            this.repositoryBranchToChainMapping.put((Object)this.getRepoBranchKey(repositoryData.getRootVcsRepositoryId(), branchDefinition.getVcsBranch().getName()), (Object)chainKey);
        }
        if ((applicationLinkId = this.getApplicationLinkId(repositoryData)) != null) {
            this.applicationLinkIdToChainMapping.put((Object)applicationLinkId, (Object)chainKey);
        }
        if ((repositorySlug = this.getRepositorySlug(repositoryData)) != null) {
            this.repositorySlugToChainMapping.put((Object)repositorySlug, (Object)chainKey);
        }
        this.getRepositoryNamespace(repositoryData).ifPresent(s -> this.repositoryNamespaceToChainMapping.put(s, (Object)chainKey));
    }

    @NotNull
    private String getRepoBranchKey(long rootRepositoryId, String branchName) {
        return rootRepositoryId + "-" + branchName;
    }

    @Nullable
    private String getApplicationLinkId(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            boolean isBbServer = ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData.asLegacyData().getRepository());
            Preconditions.checkArgument((!isBbServer ? 1 : 0) != 0, (Object)"Legacy Bitbucket Server repository found, this should not happen");
            return null;
        }
        if (ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData)) {
            return ReflectionRepositoryAccessor.StashRepositoryAccessor.getApplicationLinkId(repositoryData.getVcsLocation());
        }
        return null;
    }

    @Nullable
    private String getRepositorySlug(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            boolean isBbServer = ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData.asLegacyData().getRepository());
            Preconditions.checkArgument((!isBbServer ? 1 : 0) != 0, (Object)"Legacy Bitbucket Server repository found, this should not happen");
            return null;
        }
        if (ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData)) {
            return ReflectionRepositoryAccessor.StashRepositoryAccessor.getStashRepositorySlug(repositoryData.getVcsLocation());
        }
        return null;
    }

    @NotNull
    private Optional<String> getRepositoryNamespace(VcsRepositoryData repositoryData) {
        if (repositoryData.isLegacyRepository()) {
            boolean isBbServer = ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData.asLegacyData().getRepository());
            Preconditions.checkArgument((!isBbServer ? 1 : 0) != 0, (Object)"Legacy Bitbucket Server repository found, this should not happen");
            return Optional.empty();
        }
        if (ReflectionRepositoryAccessor.StashRepositoryAccessor.isStashRepository(repositoryData)) {
            return Optional.ofNullable(ReflectionRepositoryAccessor.StashRepositoryAccessor.getStashProjectKey(repositoryData.getVcsLocation()));
        }
        return Optional.empty();
    }

    private String getRepositoryUrl(VcsRepositoryData vcsRepositoryData) {
        if (vcsRepositoryData.isLegacyRepository()) {
            return this.getRepositoryUrlLegacy(vcsRepositoryData.asLegacyData().getRepository());
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
        if (moduleDescriptor != null) {
            return moduleDescriptor.getVcsLocationConfigurator().getLocationIdentifier(vcsRepositoryData.getVcsLocation());
        }
        return "Repository location information not supplied by plugin";
    }

    private String getRepositoryUrlLegacy(Repository repository) {
        return repository.getLocationIdentifier();
    }

    public void deindex(@NotNull PlanKey planKey) {
        Set<PlanKey> planKeys = Collections.singleton(planKey);
        this.caches.forEach(cache -> cache.values().removeAll(planKeys));
    }

    public void deindexAll() {
        this.caches.forEach(Multimap::clear);
    }

    @NotNull
    public Collection<PlanKey> getPlans(@NotNull PlanRepositoryIndex.Query query) {
        Set<PlanKey> result = this.calculateResultEquals(this.urlToChainMapping, query.url, null);
        result = this.calculateResultEquals(this.applicationLinkIdToChainMapping, query.applicationLinkId, result);
        result = query.rootRepoId != null && StringUtils.isNotEmpty((CharSequence)query.branch) ? this.calculateResultEquals(this.repositoryBranchToChainMapping, this.getRepoBranchKey(query.rootRepoId, query.branch), result) : this.calculateResultEquals(this.branchToChainMapping, query.branch, result);
        result = this.calculateResultSmartContains(this.branchToChainMapping, query.branchContains, result);
        result = this.calculateResultEquals(this.repositoryNamespaceToChainMapping, query.repositoryNamespace, result);
        result = this.calculateResultEquals(this.repositorySlugToChainMapping, query.repositorySlug, result);
        result = this.calculateResultEquals(this.repositoryIdToChainMapping, query.repositoryId, result);
        result = this.calculateResultEquals(this.rootRepoIdToChainMapping, query.rootRepoId, result);
        return (Collection)MoreObjects.firstNonNull(result, Collections.emptySet());
    }

    @VisibleForTesting
    @Nullable
    <T> Set<PlanKey> calculateResultEquals(@NotNull Multimap<T, PlanKey> map, @Nullable T key, @Nullable Set<PlanKey> result) {
        if (key == null) {
            return result;
        }
        Set<PlanKey> matchingPlans = this.getPlansEquals(map, key);
        if (result == null) {
            return matchingPlans;
        }
        result.retainAll(matchingPlans);
        return result;
    }

    @VisibleForTesting
    @Nullable
    Set<PlanKey> calculateResultSmartContains(@NotNull Multimap<String, PlanKey> map, @Nullable String key, @Nullable Set<PlanKey> result) {
        if (key == null) {
            return result;
        }
        Set<PlanKey> matchingPlans = this.getPlansSmartContains(map, key);
        if (result == null) {
            return matchingPlans;
        }
        result.retainAll(matchingPlans);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T> Set<PlanKey> getPlansEquals(@NotNull Multimap<T, PlanKey> map, @NotNull T key) {
        Multimap<T, PlanKey> multimap = map;
        synchronized (multimap) {
            return new HashSet<PlanKey>(map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private <T> Set<PlanKey> getPlansSmartContains(@NotNull Multimap<String, PlanKey> map, @NotNull String partialKey) {
        Multimap<String, PlanKey> multimap = map;
        synchronized (multimap) {
            return map.entries().stream().filter(entry -> BambooStringUtils.smartContains((String)((String)entry.getKey()), (String)partialKey)).map(Map.Entry::getValue).collect(Collectors.toSet());
        }
    }
}

