/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.execution;

import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.plan.AbstractPlanExecutionPermitter;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.opensymphony.xwork2.TextProvider;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class UniqueRunPerKeyPlanExecutionPermitter
extends AbstractPlanExecutionPermitter {
    private final TextProvider textProvider;
    @Lazy
    @Inject
    private ChainExecutionManager chainExecutionManager;

    public UniqueRunPerKeyPlanExecutionPermitter(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    protected boolean isPermittedToExecuteImpl(@NotNull ImmutableChain chain, @Nullable PlanResultKey resultKey, @NotNull ErrorCollection errorCollection) {
        if (resultKey != null && this.chainExecutionManager.getChainExecution(resultKey) != null) {
            errorCollection.addErrorMessage(this.textProvider.getText("build.concurrent.alreadyRunning"));
            return false;
        }
        return true;
    }
}

