/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.helpers;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

@Internal
public class EffectivePlanPropertiesHelper {
    private static final Logger log = Logger.getLogger(EffectivePlanPropertiesHelper.class);

    private EffectivePlanPropertiesHelper() {
    }

    public static List<VariableDefinition> createEffectiveVariableDefinitions(ImmutablePlan plan, List<VariableDefinition> variableDefinitions) {
        ImmutablePlan master = plan.getMaster();
        if (master == null) {
            return variableDefinitions;
        }
        HashMap<String, VariableDefinition> effectiveVariables = new HashMap<String, VariableDefinition>();
        for (VariableDefinition variableDefinition : Iterables.concat((Iterable)master.getVariables(), variableDefinitions)) {
            effectiveVariables.put(variableDefinition.getKey(), variableDefinition);
        }
        return ImmutableList.copyOf(effectiveVariables.values());
    }
}

