/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.job;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.JobStatusHelper;
import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.collections.SimpleActionParametersMap;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanPredicates;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.JobPropagatingFacade;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.job.JobService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooClosures;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.validation.ValidationFunction;
import com.atlassian.bamboo.validation.ValidationFunctionFactory;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.bamboo.validation.ValidationServiceImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobServiceImpl
implements JobService {
    private static final String CFG_JOB_NAME = "name";
    private static final String CFG_JOB_DESCRIPTION = "description";
    private static final String CFG_JOB_SUSPENDED_FROM_BUILDING = "suspended";
    private static final String CFG_JOB_KEY = "key";
    private static final String CFG_SOURCE_JOB_KEY = "sourceJobKey";
    private static final String CFG_STAGE_ID = "stageId";
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private PlanManager planManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private ChainBranchManager chainBranchManager;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private ValidationService validationService;
    @Inject
    private AuditLogService auditLogService;
    @Inject
    private DeletionService deletionService;
    @Inject
    private BuildExecutionManager buildExecutionManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private JobCreationService jobCreationService;
    @Inject
    private BuildDefinitionConverter buildDefinitionConverter;
    @Inject
    private ScopedExclusionService scopedExclusionService;
    @Inject
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private ValidationFunctionFactory validationFunctionFactory;

    @NotNull
    public List<ImmutableJob> getJobsForPlan(@NotNull PlanKey planKey) {
        ImmutableChain chain = this.getAndValidateChain(planKey);
        return ImmutableList.copyOf((Collection)chain.getAllJobs());
    }

    @NotNull
    public List<ImmutableJob> getJobsForStage(@NotNull PlanKey planKey, long stageId) {
        ImmutableChain chain = this.getAndValidateChain(planKey);
        ImmutableChainStage stage = this.getAndValidateStage(chain, stageId);
        return (List)stage.getJobs().stream().sorted(Comparators.getPlanNameProviderCaseInsensitiveOrdering()).collect(CollectorsUtil.toImmutableList());
    }

    @NotNull
    public ImmutableJob getJob(@NotNull PlanKey jobKey) {
        ImmutableJob job = this.getAndValidateJobFromCache(jobKey);
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)job, null)) {
            throw new AccessDeniedException(this.textProvider.getText("job.error.permission"));
        }
        return job;
    }

    @NotNull
    private ImmutableJob getJobFromHibernate(@NotNull PlanKey jobKey) {
        ImmutableJob job = this.getAndValidateJobFromHibernate(jobKey);
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)job, null)) {
            throw new AccessDeniedException(this.textProvider.getText("job.error.permission"));
        }
        return job;
    }

    public ErrorCollection validateJobForAdd(@NotNull PlanKey planKey, long stageId, @Nullable String jobKey, @Nullable String name, @Nullable String description, boolean suspended) throws WebValidationException {
        ImmutableChain chain = this.getAndValidateChain(planKey);
        if (chain.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("job.add.error.branch"));
        }
        this.getAndValidateStage(chain, stageId);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.validateJobKey(chain, jobKey, (ErrorCollection)errorCollection);
        this.validateJobName(chain, name, (ErrorCollection)errorCollection);
        this.validateJobDescription(description, (ErrorCollection)errorCollection);
        return errorCollection;
    }

    @NotNull
    public ImmutableJob addJob(final @NotNull PlanKey chainKey, final long stageId, final @Nullable String jobKeyString, final @Nullable String name, final @Nullable String description, final boolean suspended) throws WebValidationException {
        LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException> addJobFunctor = new LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException>(){

            @Override
            public ImmutableJob call() throws WebValidationException {
                BambooValidationUtils.checkErrors(JobServiceImpl.this.validateJobForAdd(chainKey, stageId, jobKeyString, name, description, suspended));
                ImmutableChain chain = JobServiceImpl.this.getAndValidateChain(chainKey);
                ImmutableChainStage stage = JobServiceImpl.this.getAndValidateStage(chain, stageId);
                PlanKey jobKey = PlanKeys.getPlanKey((String)JobServiceImpl.this.getFullJobKey(chain, jobKeyString));
                SimpleActionParametersMap actionParametersMap = new SimpleActionParametersMap(new HashMap());
                JobParamMapHelper.setBuildKey(actionParametersMap, chain.getKey());
                JobParamMapHelper.setSubBuildKey(actionParametersMap, jobKey.getPartialKey());
                JobParamMapHelper.setBuildName(actionParametersMap, name);
                JobParamMapHelper.setBuildDescription(actionParametersMap, description);
                JobParamMapHelper.setExistingStage(actionParametersMap, stage.getName());
                PlanCreationService.EnablePlan enablePlan = PlanCreationService.EnablePlan.valueOf((!suspended ? 1 : 0) != 0);
                List<PlanKey> jobAndBranches = this.createJobAndBranches(chain, actionParametersMap, enablePlan);
                for (PlanKey jobOrBranch : jobAndBranches) {
                    JobServiceImpl.this.jobCreationService.triggerCreationCompleteEvents(jobOrBranch);
                }
                return JobServiceImpl.this.getJobFromHibernate(jobAndBranches.get(0));
            }

            @NotNull
            private List<PlanKey> createJobAndBranches(@NotNull ImmutableChain chain, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enablePlan) throws WebValidationException {
                BuildDefinition buildDefinition = chain.getBuildDefinition();
                XMLConfiguration configuration = JobServiceImpl.this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition);
                BuildConfiguration buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)configuration);
                try {
                    return JobServiceImpl.this.jobCreationService.createJobAndBranches(buildConfiguration, actionParametersMap, enablePlan);
                }
                catch (PlanCreationDeniedException e) {
                    throw new WebValidationException("Plan creation denied while creating new job for " + chainKey + ".");
                }
            }
        };
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(addJobFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chainKey, functor);
    }

    public ErrorCollection validateJobForClone(@Nullable String sourceJobKeyString, @NotNull PlanKey chainKey, long stageId, @Nullable String newJobKey, @Nullable String name, @Nullable String description, @Nullable Boolean suspended) throws WebValidationException {
        ImmutableChain chain = this.getAndValidateChain(chainKey);
        if (chain.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("job.add.error.branch"));
        }
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.CLONE, (Object)sourceJobKeyString, null)) {
            throw new AccessDeniedException(this.textProvider.getText("job.clone.permission"));
        }
        this.getAndValidateStage(chain, stageId);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(this.validationService.validateJobKey(CFG_SOURCE_JOB_KEY, sourceJobKeyString, new ValidationFunction[]{this.validationFunctionFactory.jobExists()}));
        this.validateJobKey(chain, newJobKey, (ErrorCollection)errorCollection);
        this.validateJobName(chain, name, (ErrorCollection)errorCollection);
        this.validateJobDescription(description, (ErrorCollection)errorCollection);
        return errorCollection;
    }

    public ImmutableJob cloneJob(final @NotNull String sourceJobKeyString, final @NotNull PlanKey chainKey, final long stageId, final @NotNull String newJobKeyString, final @NotNull String name, final @Nullable String description, final boolean suspended) throws WebValidationException {
        LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException> cloneJobFunctor = new LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException>(){

            @Override
            public ImmutableJob call() throws WebValidationException {
                BambooValidationUtils.checkErrors(JobServiceImpl.this.validateJobForClone(sourceJobKeyString, chainKey, stageId, newJobKeyString, name, description, suspended));
                PlanKey sourceJobKey = PlanKeys.getPlanKey((String)sourceJobKeyString);
                ImmutableJob jobToClone = JobServiceImpl.this.getJob(sourceJobKey);
                ImmutableChain chain = JobServiceImpl.this.getAndValidateChain(chainKey);
                String stageName = JobServiceImpl.this.getAndValidateStage(chain, stageId).getName();
                PlanKey newJobKey = PlanKeys.getPlanKey((String)JobServiceImpl.this.getFullJobKey(chain, newJobKeyString));
                PlanCreationService.EnablePlan enablePlan = PlanCreationService.EnablePlan.valueOf((!suspended ? 1 : 0) != 0);
                SimpleActionParametersMap actionParametersMap = new SimpleActionParametersMap(new HashMap());
                JobParamMapHelper.setCloneJob(actionParametersMap, true);
                JobParamMapHelper.setJobKeyToClone(actionParametersMap, jobToClone.getKey());
                JobParamMapHelper.setBuildKey(actionParametersMap, chainKey.getKey());
                JobParamMapHelper.setSubBuildKey(actionParametersMap, newJobKey.getPartialKey());
                JobParamMapHelper.setBuildName(actionParametersMap, name);
                JobParamMapHelper.setBuildDescription(actionParametersMap, description);
                JobParamMapHelper.setExistingStage(actionParametersMap, stageName);
                String jobKey = this.createSingleJob(actionParametersMap, enablePlan);
                return (ImmutableJob)JobServiceImpl.this.cachedPlanManager.getPlanByKeyIfOfType(PlanKeys.getPlanKey((String)jobKey), ImmutableJob.class);
            }

            @NotNull
            private String createSingleJob(@NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enablePlan) throws WebValidationException {
                try {
                    return JobServiceImpl.this.jobCreationService.createSingleJob(new BuildConfiguration(), actionParametersMap, enablePlan);
                }
                catch (PlanCreationDeniedException e) {
                    throw new WebValidationException("Plan creation denied while cloning job for " + chainKey + ".");
                }
            }
        };
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(cloneJobFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chainKey, functor);
    }

    public void deleteJob(@NotNull PlanKey jobKey, BambooClosures.Throwing1<ImmutableJob, WebValidationException> ... runBefore) throws WebValidationException {
        Job job = this.getAndValidateMutableJob(jobKey);
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)job, null)) {
            throw new AccessDeniedException(this.textProvider.getText("job.error.permission"));
        }
        BambooValidationUtils.validate(!job.hasMaster(), () -> this.textProvider.getText("job.remove.branch", Collections.singletonList(jobKey.getKey())));
        JobStatusHelper jobStatusHelper = new JobStatusHelper((ImmutableJob)job, this.buildExecutionManager);
        BambooValidationUtils.validate(!jobStatusHelper.isActive(), () -> this.textProvider.getText("plan.delete.active"));
        for (BambooClosures.Throwing1<ImmutableJob, WebValidationException> closure : runBefore) {
            closure.run((Object)job);
        }
        this.deletionService.deletePlan((Plan)job);
    }

    @NotNull
    public ErrorCollection validateJobForUpdate(@NotNull PlanKey jobKey, @NotNull String name, @Nullable String description, boolean suspended, long stageId) {
        ImmutableJob job = this.getJob(jobKey);
        if (job.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("job.update.error.branch"));
        }
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)job, null)) {
            throw new AccessDeniedException(this.textProvider.getText("job.error.permission"));
        }
        ImmutableChain chain = job.getParent();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.getAndValidateStage(chain, stageId);
        }
        catch (NotFoundException e) {
            errorCollection.addError(CFG_STAGE_ID, e.getMessage());
        }
        errorCollection.addErrorCollection(this.validationService.validateName(CFG_JOB_NAME, "job", name));
        ImmutableJob jobWithSameName = (ImmutableJob)Iterables.findFirst((Iterable)chain.getAllJobs(), PlanPredicates.hasEqualBuildName(name)::test).getOrNull();
        if (jobWithSameName != null && jobWithSameName.getId() != job.getId()) {
            errorCollection.addError(CFG_JOB_NAME, this.textProvider.getText("job.name.exists"));
        }
        this.validateJobDescription(description, (ErrorCollection)errorCollection);
        return errorCollection;
    }

    @NotNull
    public ImmutableJob updateJob(final @NotNull PlanKey jobKey, final @NotNull String name, final @Nullable String description, final boolean suspended, final long stageId, final BambooClosures.Throwing1<ImmutableJob, WebValidationException> ... runBefore) throws WebValidationException {
        LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException> updateJobFunctor = new LimitedConcurrencyCaller.Callable<ImmutableJob, WebValidationException>(){

            @Override
            public ImmutableJob call() throws WebValidationException {
                List brokenArtifactSubscriptions;
                boolean isMoved;
                BambooValidationUtils.checkErrors(JobServiceImpl.this.validateJobForUpdate(jobKey, name, description, suspended, stageId));
                Job originalJob = JobServiceImpl.this.getAndValidateMutableJob(jobKey);
                String originalName = originalJob.getBuildName();
                String originalDescription = originalJob.getDescription();
                boolean originalSuspended = originalJob.isSuspendedFromBuilding();
                ChainStage originalStage = originalJob.getStage();
                ChainStage newStage = (ChainStage)JobServiceImpl.this.getAndValidateStage((ImmutableChain)originalJob.getParent(), stageId);
                boolean bl = isMoved = originalStage.getId() != stageId;
                if (isMoved) {
                    JobStatusHelper jobStatusHelper = new JobStatusHelper((ImmutableJob)originalJob, JobServiceImpl.this.buildExecutionManager);
                    BambooValidationUtils.validate(!jobStatusHelper.isActive(), () -> JobServiceImpl.this.textProvider.getText("job.move.active"));
                }
                for (BambooClosures.Throwing1 closure : runBefore) {
                    closure.run((Object)originalJob);
                }
                if (isMoved && !(brokenArtifactSubscriptions = JobServiceImpl.this.artifactSubscriptionManager.validateSubscriptionsForMovedJob((ImmutableJob)originalJob, (ImmutableChainStage)newStage)).isEmpty()) {
                    JobServiceImpl.this.artifactSubscriptionManager.removeArtifactSubscriptions((Collection)brokenArtifactSubscriptions);
                }
                JobPropagatingFacade jobAndBranches = new JobPropagatingFacade(JobServiceImpl.this.chainBranchManager, originalJob);
                jobAndBranches.setBuildName(name);
                jobAndBranches.setDescription(description);
                jobAndBranches.setSuspendedFromBuilding(suspended);
                JobServiceImpl.this.moveStage(originalJob, newStage);
                jobAndBranches.savePlan(JobServiceImpl.this.planManager);
                jobAndBranches.publishBuildConfigurationUpdatedEvent(JobServiceImpl.this.eventPublisher, this);
                JobServiceImpl.this.auditLogService.log(JobServiceImpl.CFG_JOB_NAME, originalName, name, (Key)jobKey, AuditLogEntityType.PLAN, null);
                JobServiceImpl.this.auditLogService.log(JobServiceImpl.CFG_JOB_DESCRIPTION, originalDescription, StringUtils.defaultString((String)description), (Key)jobKey, AuditLogEntityType.PLAN, null);
                JobServiceImpl.this.auditLogService.log(JobServiceImpl.CFG_JOB_SUSPENDED_FROM_BUILDING, BooleanUtils.toStringTrueFalse((boolean)originalSuspended), BooleanUtils.toStringTrueFalse((boolean)suspended), (Key)jobKey, AuditLogEntityType.PLAN, null);
                JobServiceImpl.this.auditLogService.log(JobServiceImpl.CFG_STAGE_ID, Long.toString(originalStage.getId()), Long.toString(newStage.getId()), (Key)jobKey, AuditLogEntityType.PLAN, null);
                return JobServiceImpl.this.getJobFromHibernate(jobKey);
            }
        };
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(updateJobFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, PlanKeys.getChainKeyFromJobKey((PlanKey)jobKey), functor);
    }

    private void moveStage(Job originalJob, ChainStage newStage) {
        if (originalJob.getStage().getId() != newStage.getId()) {
            originalJob.getStage().removeJob(originalJob);
            newStage.addJob(originalJob);
        }
    }

    @NotNull
    private ImmutableChain getAndValidateChain(@NotNull PlanKey planKey) throws NotFoundException, AccessDeniedException {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class);
        if (chain == null) {
            throw new NotFoundException(this.textProvider.getText("chain.error.noChain", Collections.singletonList(planKey.getKey())));
        }
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, (ImmutablePlan)chain)) {
            throw new AccessDeniedException(this.textProvider.getText("job.error.permission"));
        }
        return chain;
    }

    @NotNull
    private ImmutableJob getAndValidateJobFromCache(@NotNull PlanKey jobKey) throws NotFoundException {
        ImmutableJob job = (ImmutableJob)this.cachedPlanManager.getPlanByKeyIfOfType(jobKey, ImmutableJob.class);
        if (job == null) {
            throw new NotFoundException(this.textProvider.getText("job.error.noJob", (List)ImmutableList.of((Object)jobKey)));
        }
        return job;
    }

    @NotNull
    private ImmutableJob getAndValidateJobFromHibernate(@NotNull PlanKey jobKey) throws NotFoundException {
        ImmutableJob job = (ImmutableJob)this.planManager.getPlanByKeyIfOfType(jobKey, Job.class);
        if (job == null) {
            throw new NotFoundException(this.textProvider.getText("job.error.noJob", (List)ImmutableList.of((Object)jobKey)));
        }
        return job;
    }

    @NotNull
    private ImmutableChainStage getAndValidateStage(@NotNull ImmutableChain chain, long stageId) throws NotFoundException {
        return chain.getStages().stream().filter(arg_0 -> BambooPredicates.hasBambooObjectEqualId(stageId).apply(arg_0)).findFirst().orElseThrow(() -> new NotFoundException(this.textProvider.getText("stage.error.noStage", Collections.singletonList(Long.toString(stageId)))));
    }

    @NotNull
    private Job getAndValidateMutableJob(@NotNull PlanKey jobKey) throws NotFoundException {
        Job job = (Job)this.planManager.getPlanByKeyIfOfType(jobKey, Job.class);
        if (job == null) {
            throw new NotFoundException(this.textProvider.getText("job.error.noJob", (List)ImmutableList.of((Object)jobKey.getKey())));
        }
        return job;
    }

    @Nullable
    private String getFullJobKey(@NotNull ImmutableChain chain, @Nullable String jobKey) {
        if (!StringUtils.isEmpty((CharSequence)jobKey) && ValidationServiceImpl.PARTIAL_JOB_KEY_PATTERN.matcher(jobKey).matches()) {
            return chain.getKey() + '-' + jobKey;
        }
        return jobKey;
    }

    private void validateJobKey(@NotNull ImmutableChain chain, @Nullable String newJobKey, @NotNull ErrorCollection errorCollection) {
        String fullJobKey = this.getFullJobKey(chain, newJobKey);
        errorCollection.addErrorCollection(this.validationService.validateJobKey(CFG_JOB_KEY, fullJobKey, new ValidationFunction[]{this.validationFunctionFactory.isJobKeyFromChain(chain), this.validationFunctionFactory.isUniqueJobKey()}));
    }

    private void validateJobName(@NotNull ImmutableChain chain, @Nullable String name, @NotNull ErrorCollection errorCollection) {
        ImmutableJob jobWithSameName = (ImmutableJob)Iterables.findFirst((Iterable)chain.getAllJobs(), PlanPredicates.hasEqualBuildName(name)::test).getOrNull();
        if (jobWithSameName != null) {
            errorCollection.addError(CFG_JOB_NAME, this.textProvider.getText("job.name.exists"));
        }
        errorCollection.addErrorCollection(this.validationService.validateName(CFG_JOB_NAME, "job", name));
    }

    private void validateJobDescription(@Nullable String description, @NotNull ErrorCollection errorCollection) {
        errorCollection.addErrorCollection(this.validationService.validateDescription(CFG_JOB_DESCRIPTION, description));
    }
}

