/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.plan.MovePlansException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.move.MovePlanCoordinator;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

class MovePlanBatchCoordinator {
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    @Inject
    private SessionFactory sessionFactory;
    private final Collection<TopLevelPlan> plans;
    private final Project newProject;
    private final Map<String, String> planKeyMappings;
    private final Map<String, String> planNameMappings;
    private Map<PlanKey, PlanKey> planKeyChanges = new HashMap<PlanKey, PlanKey>();

    public MovePlanBatchCoordinator(Collection<TopLevelPlan> plans, Project newProject, Map<String, String> planKeyMappings, Map<String, String> planNameMappings) {
        this.plans = plans;
        this.newProject = newProject;
        this.planKeyMappings = planKeyMappings;
        this.planNameMappings = planNameMappings;
    }

    public Map<PlanKey, PlanKey> movePlans() throws MovePlansException {
        try {
            this.flushAndClearHibernateSession();
            this.tryMovePlans();
        }
        catch (Exception e) {
            throw new MovePlansException(e.getMessage(), (Throwable)e, this.planKeyChanges);
        }
        return this.planKeyChanges;
    }

    private void tryMovePlans() {
        for (TopLevelPlan plan : this.plans) {
            String newPlanKeyPart = this.planKeyMappings.get(String.valueOf(plan.getId()));
            String newPlanNamePart = this.planNameMappings.get(String.valueOf(plan.getId()));
            this.movePlan(plan.getId(), newPlanKeyPart, newPlanNamePart);
        }
    }

    private void movePlan(long masterPlanId, String newPlanKeyPart, String newPlanNamePart) {
        MovePlanCoordinator coordinator = this.createMovePlanCoordinator(masterPlanId, newPlanKeyPart, newPlanNamePart);
        Map<PlanKey, PlanKey> pkc = coordinator.movePlan();
        this.planKeyChanges.putAll(pkc);
    }

    @NotNull
    private MovePlanCoordinator createMovePlanCoordinator(long masterPlanId, String newPlanKeyPart, String newPlanNamePart) {
        MovePlanCoordinator coordinator = new MovePlanCoordinator(masterPlanId, this.newProject, newPlanKeyPart, newPlanNamePart);
        this.beanFactory.autowireBean((Object)coordinator);
        return coordinator;
    }

    private void flushAndClearHibernateSession() {
        Session session = this.sessionFactory.getCurrentSession();
        BambooHibernateUtils.flushIfNeeded(session);
        session.clear();
    }
}

