/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.events.ChainMovedEvent;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.plan.PlanExecutionLockService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.TriggerableInternalKeyImpl;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.move.MovePlanFinalAction;
import com.atlassian.bamboo.plan.move.PlanState;
import com.atlassian.bamboo.plan.move.TransactionalPlanMover;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.trigger.TriggerableInternalKey;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

class MovePlanCoordinator {
    private static final Logger log = Logger.getLogger(MovePlanCoordinator.class);
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private PlanManager planManager;
    @Inject
    private ChainBranchManager chainBranchManager;
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;
    @Inject
    private BuildResultsIndexer buildResultsIndexer;
    @Inject
    private ChainExecutionManager chainExecutionManager;
    @Inject
    private PlanExecutionLockService planExecutionLockService;
    @Inject
    private TriggerTypeManager triggerTypeManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    private final long masterPlanId;
    private final Project newProject;
    private final String newPlanKeyPart;
    private final String newPlanNamePart;
    private final Set<Long> plansToResume = new HashSet<Long>();
    private final List<MovePlanFinalAction> afterCacheReadyActions = new ArrayList<MovePlanFinalAction>();
    private PlanState planState;

    public MovePlanCoordinator(long masterPlanId, Project newProject, String newPlanKeyPart, String newPlanNamePart) {
        this.masterPlanId = masterPlanId;
        this.newProject = newProject;
        this.newPlanKeyPart = newPlanKeyPart;
        this.newPlanNamePart = newPlanNamePart;
    }

    Map<PlanKey, PlanKey> movePlan() {
        Map planKeyChanges;
        this.planState = this.getFreshPlanState();
        this.assertPermissionToMove(this.planState.getMaster());
        try {
            List<PlanKey> masterAndBranches = this.planState.getKeysOfMasterAndBranches();
            planKeyChanges = (Map)this.immutablePlanCacheService.withHiddenPlans(masterAndBranches, () -> {
                masterAndBranches.forEach(arg_0 -> ((ImmutablePlanCacheService)this.immutablePlanCacheService).remove(arg_0));
                try {
                    return this.movePlanWithoutTouchingCache();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            });
        }
        finally {
            this.preloadCache();
        }
        AtomicReference<Exception> storedException = new AtomicReference<Exception>();
        for (MovePlanFinalAction afterCacheReadyAction : this.afterCacheReadyActions) {
            try {
                afterCacheReadyAction.run();
            }
            catch (Exception e) {
                storedException.compareAndSet(null, e);
            }
        }
        if (storedException.get() != null) {
            throw new RuntimeException((Throwable)storedException.get());
        }
        this.publishChainMovedEvents(planKeyChanges);
        return planKeyChanges;
    }

    private void assertPermissionToMove(Chain chain) {
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.ADMINISTRATION, (Object)chain, null)) {
            throw new RuntimeException("User does not have permission to move plan " + chain.getName());
        }
    }

    private void preloadCache() {
        for (PlanKey planKey : this.planState.getKeysOfMasterAndBranches()) {
            this.immutablePlanCacheService.getImmutablePlanByKey(planKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PlanKey, PlanKey> movePlanWithoutTouchingCache() throws Exception {
        ArrayList<MovePlanFinalAction> finalActions = new ArrayList<MovePlanFinalAction>();
        try {
            MovePlanFinalAction resumeChains = this.suspendChains();
            this.afterCacheReadyActions.add(resumeChains);
            finalActions.add(this.deIndexBuilds());
            Map<PlanKey, PlanKey> map = this.movePlanTransaction(this.masterPlanId, this.newProject, this.newPlanKeyPart, this.newPlanNamePart);
            return map;
        }
        finally {
            for (MovePlanFinalAction finalAction : Lists.reverse(finalActions)) {
                finalAction.run();
            }
        }
    }

    private MovePlanFinalAction suspendChains() throws Exception {
        for (Chain chain : this.planState.getMasterAndBranches()) {
            if (this.suspendChain(chain)) continue;
            throw new RuntimeException("Plan " + this.planState.getMaster().getName() + " is currently executing, plan move aborted.");
        }
        return this::resumeChains;
    }

    private boolean suspendChain(Chain chain) throws Exception {
        Boolean result = (Boolean)this.planExecutionLockService.lock((TriggerableInternalKey)new TriggerableInternalKeyImpl((Triggerable)chain), AcquisitionPolicy.WAIT, () -> {
            if (this.chainExecutionManager.isActive(chain.getPlanKey())) {
                return Boolean.FALSE;
            }
            if (!chain.isSuspendedFromBuilding()) {
                this.plansToResume.add(chain.getId());
                this.planManager.setPlanSuspendedState(chain.getPlanKey(), true);
            }
            return Boolean.TRUE;
        });
        return BooleanUtils.toBoolean((Boolean)result);
    }

    private void resumeChains() {
        this.planState.getMasterAndBranches().stream().filter(chain -> this.plansToResume.contains(chain.getId())).forEach(chain -> this.planManager.setPlanSuspendedState(chain.getPlanKey(), false));
    }

    private MovePlanFinalAction deIndexBuilds() throws Exception {
        for (Chain chain : this.planState.getMasterAndBranches()) {
            this.buildResultsIndexer.deIndexBuild(chain.getPlanKey());
            for (PlanKey jobKey : this.resultsSummaryManager.findJobKeysFromExistingChainResults(chain.getPlanKey())) {
                this.buildResultsIndexer.deIndexBuild(jobKey);
            }
        }
        return this::indexBuilds;
    }

    private void indexBuilds() throws Exception {
        for (Chain chain : this.planState.getMasterAndBranches()) {
            this.buildResultsIndexer.indexChain((ImmutableChain)chain);
            HashSet<PlanKey> alreadyProcessed = new HashSet<PlanKey>();
            for (Job job : chain.getAllJobs()) {
                this.buildResultsIndexer.indexJob((ImmutableJob)job);
                alreadyProcessed.add(job.getPlanKey());
            }
            for (PlanKey jobKey : this.resultsSummaryManager.findJobKeysFromExistingChainResults(chain.getPlanKey())) {
                if (alreadyProcessed.contains(jobKey)) continue;
                this.buildResultsIndexer.indexJob((ImmutableChain)chain, jobKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PlanKey, PlanKey> movePlanTransaction(long masterPlanId, Project newProject, String newPlanKeyPart, String newPlanNamePart) {
        try {
            TransactionalPlanMover planMover = this.createTransactionalPlanMover(masterPlanId, newProject, newPlanKeyPart, newPlanNamePart);
            planMover.movePlan();
            Map<PlanKey, PlanKey> map = planMover.getPlanKeyChanges();
            return map;
        }
        finally {
            this.planState = this.getFreshPlanState();
        }
    }

    @NotNull
    private TransactionalPlanMover createTransactionalPlanMover(long masterPlanId, Project newProject, String newPlanKeyPart, String newPlanNamePart) {
        TransactionalPlanMover planMover = new TransactionalPlanMover(masterPlanId, newProject, newPlanKeyPart, newPlanNamePart);
        this.beanFactory.autowireBean((Object)planMover);
        return planMover;
    }

    private PlanState getFreshPlanState() {
        TopLevelPlan master = (TopLevelPlan)this.planManager.getPlanById(this.masterPlanId, TopLevelPlan.class);
        List branches = this.chainBranchManager.getBranchesForChain((ImmutableChain)master);
        return new PlanState(master, branches);
    }

    private void publishChainMovedEvents(Map<PlanKey, PlanKey> planKeyChanges) {
        for (Map.Entry<PlanKey, PlanKey> entry : planKeyChanges.entrySet()) {
            this.publishChainMovedEvent(entry.getKey(), entry.getValue());
        }
    }

    private void publishChainMovedEvent(final PlanKey oldKey, final PlanKey newKey) {
        BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable("Processing of ChainMovedEvent has failed"){

            @Override
            public void run() {
                MovePlanCoordinator.this.eventPublisher.publish((Object)new ChainMovedEvent(MovePlanCoordinator.this, oldKey, newKey));
            }
        });
    }
}

