/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.plan.MovePlanService;
import com.atlassian.bamboo.plan.MovePlansException;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.move.MovePlanBatchCoordinator;
import com.atlassian.bamboo.plan.move.MovePlanValidationService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.struts.ValidationAware;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class MovePlanServiceImpl
implements MovePlanService {
    private static final Logger log = Logger.getLogger(MovePlanServiceImpl.class);
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    @Inject
    private MovePlanValidationService movePlanValidationService;

    public void validatePlanKeysAndNamesForProject(ValidationAware validationAware, Project project, Map<String, String> planKeyMappings, Map<String, String> planNameMappings) {
        this.movePlanValidationService.validatePlanKeysAndNamesForProject(validationAware, project, planKeyMappings, planNameMappings);
    }

    public Map<PlanKey, PlanKey> movePlansToProject(Collection<TopLevelPlan> plans, Project newProject, Map<String, String> planKeyMappings, Map<String, String> planNameMappings) throws MovePlansException {
        return this.createBatchCoordinator(plans, newProject, planKeyMappings, planNameMappings).movePlans();
    }

    @NotNull
    private MovePlanBatchCoordinator createBatchCoordinator(Collection<TopLevelPlan> plans, Project newProject, Map<String, String> planKeyMappings, Map<String, String> planNameMappings) {
        MovePlanBatchCoordinator batchCoordinator = new MovePlanBatchCoordinator(plans, newProject, planKeyMappings, planNameMappings);
        this.beanFactory.autowireBean((Object)batchCoordinator);
        return batchCoordinator;
    }
}

