/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanType;
import com.atlassian.bamboo.plan.move.MovePlanValidationService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.LinkedListMultimap;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class MovePlanValidationServiceImpl
implements MovePlanValidationService {
    private static final Logger log = Logger.getLogger(MovePlanValidationServiceImpl.class);
    @Inject
    private PlanManager planManager;
    @Inject
    private PlanValidationService planValidationService;
    @Inject
    private TextProvider textProvider;

    @Override
    public void validatePlanKeysAndNamesForProject(ValidationAware validationAware, Project project, Map<String, String> planKeyMappings, Map<String, String> planNameMappings) {
        Collection strings;
        String buildId;
        LinkedListMultimap buildKeysForProject = LinkedListMultimap.create();
        LinkedListMultimap buildNamesForProject = LinkedListMultimap.create();
        for (PlanIdentifier planIdentifier : this.planManager.getPlanIdentifiersForProject((ProjectIdentifier)project, Chain.class, true)) {
            buildKeysForProject.put((Object)planIdentifier.getBuildKey(), (Object)planIdentifier.getBuildKey());
            if (PlanType.CHAIN != planIdentifier.getPlanType()) continue;
            buildNamesForProject.put((Object)planIdentifier.getBuildName(), (Object)planIdentifier.getBuildName());
        }
        for (String string : planKeyMappings.values()) {
            if (string == null) continue;
            buildKeysForProject.put((Object)string, (Object)string);
        }
        for (String string : planNameMappings.values()) {
            if (string == null) continue;
            buildNamesForProject.put((Object)string, (Object)string);
        }
        for (Map.Entry entry : planKeyMappings.entrySet()) {
            buildId = (String)entry.getKey();
            String buildKey = (String)entry.getValue();
            if (buildKey == null) continue;
            strings = buildKeysForProject.get((Object)buildKey);
            if (strings.size() > 1) {
                validationAware.addFieldError("planKeyMappings[" + buildId + "]", this.textProvider.getText("build.move.error.duplicateKeys"));
                continue;
            }
            this.planValidationService.validateKey(validationAware, "planKeyMappings[" + buildId + "]", "plan", buildKey);
        }
        for (Map.Entry entry : planNameMappings.entrySet()) {
            buildId = (String)entry.getKey();
            String buildName = (String)entry.getValue();
            if (buildName == null) continue;
            strings = buildNamesForProject.get((Object)buildName);
            if (strings.size() > 1) {
                validationAware.addFieldError("planNameMappings[" + buildId + "]", this.textProvider.getText("build.move.error.duplicateNames"));
                continue;
            }
            this.planValidationService.validateName(validationAware, "planNameMappings[" + buildId + "]", "plan", buildName);
        }
    }
}

