/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class PlanState {
    private final List<Chain> masterAndBranches;

    public PlanState(@NotNull TopLevelPlan masterPlan, @NotNull List<ChainBranch> otherBranches) {
        this.masterAndBranches = new ArrayList<Chain>(1 + otherBranches.size());
        this.masterAndBranches.add((Chain)masterPlan);
        this.masterAndBranches.addAll(otherBranches);
    }

    @NotNull
    public Chain getMaster() {
        return this.masterAndBranches.get(0);
    }

    @NotNull
    public List<Chain> getMasterAndBranches() {
        return this.masterAndBranches;
    }

    @NotNull
    public List<PlanKey> getKeysOfMasterAndBranches() {
        return this.masterAndBranches.stream().map(PlanIdentifier::getPlanKey).collect(Collectors.toList());
    }
}

