/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.move;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.events.ChainMovingEvent;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceImpl;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.IncorrectPlanTypeException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.event.api.EventPublisher;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionTemplate;

class TransactionalPlanMover {
    private static final Logger log = Logger.getLogger(TransactionalPlanMover.class);
    @Inject
    private TransactionTemplate transactionTemplate;
    @Inject
    private ArtifactDao artifactDao;
    @Inject
    private AuditLogService auditLogService;
    @Inject
    private ChainBranchManager chainBranchManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ScopedExclusionServiceImpl exclusionService;
    @Inject
    private PlanManager planManager;
    @Inject
    private PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private SessionFactory sessionFactory;
    private final long masterPlanId;
    private final Project newProject;
    private final String newMasterKeyPart;
    private final String newMasterNamePart;
    private final Map<PlanKey, PlanKey> planKeyChanges = new HashMap<PlanKey, PlanKey>();
    private TopLevelPlan masterPlan;
    private String oldMasterKeyPart;

    TransactionalPlanMover(long masterPlanId, Project newProject, String newMasterKeyPart, String newMasterNamePart) {
        this.masterPlanId = masterPlanId;
        this.newProject = newProject;
        this.newMasterKeyPart = newMasterKeyPart;
        this.newMasterNamePart = newMasterNamePart;
    }

    Map<PlanKey, PlanKey> getPlanKeyChanges() {
        return this.planKeyChanges;
    }

    void movePlan() {
        this.transactionTemplate.execute(txStatus -> {
            this.init();
            this.moveMasterAndBranches();
            return null;
        });
    }

    private void init() {
        this.masterPlan = (TopLevelPlan)this.planManager.getPlanById(this.masterPlanId, TopLevelPlan.class);
        this.oldMasterKeyPart = this.masterPlan.getBuildKey();
    }

    private void moveMasterAndBranches() {
        log.info((Object)("Moving master plan: " + this.masterPlan.getPlanKey()));
        this.moveMaster();
        List branches = this.chainBranchManager.getBranchesForChain((ImmutableChain)this.masterPlan);
        log.info((Object)("Moving branches of plan: " + this.masterPlan.getPlanKey() + ": " + TransactionalPlanMover.toKeys(branches)));
        branches.forEach(this::moveBranch);
        log.info((Object)("Move of " + this.masterPlan.getPlanKey() + " completed, committing changes"));
    }

    private static List<PlanKey> toKeys(Collection<ChainBranch> branches) {
        return branches.stream().map(PlanIdentifier::getPlanKey).collect(Collectors.toList());
    }

    private void moveMaster() {
        this.moveSinglePlan((Chain)this.masterPlan, this.newMasterKeyPart, this.newMasterNamePart);
    }

    private void moveBranch(ChainBranch branch) {
        this.exclusionService.withNewLockedObject((Enum<?>)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, this.newProject.getKey(), null, this.uniqueBranchKeyGenerator(branch.getBuildKey()), this.moveBranchWithKeyFunction(branch));
    }

    private ScopedExclusionService.GeneratorCallable<String, IncorrectPlanTypeException> uniqueBranchKeyGenerator(String originalBranchPlanKeyPart) {
        return () -> {
            if (this.masterKeyChanged() || this.isPlanKeyConflicting(originalBranchPlanKeyPart)) {
                long i = this.chainBranchManager.getNextBranchKeyNumber((ImmutablePlan)this.masterPlan);
                while (true) {
                    String candidateKeyPart;
                    if (!this.isPlanKeyConflicting(candidateKeyPart = this.masterPlan.getBuildKey() + i)) {
                        this.chainBranchManager.updateNextBranchKeyNumber((ImmutablePlan)this.masterPlan, i + 1L);
                        return candidateKeyPart;
                    }
                    ++i;
                }
            }
            return originalBranchPlanKeyPart;
        };
    }

    private boolean masterKeyChanged() {
        return !this.newMasterKeyPart.equals(this.oldMasterKeyPart);
    }

    private boolean isPlanKeyConflicting(String planKeyPart) {
        return this.planManager.isPlanKeyConflicting(PlanKeys.getPlanKey((String)this.newProject.getKey(), (String)planKeyPart));
    }

    private ScopedExclusionService.ExclusiveFunction<String, String, RuntimeException> moveBranchWithKeyFunction(ChainBranch branch) {
        return newBranchKey -> {
            this.moveSinglePlan((Chain)branch, (String)newBranchKey, branch.getBuildName());
            return null;
        };
    }

    private void moveSinglePlan(Chain chainOrBranch, String newPlanKeyPart, String newPlanNamePart) {
        PlanKey oldPlanKey = chainOrBranch.getPlanKey();
        String oldPlanName = chainOrBranch.getName();
        Map<PlanKey, PlanKey> keyChangeMap = this.updatePlanAndJobDetails(chainOrBranch, newPlanKeyPart, newPlanNamePart);
        this.updateResultSummaries(chainOrBranch, keyChangeMap);
        this.updateRevisionHistory(chainOrBranch, oldPlanKey);
        this.updateArtifacts(keyChangeMap);
        this.publishChainMovingEvent(chainOrBranch, oldPlanKey);
        this.planKeyChanges.put(oldPlanKey, chainOrBranch.getPlanKey());
        this.auditLogService.log("Plan moved", oldPlanName + " (" + oldPlanKey + ")", chainOrBranch.getName() + " (" + chainOrBranch.getPlanKey() + ")", null);
        this.auditLogService.log("Plan moved from " + oldPlanName + " (" + oldPlanKey + ")", (Key)chainOrBranch.getPlanKey(), AuditLogEntityType.PLAN);
        this.flushAndClearHibernateSession();
    }

    @NotNull
    private Map<PlanKey, PlanKey> updatePlanAndJobDetails(Chain chain, String newPlanKeyPart, String newPlanNamePart) {
        log.info((Object)"Updating plan and job details");
        PlanKey originalKey = chain.getPlanKey();
        chain.setKey(PlanKeys.getPlanKey((String)this.newProject.getKey(), (String)newPlanKeyPart).toString());
        chain.setBuildKey(newPlanKeyPart);
        chain.setBuildName(newPlanNamePart);
        chain.setProject(this.newProject);
        this.planManager.savePlan((Plan)chain);
        HashMap<PlanKey, PlanKey> keyChangeMap = new HashMap<PlanKey, PlanKey>();
        keyChangeMap.put(originalKey, chain.getPlanKey());
        for (Job job : chain.getAllJobs()) {
            PlanKey jobKey = job.getPlanKey();
            keyChangeMap.put(jobKey, this.setJobProjectKey(job));
        }
        for (PlanKey jobKey : this.resultsSummaryManager.findJobKeysFromExistingChainResults(originalKey)) {
            keyChangeMap.computeIfAbsent(jobKey, j -> PlanKeys.getPlanKey((String)this.newProject.getKey(), (String)chain.getBuildKey(), (String)PlanKeys.getPartialJobKey((PlanKey)j)));
        }
        log.info((Object)"Finished updating plan and job details");
        return keyChangeMap;
    }

    private PlanKey setJobProjectKey(Job job) {
        job.setKey(PlanKeys.getPlanKey((String)this.newProject.getKey(), (String)job.getParent().getBuildKey(), (String)job.getBuildKey()).toString());
        job.setProject(this.newProject);
        this.planManager.savePlan((Plan)job);
        return job.getPlanKey();
    }

    private void updateResultSummaries(Chain chain, Map<PlanKey, PlanKey> keyChangeMap) {
        log.info((Object)"Updating result summaries");
        for (Map.Entry<PlanKey, PlanKey> entry : keyChangeMap.entrySet()) {
            this.resultsSummaryManager.moveResultSummaries((Plan)chain, entry.getKey(), entry.getValue());
        }
        log.info((Object)"Finished updating result summaries");
    }

    private void updateRevisionHistory(Chain chain, PlanKey originalPlanKey) {
        log.info((Object)"Updating revision history");
        this.planVcsRevisionHistoryService.moveRevisionHistoryForPlan(originalPlanKey, chain.getPlanKey());
        log.info((Object)"Finished updating revision history");
    }

    private void updateArtifacts(Map<PlanKey, PlanKey> keyChangeMap) {
        log.info((Object)"Updating artifacts");
        for (Map.Entry<PlanKey, PlanKey> entry : keyChangeMap.entrySet()) {
            this.artifactDao.updatePlanKey(entry.getKey(), entry.getValue());
        }
        log.info((Object)"Finished updating artifacts");
    }

    private void publishChainMovingEvent(final Chain chain, final PlanKey originalPlanKey) {
        BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.Runnable("Processing of ChainMovingEvent has failed"){

            @Override
            public void run() {
                TransactionalPlanMover.this.eventPublisher.publish((Object)new ChainMovingEvent(TransactionalPlanMover.this, originalPlanKey, chain.getPlanKey()));
            }
        });
    }

    private void flushAndClearHibernateSession() {
        Session session = this.sessionFactory.getCurrentSession();
        session.flush();
        session.clear();
    }
}

