/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionJob;
import com.atlassian.bamboo.quartz.PreventJobExecutionUntilCompletedTriggerListener;
import com.atlassian.bamboo.utils.SystemProperty;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class PullRequestDetectionJobScheduler {
    private static final Logger log = Logger.getLogger(PullRequestDetectionJobScheduler.class);
    public static final String PR_DETECTION = "PullRequestDetection";
    private static final JobKey JOB_KEY = new JobKey("PullRequestDetection", "PullRequestDetection");
    private final Scheduler scheduler;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public PullRequestDetectionJobScheduler(Scheduler scheduler, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.scheduler = scheduler;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void schedulePullRequestDetecting() throws SchedulerException {
        int prDetectionCheckInterval;
        if ((int)SystemProperty.PULL_REQUEST_POLLING_INTERVAL.getTypedValue() <= 0) {
            if (SystemProperty.PULL_REQUEST_POLLING_INTERVAL.exists()) {
                log.info((Object)String.format("Invalid value used for %s - %s. Use value configurated for branch detection - %s", SystemProperty.PULL_REQUEST_POLLING_INTERVAL.getKey(), String.valueOf(SystemProperty.PULL_REQUEST_POLLING_INTERVAL.getTypedValue()), String.valueOf(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBranchDetectionCheckInterval())));
            }
            prDetectionCheckInterval = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBranchDetectionCheckInterval();
        } else {
            prDetectionCheckInterval = (int)SystemProperty.PULL_REQUEST_POLLING_INTERVAL.getTypedValue();
        }
        JobDetail jobDetail = JobBuilder.newJob(PullRequestDetectionJob.class).withIdentity(JOB_KEY).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)prDetectionCheckInterval)).withIdentity(PR_DETECTION).build();
        this.scheduler.getListenerManager().addTriggerListener(PreventJobExecutionUntilCompletedTriggerListener.INSTANCE, (Matcher)KeyMatcher.keyEquals((Key)trigger.getKey()));
        log.info((Object)("Pull request detection running every " + prDetectionCheckInterval + "s."));
        this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public void reschedulePullRequestDetecting() throws SchedulerException {
        this.scheduler.deleteJob(JOB_KEY);
        this.schedulePullRequestDetecting();
    }
}

