/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.ItemDetections;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionService;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetector;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestService;
import com.atlassian.bamboo.repository.RepositoryCachingFacade;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class PullRequestDetectionServiceImpl
implements PullRequestDetectionService {
    private static final Logger log = Logger.getLogger(PullRequestDetectionServiceImpl.class);
    private static final int THREAD_POOL_SIZE = (int)SystemProperty.PULL_REQUEST_DETECTION_THREAD_COUNT.getTypedValue();
    private final CachedPlanManager cachedPlanManager;
    private final CustomVariableContext customVariableContext;
    private final ErrorHandler errorHandler;
    private final HibernateTemplate hibernateTemplate;
    private final RepositoryCachingFacade repositoryCachingFacade;
    private final ScopedExclusionService scopedExclusionService;
    private final VcsPullRequestService vcsPullRequestService;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final ItemDetections pullRequestDetections = new ItemDetections();

    @Inject
    public PullRequestDetectionServiceImpl(CachedPlanManager cachedPlanManager, CustomVariableContext customVariableContext, ErrorHandler errorHandler, HibernateTemplate hibernateTemplate, RepositoryCachingFacade repositoryCachingFacade, ScopedExclusionService scopedExclusionService, VcsPullRequestService vcsPullRequestService, VcsRepositoryManager vcsRepositoryManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.customVariableContext = customVariableContext;
        this.errorHandler = errorHandler;
        this.hibernateTemplate = hibernateTemplate;
        this.scopedExclusionService = scopedExclusionService;
        this.repositoryCachingFacade = repositoryCachingFacade;
        this.vcsPullRequestService = vcsPullRequestService;
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    @PostConstruct
    public void startPullRequestDetection() {
        if (!SystemProperty.DISABLE_BRANCH_DETECTION.getValue(false)) {
            SystemAuthorityThreadFactory threadFactory = new SystemAuthorityThreadFactory("PullRequestDetectionBackgroundThread");
            for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
                PullRequestDetector detector = new PullRequestDetector(this.pullRequestDetections, this.hibernateTemplate, this.cachedPlanManager, this.scopedExclusionService, this.vcsRepositoryManager, this.errorHandler, this, this.vcsPullRequestService);
                threadFactory.newThread((Runnable)detector).start();
            }
        }
    }

    public boolean schedulePullRequestDetectionForChain(@NotNull ImmutableChain chain) {
        return this.pullRequestDetections.queue(chain.getPlanKey());
    }

    @NotNull
    public List<VcsPullRequest> getOpenPullRequests(@NotNull ImmutableChain chain, @NotNull VcsRepositoryData planRepositoryDefinition) throws Exception {
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(planRepositoryDefinition.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsPullRequestDetection()) {
            return Collections.emptyList();
        }
        VcsPullRequestDetector pullRequestDetector = moduleDescriptor.getPullRequestDetector();
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan((ImmutablePlan)chain);
        List pullRequests = (List)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> new ArrayList(this.repositoryCachingFacade.getOpenPullRequests(pullRequestDetector, planRepositoryDefinition)));
        if (log.isTraceEnabled() && !pullRequests.isEmpty()) {
            log.trace((Object)String.format("Found following PRs for plan %s", chain.getPlanKey()));
            pullRequests.forEach(pullRequest -> log.trace((Object)pullRequest.toString()));
        }
        return pullRequests;
    }
}

