/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.ItemDetections;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionService;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestService;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsPullRequestDetector;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateTemplate;

class PullRequestDetector
implements Runnable {
    private static final Logger log = Logger.getLogger(PullRequestDetector.class);
    private final CachedPlanManager cachedPlanManager;
    private final ErrorHandler errorHandler;
    private final ItemDetections pullRequestDetections;
    private final HibernateTemplate hibernateTemplate;
    private final ScopedExclusionService scopedExclusionService;
    private final PullRequestDetectionService service;
    private final VcsPullRequestService vcsPullRequestService;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final BambooPluginUtils.Runnable detectionLoop = new BambooPluginUtils.Runnable("An unexpected error has occurred while detecting pull requests"){
        private volatile PlanKey planKey;

        @Override
        public void run() {
            this.planKey = PullRequestDetector.this.pullRequestDetections.getDetectionRequest();
            try {
                PullRequestDetector.this.hibernateTemplate.execute(session -> {
                    PlanRepositoryDefinition planRepositoryDefinition;
                    ImmutableChain chain = (ImmutableChain)PullRequestDetector.this.cachedPlanManager.getPlanByKey(this.planKey, ImmutableChain.class);
                    if (chain != null && (planRepositoryDefinition = (PlanRepositoryDefinition)PullRequestDetector.this.scopedExclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.REPOSITORY_DATA, (Object)this.planKey, ScopedExclusionServiceHelper.adapt(() -> PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain)))) != null) {
                        try {
                            PullRequestDetector.this.processChangedPullRequests(chain, (VcsRepositoryData)planRepositoryDefinition);
                        }
                        catch (Exception e) {
                            log.warn((Object)e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                    return null;
                });
            }
            finally {
                PullRequestDetector.this.pullRequestDetections.end(this.planKey);
            }
        }

        @Override
        public String getErrorMessage() {
            return super.getErrorMessage() + ": " + this.planKey;
        }

        @Override
        public void onThrow(@NotNull Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    };

    PullRequestDetector(ItemDetections pullRequestDetections, HibernateTemplate hibernateTemplate, CachedPlanManager cachedPlanManager, ScopedExclusionService scopedExclusionService, VcsRepositoryManager vcsRepositoryManager, ErrorHandler errorHandler, PullRequestDetectionService service, VcsPullRequestService vcsPullRequestService) {
        this.pullRequestDetections = pullRequestDetections;
        this.hibernateTemplate = hibernateTemplate;
        this.cachedPlanManager = cachedPlanManager;
        this.scopedExclusionService = scopedExclusionService;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.errorHandler = errorHandler;
        this.service = service;
        this.vcsPullRequestService = vcsPullRequestService;
    }

    private void processChangedPullRequests(@NotNull ImmutableChain chain, @NotNull VcsRepositoryData defaultRepository) throws Exception {
        boolean pullRequestWorkflowEnabled;
        boolean bl = pullRequestWorkflowEnabled = chain.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow() == PlanBranchWorkflow.PULL_REQUEST_WORKFLOW;
        if (!pullRequestWorkflowEnabled) {
            log.debug((Object)String.format("Not processing pull requests for chain '%s' because it is not configured for pull request workflow. Workflow is %s", chain.getKey(), chain.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow()));
            return;
        }
        VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepository.getPluginKey());
        if (moduleDescriptor == null || !moduleDescriptor.supportsPullRequestDetection()) {
            return;
        }
        VcsPullRequestDetector pullRequestDetector = moduleDescriptor.getPullRequestDetector();
        if (pullRequestDetector == null) {
            String errorMessage = String.format("Can't detect pull requests for plan %s - its default repository does not support pull request detection", chain.getKey());
            log.info((Object)this.addErrorLog(chain, errorMessage, this.errorHandler));
            return;
        }
        if (this.skipPolling(defaultRepository, pullRequestDetector)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Skipping generic PR detection - repository does it on it's own: %s, (called from plan: %s)", defaultRepository.getName(), chain.getPlanKey()));
            }
            return;
        }
        List openPullRequests = this.service.getOpenPullRequests(chain, defaultRepository);
        this.detectPullRequestStatus(openPullRequests, defaultRepository.getRootVcsRepositoryId());
    }

    private boolean skipPolling(@NotNull VcsRepositoryData repositoryData, VcsPullRequestDetector pullRequestDetector) {
        return !SystemProperty.ENFORCE_POLLING_BRANCH_DETECTION_EVEN_WHEN_REPO_CAN_PUSH_IT.getTypedValue() && !pullRequestDetector.usePollingForPullRequestDetection(repositoryData);
    }

    @VisibleForTesting
    void detectPullRequestStatus(@NotNull List<VcsPullRequest> openPullRequests, long targetRepositoryId) {
        for (VcsPullRequest pr : openPullRequests) {
            VcsPullRequest existingPr = this.vcsPullRequestService.findByRepositoryAndKey(targetRepositoryId, pr.getKey());
            if (existingPr == null) {
                this.vcsPullRequestService.createPullRequest(pr.getKey(), pr.getSourceRepositoryId(), pr.getSource(), pr.getTargetRepositoryId(), pr.getTarget(), pr.isOpen());
                continue;
            }
            if (existingPr.equals(pr)) continue;
            if (existingPr.getTargetRepositoryId() != pr.getTargetRepositoryId()) {
                log.error((Object)String.format("Updating target repository is not supported for pull requests (id: %d, key: %s, target repository: %d > %d)", existingPr.getId(), existingPr.getKey(), existingPr.getTargetRepositoryId(), pr.getTargetRepositoryId()));
            }
            this.vcsPullRequestService.updatePullRequest(existingPr, pr.getSourceRepositoryId(), pr.getSource(), pr.getTarget(), pr.isOpen());
        }
        this.vcsPullRequestService.closePullRequestsClosedInRepository(targetRepositoryId, openPullRequests);
    }

    private String addErrorLog(ImmutableChain chain, String message, ErrorHandler errorHandler) {
        errorHandler.recordError((Key)chain.getPlanKey(), message);
        return message;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            BambooPluginUtils.callUnsafeCode(this.detectionLoop);
        }
    }
}

