/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinitionImpl;
import com.atlassian.bamboo.build.PlanBranchPullRequest;
import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.BranchDetectionService;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfigurationImpl;
import com.atlassian.bamboo.plan.branch.BranchIntegrationPointImpl;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.PlanBranchWorkflow;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.event.VcsPullRequestCreatedEvent;
import com.atlassian.bamboo.plan.pullrequest.event.VcsPullRequestUpdatedEvent;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.v2.events.ChangeDetectionRequiredEvent;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class PullRequestWorkflowEventListener {
    private static final Logger log = Logger.getLogger(PullRequestWorkflowEventListener.class);
    @Inject
    @Lazy
    private BranchDetectionService branchDetectionService;
    private final BuildDefinitionConverter buildDefinitionConverter;
    private final BuildDefinitionManager buildDefinitionManager;
    private final CachedPlanManager cachedPlanManager;
    private final ChainBranchManager chainBranchManager;
    private final EventPublisher eventPublisher;
    private final PlanBranchPullRequestService planBranchPullRequestService;
    private final PlanManager planManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    private final ScopedExclusionService scopedExclusionService;
    private final TriggerTypeManager triggerTypeManager;
    private final VcsRepositoryManager vcsRepositoryManager;

    @Inject
    public PullRequestWorkflowEventListener(BuildDefinitionConverter buildDefinitionConverter, BuildDefinitionManager buildDefinitionManager, CachedPlanManager cachedPlanManager, ChainBranchManager chainBranchManager, EventPublisher eventPublisher, PlanBranchPullRequestService planBranchPullRequestService, PlanManager planManager, RepositoryDefinitionManager repositoryDefinitionManager, CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager, ScopedExclusionService scopedExclusionService, TriggerTypeManager triggerTypeManager, VcsRepositoryManager vcsRepositoryManager) {
        this.buildDefinitionConverter = buildDefinitionConverter;
        this.cachedPlanManager = cachedPlanManager;
        this.chainBranchManager = chainBranchManager;
        this.eventPublisher = eventPublisher;
        this.planBranchPullRequestService = planBranchPullRequestService;
        this.planManager = planManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.cachedRepositoryDefinitionManager = cachedRepositoryDefinitionManager;
        this.scopedExclusionService = scopedExclusionService;
        this.triggerTypeManager = triggerTypeManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.buildDefinitionManager = buildDefinitionManager;
    }

    @EventListener
    public void onPullRequestCreated(@NotNull VcsPullRequestCreatedEvent event) {
        VcsPullRequest pullRequest = event.getPullRequest();
        long repositoryId = pullRequest.getTargetRepositoryId();
        log.debug((Object)String.format("Received pull request creation event (id: %d, key: %s, repository: %d, source: %s, target: %s)", pullRequest.getId(), pullRequest.getKey(), repositoryId, pullRequest.getSource(), pullRequest.getTarget()));
        if (!pullRequest.isOpen()) {
            log.debug((Object)"Ignoring pull request creation event, as the pull request is already closed/merged");
            return;
        }
        if (!Objects.equals(pullRequest.getSourceRepositoryId(), pullRequest.getTargetRepositoryId())) {
            log.warn((Object)"PR source repository is not the same as target repository. Bamboo doesn't support PRs from fork.");
            return;
        }
        List<ImmutableTopLevelPlan> plansUsingRepositoryAndPrWorkflow = this.getPlansUsingRepositoryAndPrWorkflow(repositoryId);
        log.debug((Object)String.format("Found %d chains using repository with id %d and pull requests workflow, creating plan branches", plansUsingRepositoryAndPrWorkflow.size(), repositoryId));
        plansUsingRepositoryAndPrWorkflow.forEach(chain -> this.createPlanBranchForPullRequest((ImmutableTopLevelPlan)chain, pullRequest));
    }

    @EventListener
    public void onPullRequestUpdated(@NotNull VcsPullRequestUpdatedEvent event) {
        boolean openStateChanged;
        VcsPullRequest pullRequestBefore = event.getPullRequestBeforeChanges();
        VcsPullRequest pullRequestAfter = event.getPullRequestAfterChanges();
        long repositoryId = pullRequestAfter.getTargetRepositoryId();
        log.debug((Object)String.format("Received pull request updated event (id: %d, key: %s, repository: %d, source: %s, target: %s > %s, state: %s > %s)", pullRequestBefore.getId(), pullRequestBefore.getKey(), repositoryId, pullRequestBefore.getSource(), pullRequestBefore.getTarget(), pullRequestAfter.getTarget(), pullRequestBefore.isOpen() ? "open" : "closed", pullRequestAfter.isOpen() ? "open" : "closed"));
        boolean sourceChanged = !Objects.equals(pullRequestBefore.getSource(), pullRequestAfter.getSource());
        boolean targetChanged = !Objects.equals(pullRequestBefore.getTarget(), pullRequestAfter.getTarget());
        boolean bl = openStateChanged = pullRequestBefore.isOpen() != pullRequestAfter.isOpen();
        if (sourceChanged || targetChanged) {
            this.planBranchPullRequestService.findForPullRequest(pullRequestAfter.getId()).forEach(affectedPlan -> this.updateIntegrationBranch(affectedPlan.getChainBranch(), pullRequestAfter.getTarget()));
        }
        if (openStateChanged) {
            if (pullRequestBefore.isOpen()) {
                log.debug((Object)"Pull request was closed, disabling all plan branches");
                this.disablePlanBranchesForPullRequest(pullRequestAfter);
            } else {
                log.debug((Object)"Pull request was re-opened, re-enabling and re-creating plan branches");
                List<ImmutableTopLevelPlan> plansUsingRepositoryAndPrWorkflow = this.getPlansUsingRepositoryAndPrWorkflow(repositoryId);
                log.debug((Object)String.format("Found %d chains using repository with id %d and pull requests workflow, re-enabling and re-creating plan branches", plansUsingRepositoryAndPrWorkflow.size(), repositoryId));
                plansUsingRepositoryAndPrWorkflow.forEach(chain -> this.createOrEnablePlanBranchForPullRequest((ImmutableTopLevelPlan)chain, pullRequestAfter));
            }
        } else {
            log.debug((Object)"No actual changes detected, doing nothing");
        }
    }

    private void updateIntegrationBranch(ImmutableChainBranch chainBranch, String integrationBranch) {
        log.debug((Object)("Update integration branch for " + chainBranch.getPlanKey() + ", new integration branch is " + integrationBranch));
        BuildDefinition branchBuildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(chainBranch.getPlanKey());
        BranchIntegrationConfigurationImpl branchIntegrationConfiguration = new BranchIntegrationConfigurationImpl(branchBuildDefinition.getBranchIntegrationConfiguration(), false);
        branchIntegrationConfiguration.setBranchIntegrationPoint(BranchIntegrationPointImpl.forVcsReference(integrationBranch));
        branchBuildDefinition.setBranchIntegrationConfiguration((BranchIntegrationConfiguration)branchIntegrationConfiguration);
        this.buildDefinitionManager.savePlanAndDefinition(this.planManager.getPlanByKey(chainBranch.getPlanKey()), branchBuildDefinition);
    }

    private void createOrEnablePlanBranchForPullRequest(@NotNull ImmutableTopLevelPlan chain, @NotNull VcsPullRequest pullRequest) {
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chain.getPlanKey(), chainKey -> {
            log.debug((Object)String.format("Determining whether plan branch should be created or re-enabled for plan %s and pull request %d (key: %s)", chainKey, pullRequest.getId(), pullRequest.getKey()));
            Optional<ImmutableChainBranch> existingPlanBranch = this.planBranchPullRequestService.findForChainAndPullRequest(chain.getId(), pullRequest.getId()).map(PlanBranchPullRequest::getChainBranch);
            if (existingPlanBranch.isPresent()) {
                ImmutableChainBranch planBranch = existingPlanBranch.get();
                if (planBranch.isSuspendedFromBuilding()) {
                    log.debug((Object)String.format("A plan branch %s exists and is suspended from building, re-enabling", planBranch.getPlanKey()));
                    this.planManager.setPlanSuspendedState(planBranch.getPlanKey(), false);
                    planBranch.getTriggerDefinitions().stream().filter(triggerDefinition -> this.shouldFireChangeDetectionEvent((TriggerDefinition)triggerDefinition, planBranch)).map(triggerDefinition -> this.createChangeDetectionEvent((TriggerDefinition)triggerDefinition, planBranch.getPlanKey())).peek(event -> log.debug((Object)String.format("Publishing change detection event for plan %s and trigger %s", event.getPlanKey(), event.getTrigger().getName()))).forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
                } else {
                    log.debug((Object)String.format("A plan branch %s exists and is not suspended from building, doing nothing", planBranch.getPlanKey()));
                }
            } else {
                this.createPlanBranchForPullRequest(chain, pullRequest);
            }
            return null;
        });
    }

    private boolean shouldFireChangeDetectionEvent(@NotNull TriggerDefinition triggerDefinition, @NotNull ImmutableChainBranch planBranch) {
        if (triggerDefinition.isEnabled() && !triggerDefinition.getTriggeringRepositories().isEmpty()) {
            TriggerModuleDescriptor triggerDescriptor = this.triggerTypeManager.getTriggerDescriptor(triggerDefinition.getPluginKey());
            return triggerDescriptor != null && triggerDescriptor.canTrigger((Triggerable)planBranch);
        }
        return false;
    }

    @NotNull
    private ChangeDetectionRequiredEvent createChangeDetectionEvent(@NotNull TriggerDefinition triggerDefinition, @NotNull PlanKey planKey) {
        return new ChangeDetectionRequiredEvent(this, planKey, triggerDefinition, true, CacheAwareness.CHANGE_DETECTION);
    }

    private void createPlanBranchForPullRequest(@NotNull ImmutableTopLevelPlan chain, @NotNull VcsPullRequest pullRequest) {
        ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, chain.getPlanKey(), chainKey -> {
            log.debug((Object)String.format("Attempting to create plan branch for plan %s and pull request %d (key: %s)", chain.getPlanKey(), pullRequest.getId(), pullRequest.getKey()));
            PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
            if (repositoryDefinition == null) {
                log.debug((Object)("Couldn't find default repository for plan " + chain.getPlanKey()));
                return null;
            }
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
            if (moduleDescriptor == null) {
                log.debug((Object)("Couldn't find module descriptor for repository with key " + repositoryDefinition.getPluginKey()));
                return null;
            }
            VcsBranchConfigurator vcsBranchConfigurator = moduleDescriptor.getVcsBranchConfigurator();
            if (vcsBranchConfigurator == null) {
                log.debug((Object)("Can't create plan branches based on pull requests for repositories which are not branch-aware, repository id: " + pullRequest.getTargetRepositoryId()));
                return null;
            }
            VcsBranch vcsBranch = vcsBranchConfigurator.createVcsBranchFromName(pullRequest.getSource());
            try {
                this.branchDetectionService.createOrEnableChainBranch((ImmutableChain)chain, PlanBranchWorkflow.PULL_REQUEST_WORKFLOW, vcsBranch, this.getBuildConfiguration(chain.getPlanKey(), pullRequest.getTarget()), PlanCreationService.EnablePlan.ENABLED, true, planKey -> this.planBranchPullRequestService.create(planKey, pullRequest.getId()));
            }
            catch (PlanCreationDeniedException e) {
                log.warn((Object)("Chain branch creation denied: " + e.getMessage()), (Throwable)e);
                return null;
            }
            return null;
        });
    }

    @Nullable
    @VisibleForTesting
    BuildConfiguration getBuildConfiguration(@NotNull PlanKey planKey, @NotNull String vcsBranchName) {
        BuildDefinition masterPlanBuildDefinition = this.buildDefinitionManager.getUnmergedBuildDefinition(planKey);
        BranchIntegrationConfiguration masterPlanBranchIntegrationConfiguration = masterPlanBuildDefinition.getBranchMonitoringConfiguration().getDefaultBranchIntegrationConfiguration();
        if (masterPlanBranchIntegrationConfiguration.isEnabled()) {
            BranchIntegrationConfigurationImpl planBranchIntegrationConfiguration = new BranchIntegrationConfigurationImpl(masterPlanBranchIntegrationConfiguration, false);
            planBranchIntegrationConfiguration.setBranchIntegrationPoint(BranchIntegrationPointImpl.forVcsReference(vcsBranchName));
            PartialBuildDefinitionImpl buildDefinition = new PartialBuildDefinitionImpl();
            buildDefinition.setBranchIntegrationConfiguration(planBranchIntegrationConfiguration);
            return new BuildConfiguration(ConfigUtils.asXmlString((XMLConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition)));
        }
        return null;
    }

    private void disablePlanBranchesForPullRequest(@NotNull VcsPullRequest pullRequest) {
        List planBranchPullRequestLinks = this.planBranchPullRequestService.findForPullRequest(pullRequest.getId());
        log.debug((Object)String.format("Disabling %d plan branches for pull request %d (key: %s)", planBranchPullRequestLinks.size(), pullRequest.getId(), pullRequest.getKey()));
        planBranchPullRequestLinks.stream().map(PlanBranchPullRequest::getChainBranch).forEach(chainBranch -> this.planManager.setPlanSuspendedState(chainBranch.getPlanKey(), true));
    }

    @NotNull
    @VisibleForTesting
    List<ImmutableTopLevelPlan> getPlansUsingRepositoryAndPrWorkflow(long repositoryId) {
        VcsRepositoryData repository = this.cachedRepositoryDefinitionManager.getVcsRepositoryData(repositoryId);
        if (repository == null) {
            log.debug((Object)String.format("Repository with id %d not found, can't proceed", repositoryId));
            return Collections.emptyList();
        }
        long rootRepositoryId = repository.getRootVcsRepositoryId();
        List plansUsingRepository = repository.isRootVcsLinked() ? this.repositoryDefinitionManager.getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(rootRepositoryId) : this.repositoryDefinitionManager.getIdentifiersOfPlansUsingRepository(rootRepositoryId);
        return plansUsingRepository.stream().map(this::chainIdentifierToChain).filter(Objects::nonNull).filter(this::chainUsesPullRequestWorkflow).filter(chain -> this.repositoryIsDefaultForChain(rootRepositoryId, (ImmutableTopLevelPlan)chain)).collect(Collectors.toList());
    }

    @Nullable
    private ImmutableTopLevelPlan chainIdentifierToChain(@NotNull PlanIdentifier chainIdentifier) {
        return (ImmutableTopLevelPlan)this.cachedPlanManager.getPlanByKeyIfOfType(chainIdentifier.getPlanKey(), ImmutableTopLevelPlan.class);
    }

    private boolean chainUsesPullRequestWorkflow(@NotNull ImmutableTopLevelPlan chain) {
        return chain.getBuildDefinition().getBranchMonitoringConfiguration().getPlanBranchWorkflow() == PlanBranchWorkflow.PULL_REQUEST_WORKFLOW;
    }

    private boolean repositoryIsDefaultForChain(long rootRepoId, @NotNull ImmutableTopLevelPlan chain) {
        PlanRepositoryDefinition defaultRepo = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        return defaultRepo != null && defaultRepo.getRootVcsRepositoryId() == rootRepoId;
    }
}

