/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RemovePullRequestsJob
implements Job {
    private static final Logger log = Logger.getLogger(RemovePullRequestsJob.class);
    @VisibleForTesting
    static final int LIMIT = 1000;
    @Inject
    private VcsPullRequestDao vcsPullRequestDao;
    @Inject
    private PlanBranchPullRequestService planBranchPullRequestService;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info((Object)"Starting RemovePullRequestsJob...");
        this.removeInactiveClosedPullRequestsWithoutPlanBranches();
        this.removeOrphanedPullRequests();
        log.info((Object)"Job RemovePullRequestsJob is complete");
    }

    private void removeInactiveClosedPullRequestsWithoutPlanBranches() {
        log.info((Object)"Starting removal of inactive closed pull requests");
        Stopwatch stopwatch = Stopwatch.createStarted();
        int[] removedCounter = new int[]{0};
        long startPrId = 0L;
        List closedPRs = this.vcsPullRequestDao.findByStatus(false, 0L, 1000);
        while (closedPRs.size() != 0) {
            log.debug((Object)("Found " + closedPRs.size() + " closed PRs"));
            for (MutableVcsPullRequest pr : closedPRs) {
                if (this.shouldBeRemoved((VcsPullRequest)pr)) {
                    log.debug((Object)("Remove PR: " + pr));
                    this.vcsPullRequestDao.delete((BambooObject)pr);
                    removedCounter[0] = removedCounter[0] + 1;
                }
                startPrId = pr.getId();
            }
            if (closedPRs.size() < 1000) break;
            closedPRs = this.vcsPullRequestDao.findByStatus(false, startPrId, 1000);
        }
        stopwatch.stop();
        log.info((Object)("Finished removal of inactive closed pull requests. It took " + stopwatch + ". Removed " + removedCounter[0] + " PRs"));
    }

    private void removeOrphanedPullRequests() throws JobExecutionException {
        log.info((Object)"Starting removal of orphaned pull requests");
        Stopwatch stopwatch = Stopwatch.createStarted();
        long count = this.vcsPullRequestDao.removeOrphanedPullRequests();
        stopwatch.stop();
        log.info((Object)("Finished removal of orphaned pull requests. It took " + stopwatch + ". Removed " + count + " PRs"));
    }

    private boolean shouldBeRemoved(VcsPullRequest pr) {
        return this.isStale(pr) && this.isOrphanedByPlanBranch(pr);
    }

    private boolean isStale(VcsPullRequest pr) {
        Instant lastModificationDate = Instant.ofEpochMilli(pr.getLastModificationDate().getTime());
        long durationInDays = Duration.between(lastModificationDate, Instant.now()).toDays();
        return durationInDays >= SystemProperty.ORPHANED_PULL_REQUEST_INACTIVITY_DAYS.getTypedValue();
    }

    private boolean isOrphanedByPlanBranch(@NotNull VcsPullRequest pr) {
        return this.planBranchPullRequestService.findForPullRequest(pr.getId()).isEmpty();
    }
}

