/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.plan.pullrequest.RemovePullRequestsJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.utils.SystemProperty;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class RemovePullRequestsJobScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(RemovePullRequestsJobScheduler.class);
    private static final String REMOVE_PULL_REQUESTS_JOB = "removePullRequestsJob";
    private static final String REMOVE_PULL_REQUESTS_GROUP = "removePullRequestsGroup";
    private static final JobKey JOB_KEY = new JobKey("removePullRequestsJob", "removePullRequestsGroup");
    private static final String REMOVE_PULL_REQUESTS_TRIGGER = "removePullRequestsTrigger";
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("removePullRequestsTrigger", "removePullRequestsGroup");
    private static final String DEFAULT_CRON_EXPRESSION = "0 0 0 7,17,27 * ?";
    private final Scheduler quartzScheduler;

    @Inject
    public RemovePullRequestsJobScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        this.unschedule();
        this.schedule();
    }

    private void unschedule() {
        try {
            this.quartzScheduler.unscheduleJob(TRIGGER_KEY);
        }
        catch (Exception e) {
            log.warn((Object)"Unable to unschedule removePullRequestsJob", (Throwable)e);
        }
    }

    private void schedule() {
        try {
            JobDetail jobDetail = JobBuilder.newJob(RemovePullRequestsJob.class).withIdentity(JOB_KEY).build();
            String cronExpressionStr = SystemProperty.ORPHANED_PULL_REQUESTS_CLEANUP_SCHEDULE.getValue(DEFAULT_CRON_EXPRESSION);
            CronExpression cronExpression = new CronExpression(cronExpressionStr);
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).forJob(JOB_KEY).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            log.info((Object)("Used '" + cronExpressionStr + "' to schedule RemovePullRequestsJob. Next trigger time " + cronTrigger.getNextFireTime()));
        }
        catch (Exception e) {
            log.error((Object)"Unable to schedule removePullRequestsJob", (Throwable)e);
        }
    }
}

