/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.plan.pullrequest.MutableVcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.core.bean.EntityObject;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="VCS_PULL_REQUEST")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class VcsPullRequestImpl
extends EntityObject
implements MutableVcsPullRequest {
    private String key;
    private Long sourceRepositoryId;
    private String source;
    private long targetRepositoryId;
    private String target;
    private boolean open;

    public VcsPullRequestImpl() {
    }

    public VcsPullRequestImpl(VcsPullRequest pullRequest) {
        this.setId(pullRequest.getId());
        this.key = pullRequest.getKey();
        this.sourceRepositoryId = pullRequest.getSourceRepositoryId();
        this.source = pullRequest.getSource();
        this.targetRepositoryId = pullRequest.getTargetRepositoryId();
        this.target = pullRequest.getTarget();
        this.open = pullRequest.isOpen();
        this.setCreationDate(pullRequest.getCreationDate());
        this.setLastModificationDate(pullRequest.getLastModificationDate());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String vcsPullRequestKey) {
        this.key = vcsPullRequestKey;
    }

    public Long getSourceRepositoryId() {
        return this.sourceRepositoryId;
    }

    public void setSourceRepositoryId(Long sourceRepositoryId) {
        this.sourceRepositoryId = sourceRepositoryId;
    }

    public long getTargetRepositoryId() {
        return this.targetRepositoryId;
    }

    public void setTargetRepositoryId(long targetRepositoryId) {
        this.targetRepositoryId = targetRepositoryId;
    }

    @NotNull
    public String getSource() {
        return this.source;
    }

    public void setSource(@NotNull String source) {
        this.source = source;
    }

    @NotNull
    public String getTarget() {
        return this.target;
    }

    public void setTarget(@NotNull String target) {
        this.target = target;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VcsPullRequestImpl that = (VcsPullRequestImpl)((Object)o);
        return Objects.equals(this.key, that.key) && this.targetRepositoryId == that.targetRepositoryId && this.open == that.open && Objects.equals(this.sourceRepositoryId, that.sourceRepositoryId) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.getKey(), this.getSourceRepositoryId(), this.getTargetRepositoryId(), this.getSource(), this.getTarget(), this.isOpen());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("sourceRepositoryId", (Object)this.sourceRepositoryId).append("source", (Object)this.source).append("targetRepositoryId", this.targetRepositoryId).append("target", (Object)this.target).append("open", this.open).toString();
    }
}

