/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.pullrequest;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequest;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestDao;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestImpl;
import com.atlassian.bamboo.plan.pullrequest.VcsPullRequestService;
import com.atlassian.bamboo.plan.pullrequest.event.VcsPullRequestCreatedEvent;
import com.atlassian.bamboo.plan.pullrequest.event.VcsPullRequestUpdatedEvent;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.collection.PartialList;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPullRequestServiceImpl
implements VcsPullRequestService {
    private static final Logger log = Logger.getLogger(VcsPullRequestServiceImpl.class);
    private final EventPublisher eventPublisher;
    private final VcsPullRequestDao vcsPullRequestDao;

    @Inject
    public VcsPullRequestServiceImpl(EventPublisher eventPublisher, VcsPullRequestDao vcsPullRequestDao) {
        this.eventPublisher = eventPublisher;
        this.vcsPullRequestDao = vcsPullRequestDao;
    }

    public VcsPullRequest findByRepositoryAndKey(long targetRepositoryId, @NotNull String pullRequestKey) {
        return this.vcsPullRequestDao.findByRepositoryAndKey(targetRepositoryId, pullRequestKey);
    }

    public List<VcsPullRequest> findOpenByRepository(long targetRepositoryId) {
        return this.vcsPullRequestDao.findByRepository(targetRepositoryId, true).stream().map(VcsPullRequestImpl::new).collect(Collectors.toList());
    }

    public void closePullRequest(@NotNull VcsPullRequest pr) {
        VcsPullRequestImpl pullRequest = (VcsPullRequestImpl)((Object)Narrow.downTo((Object)this.vcsPullRequestDao.findById(pr.getId()), VcsPullRequestImpl.class));
        Preconditions.checkArgument((pullRequest != null ? 1 : 0) != 0, (Object)("Can't find VcsPullRequest by id " + pr.getId()));
        pullRequest.setOpen(false);
        this.vcsPullRequestDao.save((BambooObject)pullRequest);
        this.triggerPullRequestClosedEvent((VcsPullRequest)pullRequest);
    }

    @NotNull
    public VcsPullRequest createPullRequest(@NotNull String pullRequestKey, @Nullable Long sourceRepositoryId, @NotNull String source, long targetRepositoryId, @NotNull String target, boolean isOpen) {
        log.debug((Object)String.format("Create pull request %s in repository %d", pullRequestKey, targetRepositoryId));
        VcsPullRequestImpl pullRequest = new VcsPullRequestImpl();
        pullRequest.setKey(pullRequestKey);
        pullRequest.setSourceRepositoryId(sourceRepositoryId);
        pullRequest.setSource(source);
        pullRequest.setTargetRepositoryId(targetRepositoryId);
        pullRequest.setTarget(target);
        pullRequest.setOpen(isOpen);
        this.vcsPullRequestDao.save((BambooObject)pullRequest);
        VcsPullRequestImpl detachedEntity = new VcsPullRequestImpl((VcsPullRequest)pullRequest);
        this.eventPublisher.publish((Object)new VcsPullRequestCreatedEvent((VcsPullRequest)detachedEntity));
        return detachedEntity;
    }

    public void updatePullRequest(@NotNull VcsPullRequest pr, Long sourceRepositoryId, @NotNull String source, @NotNull String target, boolean isOpen) {
        VcsPullRequestImpl pullRequest;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Update pull request %d: %d [%s]->[%s] (%s)", pr.getId(), sourceRepositoryId, source, target, isOpen ? "open" : "closed"));
        }
        Preconditions.checkArgument(((pullRequest = (VcsPullRequestImpl)((Object)Narrow.downTo((Object)this.vcsPullRequestDao.findById(pr.getId()), VcsPullRequestImpl.class))) != null ? 1 : 0) != 0, (Object)"Can't modify VcsPullRequest as it's immutable");
        VcsPullRequestImpl pullRequestBeforeChanges = new VcsPullRequestImpl((VcsPullRequest)pullRequest);
        pullRequest.setSourceRepositoryId(sourceRepositoryId);
        pullRequest.setSource(source);
        pullRequest.setTarget(target);
        pullRequest.setOpen(isOpen);
        this.vcsPullRequestDao.save((BambooObject)pullRequest);
        this.eventPublisher.publish((Object)new VcsPullRequestUpdatedEvent((VcsPullRequest)pullRequestBeforeChanges, (VcsPullRequest)new VcsPullRequestImpl((VcsPullRequest)pullRequest)));
    }

    public void closePullRequestsClosedInRepository(long targetRepositoryId, @NotNull List<VcsPullRequest> openPullRequests) {
        PartialList closedPullRequests;
        boolean finished;
        Set openPrKeys = openPullRequests.stream().map(VcsPullRequest::getKey).collect(Collectors.toSet());
        do {
            closedPullRequests = this.vcsPullRequestDao.closePullRequestsClosedInRepository(targetRepositoryId, openPrKeys);
            closedPullRequests.getList().forEach(this::triggerPullRequestClosedEvent);
        } while (!(finished = closedPullRequests.isCompleteList()));
    }

    private void triggerPullRequestClosedEvent(@NotNull VcsPullRequest pullRequest) {
        Preconditions.checkArgument((!pullRequest.isOpen() ? 1 : 0) != 0, (String)"pull request with ID %s is still marked as open", (Object[])new Object[]{pullRequest.getId()});
        VcsPullRequestImpl pullRequestBeforeChanges = new VcsPullRequestImpl(pullRequest);
        pullRequestBeforeChanges.setOpen(true);
        this.eventPublisher.publish((Object)new VcsPullRequestUpdatedEvent((VcsPullRequest)pullRequestBeforeChanges, (VcsPullRequest)new VcsPullRequestImpl(pullRequest)));
    }
}

