/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.stage;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.JobStatusHelper;
import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.core.ScopedExclusionServiceHelper;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.ChainPropagatingFacade;
import com.atlassian.bamboo.plan.branch.ChainStagePropagatingFacade;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.stage.StageService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooClosures;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.NameProviderFunctions;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.struts.TextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StageServiceImpl
implements StageService {
    private static final Logger log = Logger.getLogger(StageServiceImpl.class);
    private static final String STAGE_NAME = "name";
    private static final String STAGE_DESCRIPTION = "description";
    @Inject
    private AuditLogService auditLogService;
    @Inject
    private BambooPermissionManager bambooPermissionManager;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private ChainBranchManager chainBranchManager;
    @Inject
    private DeletionService deletionService;
    @Inject
    private PlanManager planManager;
    @Inject
    private TextProvider textProvider;
    @Inject
    private ValidationService validationService;
    @Inject
    private BuildExecutionManager buildExecutionManager;
    @Inject
    private ScopedExclusionService scopedExclusionService;
    @Inject
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private TransactionAndHibernateTemplate transactionTemplate;
    @Inject
    private EventPublisher eventPublisher;

    @NotNull
    public List<ImmutableChainStage> getStagesForPlan(@NotNull PlanKey planKey) {
        ImmutableChain chain = this.getAndValidateIsWritableChain(planKey);
        return ImmutableList.copyOf((Collection)chain.getStages());
    }

    @NotNull
    public ImmutableChainStage getStage(@NotNull PlanKey planKey, long stageId) throws WebValidationException {
        ImmutableChain chain = this.getAndValidateIsWritableChain(planKey);
        return this.getStage(chain, stageId);
    }

    @NotNull
    public ErrorCollection validateStageForAdd(@NotNull PlanKey planKey, @Nullable String stageName, @Nullable String stageDescription, boolean isManual, boolean isFinal) throws WebValidationException {
        ImmutableChain chain = this.getAndValidateIsWritableChain(planKey);
        if (chain.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("stage.add.error.branch"));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(this.validationService.validateName(STAGE_NAME, "stage", stageName));
        stageName = StringUtils.trim((String)stageName);
        if (chain.containsStage(stageName)) {
            errorCollection.addError(STAGE_NAME, this.textProvider.getText("stage.name.exists"));
        }
        errorCollection.addErrorCollection(this.validationService.validateDescription(STAGE_DESCRIPTION, stageDescription));
        return errorCollection;
    }

    @NotNull
    public ImmutableChainStage addStage(@NotNull PlanKey planKey, @NotNull String stageName, @Nullable String stageDescription, boolean isManual, boolean isFinal) throws WebValidationException {
        LimitedConcurrencyCaller.Callable addStageFunctor = () -> {
            BambooValidationUtils.checkErrors(this.validateStageForAdd(planKey, stageName, stageDescription, isManual, isFinal));
            Chain chain = this.getMutableChain(planKey);
            ChainPropagatingFacade chainAndBranches = new ChainPropagatingFacade(this.chainBranchManager, chain);
            ChainStage stage = chainAndBranches.addAndSaveNewStage(this.planManager, this.eventPublisher, stageName, stageDescription, isManual, isFinal);
            this.auditLogService.log("Stage has been created.", (Key)chain.getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, stageName));
            return stage;
        };
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(addStageFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    @NotNull
    public ErrorCollection validateStageForUpdate(@NotNull PlanKey planKey, long stageId, @Nullable String name, @Nullable String description, boolean manual, boolean isFinal) throws WebValidationException {
        ImmutableChainStage originalStage = this.getStage(planKey, stageId);
        ImmutableChain chain = originalStage.getChain();
        if (chain.hasMaster()) {
            return new SimpleErrorCollection(this.textProvider.getText("stage.add.error.branch"));
        }
        if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.WRITE, (Object)chain, null)) {
            throw new AccessDeniedException(this.textProvider.getText("stage.error.permission"));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorCollection(this.validationService.validateName(STAGE_NAME, "stage", name));
        name = StringUtils.trim((String)name);
        ImmutableChainStage withSameName = chain.getStages().stream().filter(NameProviderFunctions.isNameEqual((String)name)).findFirst().orElse(null);
        if (withSameName != null && withSameName.getId() != originalStage.getId()) {
            errorCollection.addError(STAGE_NAME, this.textProvider.getText("stage.name.exists"));
        }
        errorCollection.addErrorCollection(this.validationService.validateDescription(STAGE_DESCRIPTION, description));
        return errorCollection;
    }

    @NotNull
    public ImmutableChainStage moveStage(@NotNull PlanKey planKey, long stageId, int index) throws WebValidationException {
        LimitedConcurrencyCaller.Callable moveStageFunctor = () -> {
            AtomicReference webValidationException = new AtomicReference();
            try {
                return (ImmutableChainStage)this.transactionTemplate.execute(session -> {
                    try {
                        this.getAndValidateIsWritableChain(planKey);
                        Chain chain = this.getMutableChain(planKey);
                        ChainStage stage = this.getMutableStage(chain, stageId);
                        int originalIndex = chain.getAllStages().indexOf(stage);
                        List brokenArtifactSubscriptions = this.artifactSubscriptionManager.validateSubscriptionsForMovedStage((ImmutableChainStage)stage, index);
                        this.artifactSubscriptionManager.removeArtifactSubscriptions((Collection)brokenArtifactSubscriptions);
                        this.moveStage(chain.getAllStages(), stage, index);
                        this.planManager.savePlan((Plan)chain);
                        this.auditUpdateStageIndex(planKey, stage.getName(), originalIndex, index);
                        return this.getStage(planKey, stageId);
                    }
                    catch (NotFoundException | AccessDeniedException e) {
                        webValidationException.set(new WebValidationException(e.getMessage()));
                        throw new RuntimeException("Exception occurred while moving stage to new position", e);
                    }
                    catch (WebValidationException e) {
                        webValidationException.set(e);
                        throw new RuntimeException("Exception occurred while moving stage to new position", e);
                    }
                });
            }
            catch (RuntimeException e) {
                WebValidationException cause = (WebValidationException)((Object)((Object)webValidationException.get()));
                if (cause != null) {
                    log.debug(null, (Throwable)e);
                    throw cause;
                }
                throw e;
            }
        };
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, ScopedExclusionServiceHelper.adapt(moveStageFunctor));
    }

    @VisibleForTesting
    void moveStage(@NotNull List<ChainStage> allStages, @NotNull ChainStage stage, int index) {
        allStages.remove(stage);
        allStages.add(Math.min(index, allStages.size()), stage);
    }

    @NotNull
    public ImmutableChainStage updateStage(final @NotNull PlanKey planKey, final long stageId, final @NotNull String name, final @NotNull String description, final boolean manual, final boolean isFinal, final @Nullable Integer index, final BambooClosures.Throwing1<ImmutableChainStage, WebValidationException> ... runBefore) throws WebValidationException {
        Preconditions.checkNotNull((Object)planKey, (Object)"planKey cannot be null");
        LimitedConcurrencyCaller.Callable<ImmutableChainStage, WebValidationException> updateStageFunctor = new LimitedConcurrencyCaller.Callable<ImmutableChainStage, WebValidationException>(){

            @Override
            public ImmutableChainStage call() throws WebValidationException {
                BambooValidationUtils.checkErrors(StageServiceImpl.this.validateStageForUpdate(planKey, stageId, name, description, manual, isFinal));
                Chain chain = StageServiceImpl.this.getMutableChain(planKey);
                ChainStage originalStage = StageServiceImpl.this.getMutableStage(chain, stageId);
                for (BambooClosures.Throwing1 closure : runBefore) {
                    closure.run((Object)originalStage);
                }
                ChainStagePropagatingFacade updateStage = new ChainStagePropagatingFacade(StageServiceImpl.this.chainBranchManager, originalStage);
                updateStage.setName(StringUtils.defaultString((String)name.trim()));
                updateStage.setDescription(StringUtils.defaultString((String)description).trim());
                updateStage.setManual(manual);
                if (index != null) {
                    List brokenArtifactSubscriptions = StageServiceImpl.this.artifactSubscriptionManager.validateSubscriptionsForMovedStage((ImmutableChainStage)originalStage, index.intValue());
                    StageServiceImpl.this.artifactSubscriptionManager.removeArtifactSubscriptions((Collection)brokenArtifactSubscriptions);
                    List allStages = chain.getAllStages();
                    allStages.remove(originalStage);
                    allStages.add(Math.min(index, allStages.size()), updateStage.getStageForChain(chain));
                }
                updateStage.savePlan(StageServiceImpl.this.planManager);
                StageServiceImpl.this.auditUpdateStage(chain, originalStage, name, planKey, description, stageId, manual, index);
                return StageServiceImpl.this.getStage(planKey, stageId);
            }
        };
        ScopedExclusionService.ExclusiveFunction functor = ScopedExclusionServiceHelper.adapt(updateStageFunctor);
        return ScopedExclusionServiceHelper.withLockedChain(this.scopedExclusionService, planKey, functor);
    }

    public void deleteStage(@NotNull PlanKey planKey, long stageId, BambooClosures.Throwing1<ImmutableChainStage, WebValidationException> ... runBefore) throws WebValidationException {
        Chain chain = this.getMutableChain(planKey);
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.ADMINISTRATION, (ImmutablePlan)chain)) {
            throw new AccessDeniedException(this.textProvider.getText("stage.error.permission"));
        }
        ChainStage stage = this.getMutableStage(chain, stageId);
        BambooValidationUtils.validate(!this.isStageRunning(stage), () -> this.textProvider.getText("plan.delete.active"));
        for (BambooClosures.Throwing1<ImmutableChainStage, WebValidationException> closure : runBefore) {
            closure.run((Object)stage);
        }
        this.deletionService.deleteStage(stage);
    }

    @NotNull
    private ImmutableChain getAndValidateIsWritableChain(@NotNull PlanKey planKey) throws NotFoundException, AccessDeniedException {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(planKey, ImmutableChain.class);
        if (chain == null) {
            throw new NotFoundException(this.textProvider.getText("chain.error.noChain", Arrays.asList(planKey.getKey())));
        }
        if (!this.bambooPermissionManager.hasPlanPermission((Permission)BambooPermission.WRITE, (ImmutablePlan)chain)) {
            throw new AccessDeniedException(this.textProvider.getText("stage.error.permission"));
        }
        return chain;
    }

    @NotNull
    private Chain getMutableChain(@NotNull PlanKey planKey) {
        Chain chain = (Chain)this.planManager.getPlanByKeyIfOfType(planKey, Chain.class);
        if (chain == null) {
            throw new NotFoundException(this.textProvider.getText("chain.error.noChain", Arrays.asList(planKey.getKey())));
        }
        return chain;
    }

    @NotNull
    private ImmutableChainStage getStage(@NotNull ImmutableChain chain, long stageId) {
        return this.getStageById(chain.getStages(), stageId);
    }

    @NotNull
    private ChainStage getMutableStage(@NotNull Chain chain, long stageId) {
        return (ChainStage)this.getStageById(chain.getStages(), stageId);
    }

    @NotNull
    private <T extends ImmutableChainStage> T getStageById(Collection<T> stages, long stageId) {
        Optional<ImmutableChainStage> opt = stages.stream().filter(stage -> stage.getId() == stageId).findFirst();
        return (T)opt.orElseThrow(() -> new NotFoundException(this.textProvider.getText("stage.error.noStage", Collections.singletonList(stageId))));
    }

    private boolean isStageRunning(@NotNull ChainStage stage) {
        for (Job job : stage.getJobs()) {
            JobStatusHelper jobStatusHelper = new JobStatusHelper((ImmutableJob)job, this.buildExecutionManager);
            if (!jobStatusHelper.isActive()) continue;
            return true;
        }
        return false;
    }

    private ImmutableChainStage auditUpdateStage(Chain chain, ChainStage originalStage, String name, PlanKey planKey, String description, long stageId, Boolean isManual, Integer index) throws WebValidationException {
        String oldName = originalStage.getName();
        String oldDescription = originalStage.getDescription();
        boolean oldIsManual = originalStage.isManual();
        int oldIndex = chain.getAllStages().indexOf(originalStage);
        this.auditLogService.log("stageName", oldName, name, (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, name));
        this.auditLogService.log("stageDescription", oldDescription, StringUtils.defaultString((String)description), (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, name));
        this.auditLogService.log("isManualStage", Boolean.toString(oldIsManual), Boolean.toString(isManual), (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, name));
        if (index != null) {
            this.auditUpdateStageIndex(planKey, name, oldIndex, index);
        }
        return this.getStage(planKey, stageId);
    }

    private void auditUpdateStageIndex(@NotNull PlanKey planKey, @NotNull String stageName, int oldIndex, int index) {
        this.auditLogService.log("stageIndex", Integer.toString(oldIndex), Integer.toString(index), (Key)planKey, AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, stageName));
    }
}

