/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.task;

import com.atlassian.bamboo.task.DecoratedTaskDefinition;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecoratedTaskDefinitionImpl<T extends TaskContainer>
extends TaskDefinitionImpl
implements DecoratedTaskDefinition<T> {
    private static final Logger log = Logger.getLogger(DecoratedTaskDefinitionImpl.class);
    private final TaskModuleDescriptor taskModuleDescriptor;
    private final T taskContainer;

    public DecoratedTaskDefinitionImpl(@NotNull TaskDefinition taskDefinition, @Nullable TaskModuleDescriptor taskModuleDescriptor, @NotNull T taskContainer) {
        super(taskDefinition.getId(), taskDefinition.getPluginKey(), taskDefinition.getUserDescription(), taskDefinition.isEnabled(), taskDefinition.getConditions(), taskDefinition.getConfiguration(), taskDefinition.isFinalising());
        this.taskModuleDescriptor = taskModuleDescriptor;
        this.taskContainer = taskContainer;
    }

    public boolean isValid() {
        return this.taskModuleDescriptor != null;
    }

    @NotNull
    public String getName() {
        return this.taskModuleDescriptor != null ? this.taskModuleDescriptor.getName() : this.getPluginKey();
    }

    @NotNull
    public T getTaskContainer() {
        return this.taskContainer;
    }

    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonTaskObject = new JSONObject();
        jsonTaskObject.put("id", this.getId());
        jsonTaskObject.put("name", (Object)this.getName());
        jsonTaskObject.put("description", (Object)this.getUserDescription());
        jsonTaskObject.put("isEnabled", this.isEnabled());
        jsonTaskObject.put("isConditional", !this.getConditions().isEmpty());
        jsonTaskObject.put("valid", this.isValid());
        return jsonTaskObject;
    }
}

