/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.task;

import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.plan.task.DecoratedTaskDefinitionImpl;
import com.atlassian.bamboo.task.DecoratedTaskDefinition;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import com.atlassian.bamboo.task.TaskService;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.struts.TextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class TaskServiceImpl
implements TaskService {
    @Inject
    private TaskManager taskManager;
    @Inject
    private TextProvider textProvider;

    @NotNull
    public <T extends TaskContainer> List<DecoratedTaskDefinition<T>> getDecoratedTaskDefinitions(@NotNull T taskContainer) {
        return taskContainer.getTaskDefinitions().stream().map(TaskServiceImpl.getTaskDefinitionConverter(this.taskManager, taskContainer)).collect(Collectors.toCollection(ArrayList::new));
    }

    @NotNull
    public <T extends TaskContainer> DecoratedTaskDefinition<T> getDecoratedTaskDefinition(@NotNull T taskContainer, long taskId) {
        Optional<DecoratedTaskDefinition> taskDefinition = this.getDecoratedTaskDefinitions(taskContainer).stream().filter(arg_0 -> BambooPredicates.hasTaskDefinitionEqualId(taskId).apply(arg_0)).findFirst();
        return taskDefinition.orElseThrow(() -> new NotFoundException(this.textProvider.getText("tasks.error.noTask", Collections.singletonList(Long.toString(taskId)))));
    }

    private static <T extends TaskContainer> Function<TaskDefinition, DecoratedTaskDefinition<T>> getTaskDefinitionConverter(@NotNull TaskManager taskManager, @NotNull T taskContainer) {
        return taskDefinition -> {
            TaskModuleDescriptor moduleDescriptor = taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
            return new DecoratedTaskDefinitionImpl<TaskContainer>((TaskDefinition)taskDefinition, moduleDescriptor, taskContainer);
        };
    }
}

