/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.trigger;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.plan.trigger.PlanTriggerResult;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildChanges;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ExperimentalApi
public final class PlanTriggerResultBuilder {
    private static final Logger log = Logger.getLogger(PlanTriggerResultBuilder.class);
    private BuildChanges buildChanges;
    private final ErrorCollection errorCollection = new SimpleErrorCollection();
    private final Map<String, String> variables;

    private PlanTriggerResultBuilder(Map<String, String> variables) {
        this.variables = new HashMap<String, String>(variables);
    }

    public static PlanTriggerResultBuilder create(Map<String, String> variables) {
        return new PlanTriggerResultBuilder(variables);
    }

    public PlanTriggerResultBuilder addBuildChanges(@NotNull BuildChanges buildChanges) {
        this.buildChanges = buildChanges;
        return this;
    }

    public PlanTriggerResultBuilder addErrorMessage(@NotNull String message, @NotNull Exception e) {
        this.errorCollection.addErrorMessage(message, e);
        return this;
    }

    public PlanTriggerResultBuilder addErrorMessage(@NotNull String message) {
        this.errorCollection.addErrorMessage(message);
        return this;
    }

    public PlanTriggerResultBuilder addVariable(@NotNull String name, @NotNull String value) {
        this.variables.put(name, value);
        return this;
    }

    public PlanTriggerResultBuilder removeVariable(@NotNull String name) {
        this.variables.remove(name);
        return this;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    public PlanTriggerResult build() {
        return new BuildTriggerResultImpl(this.buildChanges, this.errorCollection, this.variables);
    }

    public final class BuildTriggerResultImpl
    implements PlanTriggerResult {
        private final BuildChanges buildChanges;
        private final ErrorCollection errorCollection;
        private final Map<String, String> variableMap;

        public BuildTriggerResultImpl(BuildChanges buildChanges, ErrorCollection errorCollection, Map<String, String> variableMap) {
            this.buildChanges = buildChanges;
            this.errorCollection = errorCollection;
            this.variableMap = variableMap;
        }

        @NotNull
        public BuildChanges getBuildChanges() {
            return this.buildChanges;
        }

        @NotNull
        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        @NotNull
        public Map<String, String> getVariableMap() {
            return this.variableMap;
        }
    }
}

